/**
 *
 */
import React, { Component } from "react";
import { connect } from "dva";
import { Pagination, message, Icon, Modal, Button, Tooltip } from "antd";
// import SendBar from "./SendBar";
import tim from "../../../../../utils/im/imInitialize";
import eventCenter from "@common/events"; // 引入 EventEmitter
const { confirm } = Modal;
@connect((state) => ({
  conversationList: state.im.conversationList,
  currentConversation: state.im.currentConversation,
  nextReqMessageID: state.im.nextReqMessageID,
  isCompleted: state.im.isCompleted,
  currentMessageList: state.im.currentMessageList,
}))
export default class Group extends Component {
  constructor(props) {
    super(props);
    this.state = {
      height: null, //最大高度
    };
  }

  componentDidMount() {
    const height = document.documentElement.clientHeight - 120 - 130 - 40;
    this.setState({ height });
  }
  componentWillReceiveProps(nextProps) {}

  //切换会话
  selectConversation(conversationID) {
    this.props.changeImStatus(true); //将侧边栏的im状态打开
    // 1.切换会话前，将切换前的会话进行已读上报
    if (this.props.conversationID) {
      tim.setMessageRead({
        conversationID:
          this.props.conversation && this.props.conversation.conversationID,
        // conversationID: this.props.conversationID
      });
    }
    // 2.待切换的会话也进行已读上报
    tim.setMessageRead({ conversationID });
    this.props.dispatch({
      type: "im/totalUnreadCount",
      payload: "",
    });
    // 3. 获取会话信息
    return tim.getConversationProfile(conversationID).then(
      ({ data }) => {
        // console.log(data);
        // // 3.1 更新当前会话
        this.props.dispatch({
          type: `im/updateCurrentConversation`,
          payload: data.conversation,
        });
        // 3.2 获取消息列表
        this.getMessageList(conversationID);
        return Promise.resolve();
      },
      (err) => {
        message.error(err.toString());
      }
    );
  }
  getMessageList(conversationID) {
    if (this.props.isCompleted) {
      message.info("没有更多的历史消息了");
      return;
    }
    const { nextReqMessageID, currentMessageList } = this.props;
    tim
      .getMessageList({ conversationID, nextReqMessageID, count: 15 })
      .then((imReponse) => {
        // 更新messageID，续拉时要用到
        // console.log(imReponse)
        this.props.dispatch({
          type: "im/updateCurrentConversationCont",
          payload: {
            nextReqMessageID: imReponse.data.nextReqMessageID,
            isCompleted: imReponse.data.isCompleted,
            currentMessageList: [
              ...imReponse.data.messageList,
              ...currentMessageList,
            ], // 更新当前消息列表，从头部插入
          },
        });
      });
  }
  render() {
    return (
      <div className="data-list group">
        <div className="security search-list_command amap_lib_placeSearch">
          <div
            className="list"
            style={{ maxHeight: this.state.height, overflow: "auto" }}
          >
            {this.props.conversationList.map((item, index) => {
              if (item.type == "GROUP") {
                const name = item.groupProfile.name;
                const avatar = require("../../../../../assets/images/prevention/group.png");
                return (
                  <div
                    key={index}
                    className="item"
                    onClick={() => {
                      this.selectConversation(item.conversationID);
                    }}
                  >
                    <div className="poibox">
                      <img
                        className="img"
                        src={avatar}
                        style={{ margin: "8px 10px 0 0" }}
                      ></img>

                      <div style={{ marginLeft: 45 }}>
                        <div className="name" style={{ fontSize: "16px" }}>
                          {name || "---"}
                        </div>
                        <div className="text" style={{ margin: "10px 0" }}>
                          <span
                            className="send-header-bar"
                            style={{ float: "unset" }}
                          >
                            <Tooltip placement="bottom" title="文字调度">
                              <Icon
                                type="form"
                                style={{ fontSize: "17px" }}
                                onClick={(e) => {
                                  this.selectConversation(item.conversationID);
                                }}
                              />
                            </Tooltip>
                            <Tooltip
                              placement="bottom"
                              title="语音调度"
                              onClick={(e) => {
                                const list = {
                                  photoUrl: avatar,
                                  name,
                                  conversonGroupID: item.conversationID,
                                  group: item.groupProfile.groupID,
                                };
                                e.stopPropagation(), //合成事件停止冒泡
                                  // this.props.clickTextScheduling(list, "voice");
                                  eventCenter.emit('clickTextScheduling', {
                                    item,
                                    type: "voice",
                                  });
                              }}
                            >
                              <Icon type="audio" style={{ fontSize: "17px" }} />
                            </Tooltip>
                            <Tooltip
                              placement="bottom"
                              title="视频调度"
                              onClick={(e) => {
                                e.stopPropagation(); //
                                const options = {
                                  groupID: item.groupProfile.groupID,
                                  count: 100,
                                };
                                tim
                                  .getGroupMemberList(options)
                                  .then((res) => {
                                    if (res.code == 0) {
                                      const list = res.data.memberList.map(
                                        (value) => {
                                          return {
                                            value,
                                            mobilePhone: value.userID,
                                            photoUrl: value.avatar,
                                            name: value.nick,
                                          };
                                        }
                                      );
                                      console.log(list);
                                      this.props.groupVideo(list);
                                      //   this.props.clickTextScheduling(
                                      //     list,
                                      //     "video"
                                      //   );
                                    }
                                  })
                                  .catch((err) => {
                                    console.log(err);
                                  });
                              }}
                            >
                              <Icon
                                type="video-camera"
                                style={{ fontSize: "17px" }}
                              />
                            </Tooltip>
                            {/* <Tooltip
                              placement="bottom"
                              title="解散群聊"
                              onClick={(e) => {
                                e.stopPropagation(); //
                                confirm({
                                  title: '解散群组后，该群组内的聊天记录将会被清空，是否解散?',
                                  okText: "解散",
                                  okType: 'danger',
                                  cancelText: '取消',
                                  onOk() {
                                    tim
                                      .dismissGroup(item.groupProfile.groupID)
                                      .then((res) => {
                                        console.log(res)
                                      })
                                      .catch((err) => {
                                        console.log(err);
                                      });
                                  },
                                  onCancel() {
                                    console.log('Cancel');
                                  },
                                });
                              }}
                            >
                              <Icon type="usergroup-delete" style={{ fontSize: "17px" }}/>
                            </Tooltip> */}
                          </span>
                        </div>
                      </div>
                    </div>
                  </div>
                );
              }
            })}
            {JSON.stringify(this.props.conversationList).indexOf(
              '"type":"GROUP"'
            ) == -1 && (
              <div
                style={{
                  textAlign: "center",
                  fontSize: "14px",
                  color: "#afb0b1",
                }}
              >
                暂无数据
              </div>
            )}
          </div>
        </div>
      </div>
    );
  }
}
