/**
 *
 */
import React, { Component } from "react";
import { connect } from "dva";
import eventCenter from "@common/events"; // 引入 EventEmitter
import { Pagination, message, Icon, Input, Button, Tooltip } from "antd";
@connect((state) => ({
  conversationList: state.im.conversationList,
}))
export default class SendBar extends Component {
  constructor(props) {
    super(props);
    this.state = {

    };
  }

  componentWillReceiveProps(nextProps) {}
  render() {
    return (
      <span className="send-header-bar">
        <Tooltip placement="bottom" title="文字调度">
          <Icon
            type="form"
            style={{ fontSize: "17px" }}
            onClick={(e) => {
              // e.stopPropagation(), //合成事件停止冒泡
                // this.props.clickTextScheduling(e, "text");
                eventCenter.emit('clickTextScheduling', {
                  item,
                  type: "text"
                });
            }}
          />
        </Tooltip>
        <Tooltip
          placement="bottom"
          title="语音调度"
          onClick={(e) => {
            // e.stopPropagation(), //合成事件停止冒泡
              // this.props.clickTextScheduling(e, "voice");
              eventCenter.emit('clickTextScheduling', {
                item,
                type: "voice"
              });
          }}
        >
          <Icon type="audio" style={{ fontSize: "17px" }} />
        </Tooltip>
        <Tooltip
          placement="bottom"
          title="视频调度"
          onClick={(e) => {
            // e.stopPropagation(), //合成事件停止冒泡
              // this.props.clickTextScheduling(e, "video");
              eventCenter.emit('clickTextScheduling', {
                item,
                type: "video"
              });
          }}
        >
          <Icon type="video-camera" style={{ fontSize: "17px" }} />
        </Tooltip>
      </span>
    );
  }
}
