import React, { PureComponent } from "react";
import PersonList from './PersonList';
import AttendanceList from './AttendanceList';
import { connect } from "dva";
import { Tabs } from "antd";
import { policeAddPictueMarks, policeReduceMarks } from '../../../GIS/Police/EventListTab/func';
import '../../../../Command/command.less'
const { TabPane } = Tabs;
@connect((state) => ({
  selectedId: state.command.policeData.selectedId,
  mapStyle: state.command.mapStyle
}))
export default class EventListTab extends PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      clickTab: '1',//当前是哪个tab
    };
  }
  render() {
    const {mapStyle} =this.props
    return (
      <div className={mapStyle+" EventListTab"} style={{ opacity: '0.8' }}>
        <div
          className='drawer_container_tab'
          style={{ boxShadow: "unset", width: '294px' }}
        >
          <Tabs
            // defaultActiveKey={"2"}
            onChange={(index) => {
              if (this.props.selectedId) {
                this.props.dispatch({
                  type: "command/setPoliceSelectIndex",
                  payload: null,
                });
              }
              this.setState({
                clickTab: index,//用于关掉别的tab的打点信息
              })
            }}
          >
            <TabPane tab="人员信息" key="1">
              <PersonList
                clickTab={this.state.clickTab}
                _thisGIS={this.props._thisGIS}
                addPoliceMarks={(addData, place, tab) => {
                  //打点
                  policeAddPictueMarks.call(this.props._thisGIS, addData, place, tab)
                }}
                reducePoliceMarks={(reduceData, place, tab) => {
                  policeReduceMarks.call(this.props._thisGIS, reduceData, place, tab)
                }}
              />
            </TabPane>
            <TabPane tab="驻勤信息" key="2">
              <AttendanceList
                clickTab={this.state.clickTab}
                _thisGIS={this.props._thisGIS}
                addPoliceMarks={(addData, place, tab) => {
                  //打点
                  policeAddPictueMarks.call(this.props._thisGIS, addData, place, tab)
                }}
                reducePoliceMarks={(reduceData, place, tab) => {
                  policeReduceMarks.call(this.props._thisGIS, reduceData, place, tab)
                }}/>
            </TabPane>
          </Tabs>
        </div>
      </div>
    );
  }
}
