/**
 * 这里主要是抽离出警保联动图层放在GIS的公共方法
 */
import {
  markPolice,
} from "@mapModule/markMarkers.js";

//一张图数据展示的增加打点
export function policeAddPictueMarks(addData, place, tab) {
  // if (data.length == 0) {
  //   return message.warning("该部门暂无定位数据");
  // }
  const policeMarkers = markPolice.call(this, addData);
  //打点到地图中
  this.state.map.add(policeMarkers)
  this.state.map.setFitView(policeMarkers)
  //添加打点位置到缓存
  this.props.dispatch({
    type: "command/fetchPoliceData",
    payload: {
      options: 'add',
      tab,
      place,
      markerData: policeMarkers,
      personData:addData
    },
  });
}

//一张图数据展示的减少打点
export function policeReduceMarks(reduceData, place, tab) {
  if (reduceData && reduceData.length > 0) {
    this.state.map.remove(reduceData)
    //清除打点信息（因为每次打点的信息都是不一样的，需要随时更新）
    this.props.dispatch({
      type: "command/fetchPoliceData",
      payload: {
        options: 'reduce',
        tab,
        place,
        markerData: null
      },
    });
  }
}
