/**
 * 这里主要是抽离出一张图图层放在GIS的公共方法
 * @param where:数据展示（‘’）/周边搜索（ searchAround ）
 */
import {
  message,
} from "antd";
import {
  markPicture,
} from "@mapModule/markMarkers";
import securityResourceImg from "@assets/images/prevention/aPicture/securityResource.png";
import securityResourceCheckedPng from "@assets/images/prevention/aPicture/securityResourceChecked.png";
import securityCompanyPng from "@assets/images/prevention/aPicture/securityCompany.png";
import attendancePointPng from "@assets/images/prevention/aPicture/attendancePoint.png";
import searchAddressPng from "@assets/images/prevention/aPicture/searchAddress.png";
import { isEmpty } from '@utils/utils';

//一张图数据展示的增加打点
export function APictureAddPictueMarks(addData, type, where = '') {
  if (addData.data.length == 0) {
    return message.warning("该分类暂无打点数据");
  }
  console.log('查看打点信息', addData, type);
  switch (type) {
    case 'searchAddress':
      addData.mapIcon = searchAddressPng;
      break;
    case 'securityResource':
    case 'attendancePolice':
      addData.mapIcon = securityResourceImg;
      addData.clickMarkerIcon = securityResourceCheckedPng;
      break;
    case 'securityCompany':
      addData.mapIcon = securityCompanyPng;
      break;
    case 'attendancePoint':
      addData.mapIcon = attendancePointPng;
      break;
  }
  const pictureMarkers = markPicture.call(this, addData, type, where);
  const { pictureMarks,pictureDatas } = pictureMarkers;
  if (pictureMarks.length == 0) {
    return message.warning("该分类暂无打点数据");
  }
  this.state.map.add(pictureMarks)
  this.state.map.setFitView(pictureMarks)
  if (!where) {
    //添加打点位置到缓存
    this.props.dispatch({
      type: "command/setPictureMarks",
      payload: {
        options: 'add',
        type,
        name: !isEmpty(addData.name) ? addData.name : type,
        markerData: pictureMarks,
        pictureDatas: pictureDatas,
      },
    });
  } else {
    //添加打点位置到缓存
    this.props.dispatch({
      type: "command/setSearchViewMark",
      payload: {
        options: 'add',
        name: !isEmpty(addData.name) ? addData.name : type,
        type: where.type,
        markerData: pictureMarks,
        pictureDatas: pictureDatas,
      },
    });
  }
}

//一张图数据展示的减少打点
export function APictureReducePictueMarks(reduceData, type, where = '') {
  if (reduceData && reduceData.data && reduceData.data.length > 0) {
    this.state.map.remove(reduceData.data)
    //清除打点信息（因为每次打点的信息都是不一样的，需要随时更新）
    if (!where) {
      this.props.dispatch({
        type: "command/setPictureMarks",
        payload: {
          options: 'reduce',
          type,
          name: !isEmpty(reduceData.name) ? reduceData.name : type,
          markerData: reduceData.data
        },
      });
    } else {
      //添加打点位置到缓存
      this.props.dispatch({
        type: "command/setSearchViewMark",
        payload: {
          options: 'reduce',
          type: where.type,
          name: !isEmpty(reduceData.name) ? reduceData.name : type,
          markerData: reduceData.data,
        },
      });
    }
  }
}
