/**
 * 驻勤点和保安员信息
 */
import React, { Component } from "react";
import { Icon, Tabs, Radio } from 'antd';
import styles from "./index.less";
import { connect } from "dva";
import EmployeesList from "./EmployeesList"
import DutyPersonList from "./DutyPersonList"
import AllPerson from '../SearchListTab/PersonMessage/AllPerson';
import { attendanceGetTypeData } from '@services/api';
import eventCenter from "@common/events"; // 引入 EventEmitter
import classNames from "classnames";
import { recordTo, recordBack, recordRemove, recordAdd } from '@common/recordHistory';
import { showAttendPointInfo } from '@gis/biz';

const { TabPane } = Tabs;
const _TABS = [{
  name: '人员信息',
  tabKey: 1,
}, {
  name: '驻勤信息',
  tabKey: 2
}];
@connect((state) => ({
  //地图数据
  pictureMarkersList: state.command.pictureMarkersList,
  mapStyle: state.command.mapStyle,
  selectComponeyInfo: state.command.selectComponeyInfo,
  backStepInfo: state.command.backStepInfo,
  mapLayerSwitchState: state.command.mapLayerSwitchState,
}))
export default class ComponeyInfo extends Component {
  constructor(props) {
    super(props);
    this.state = {
      personType: 'A',
      tabKey: this.props.selectComponeyInfo.clickType != 'personnel' ? "2" : "1",
      clickType: ''
    };
  }
  componentDidMount() {
    this.setState({
      tabKey: this.props.selectComponeyInfo.clickType != 'personnel' ? "2" : "1",
      clickType: this.props.selectComponeyInfo.clickType
    })
  }
  componentWillReceiveProps(nextProps) {
    const clickType = nextProps.selectComponeyInfo.clickType;
    const tabKey = clickType != 'personnel' ? "2" : "1";
    if(clickType && clickType != this.state.clickType) {
      if (tabKey !== this.state.tabKey) {
        this.setState({
          tabKey,
          personType: 'A',
          clickType
        });
      }
    }
  }
  // 利用此事件来决定何时需要重新渲染组件。
  shouldComponentUpdate(nextProps, nextState) {
    if( nextProps.mapStyle !== this.props.mapStyle ||
      nextState.personType !== this.state.personType ||
      nextState.tabKey !== this.state.tabKey)
    {
      return true;
    }
    return false;
  }
  // 人员信息下 tab 切换
  changePersonType = (e)=>{
    eventCenter.emit('clearMapTag', 'securityResource');
    this.setState({
      personType: e.target.value
    })
  }
  // tab 切换
  onTabChange=(key)=>{
    eventCenter.emit('clearMapTag');
    let setJson = {}
    if (key == "1") { //人员信息
      setJson = {
        personType: 'A'
      }
    } else {
    }
    setJson.tabKey = key;
    this.setState(setJson)
  }
  onClose=()=>{
    const that = this;
    this.props.dispatch({
      type: 'command/setSelectComponeyInfo',
      payload: {}
    })
    this.props.dispatch({
      type: "command/fetchPersonList",
      payload: {
        list: [],
      },
    });
    eventCenter.emit('clearMapTag');


    recordBack({
      from: 'ComponeyInfo',
      callback: (result)=>{
        switch (result.from) {
          case "CreateTrajectoryInfoWindow":
            recordBack({
              from: result.from,
              callback: (result)=>{
                const data = JSON.parse(JSON.stringify(result));
                recordRemove({
                  from: result.from,
                  toID: result.toID
                })
                recordTo(data, that);
              }
            });
            break;
          case "CreateAttendPointInfoWindow":
            const data = JSON.parse(JSON.stringify(result));
            recordRemove({
              from: result.from,
              toID: result.toID
            })
            recordTo(data, that);
            break;
          case "CreateComponeyInfoWindow":
            recordBack({
              from: result.from,
              callback: (result)=>{
                const data = JSON.parse(JSON.stringify(result));
                recordRemove({
                  from: result.from,
                  toID: result.toID
                })
                recordTo(data, that);
              }
            });
            break;
        }
      }
    });
  }
  onPersonClick=(item)=>{
    const {  selectComponeyInfo } = this.props
    console.log('onPersonClick', item);
    recordAdd({
      from: 'ComponeyInfo',
      to: 'CreateTrajectoryInfoWindow',
      fromData: selectComponeyInfo,
      toID: item.ID
    });
  }
  render() {
    const {  mapStyle,selectComponeyInfo, mapLayerSwitchState } = this.props
    const { personType, tabKey } = this.state
    const cls = mapLayerSwitchState.eventViews ? classNames('map-modal-optimizing-level2', styles.componey) : classNames('map-modal-optimizing-level1', styles.componey);
    console.log('Componey-render');
    return (
      <div className={styles[mapStyle]}>
        <div className={cls}>
          <div className={styles.componey_box}>
            <Icon style={{ float: 'right', cursor: 'pointer' }} type="close" onClick={this.onClose} />
            <div className={styles.componey_info}>
              <div>
                <img src={selectComponeyInfo.componeyLogo} alt="" />
              </div>
              <div className={styles.info}>
                <div className={styles.info_item}>
                  所属公司：<div title={selectComponeyInfo.companyName} style={{ width: '98px' }}>{selectComponeyInfo.companyName}</div>
                </div>
                <div className={styles.info_item}>
                  法人/负责人：<div>{selectComponeyInfo.name}</div>
                </div>
                <div className={styles.info_item}>
                  联系电话：<div>{selectComponeyInfo.mobilePhone}</div>
                </div>
              </div>
            </div>
          </div>
          <div className={styles.content}>
            <div className={styles.tabs}>
              { _TABS.map((tab)=>{
                const clsName = classNames(styles.tab_pane, tabKey == tab.tabKey ? styles.tab_active: '' );
                return <div className={clsName} onClick={this.onTabChange.bind(this, tab.tabKey)}>
                  {tab.name}
                </div>
              }) }
            </div>
            {
              tabKey == 1 ? <div>
                <Radio.Group onChange={this.changePersonType} value={personType} style={{ marginBottom: 8 }}>
                  <Radio.Button value="A">所有人员</Radio.Button>
                  <Radio.Button value="B">通讯录</Radio.Button>
                </Radio.Group>
                {
                  personType == 'A' ?
                  <AllPerson
                    onPersonClick={this.onPersonClick.bind(this)}
                    key="1"
                  /> : null
                }
                {
                  personType == 'B' ? <EmployeesList domainId={selectComponeyInfo.selectComponeyId} /> : null
                }
              </div> : null
            }
            {
              tabKey == 2 ? <DutyPersonList domainId={selectComponeyInfo.selectComponeyId} domainName={selectComponeyInfo.companyName} /> : null
            }
          </div>
        </div>
      </div >
    );
  }
}
