/**
 * 驻勤点和保安员信息
 */
import React, { Component } from "react";
import { Icon, Pagination } from 'antd';
import { getSecurityManByAttendanceId, attendanceGetTypeData, getDomainInfo } from '@services/api';
import styles from "./index.less";
import { connect } from "dva";
import PoliceList from "./PoliceList"
import classNames from "classnames";
import eventCenter from "@common/events"; // 引入 EventEmitter
import { recordTo, recordBack, recordRemove } from '@common/recordHistory';
@connect((state) => ({
  //地图数据
  pictureMarkersList: state.command.pictureMarkersList,
  mapStyle: state.command.mapStyle,
  layoutAuthority: state.command.layoutAuthority,
  selectAttendInfo: state.command.selectAttendInfo,
  backStepInfo: state.command.backStepInfo,
  mapLayerSwitchState: state.command.mapLayerSwitchState
}))
export default class AttendInfo extends Component {
  constructor(props) {
    super(props);
    this.state = {
      attendInfo: {},
      // height: null, //保安员资源列表的最大高度
      allHeight: null,
      policeList: [],
      total: 0,
      loadText: "查看更多",
      searchData: {
        pageNumber: 1,
        pageSize: 5,
        search_smName: '',
      },
    };
  }
  componentDidMount() {
    console.log(this.props.selectAttendInfo)
    const allHeight = document.documentElement.clientHeight - 9 - 340 - 46 - 16;
    this._passAttendanceIdGetPersonList(1);
  }
  _passAttendanceIdGetPersonList(pageNumber = 1, pageSize = 20) {
    // this.props.dispatch({
    //   type: "command/setPersonSelectIndex",
    //   payload: null,
    // });
    getSecurityManByAttendanceId({
      attendanceId: this.props.selectAttendInfo.selectAttendId
    }).then(res => {
      let result = res.data.map((item) => {
        item.perId = item.item_userid
        item.ATTENDANCESITEID = this.props.selectAttendInfo.selectAttendId
        delete item.item_userid
        item.name = item.item_securityname
        delete item.item_securityname
        let lnglatData =item.item_lonlatjson? JSON.parse(item.item_lonlatjson):''
        item.lnglat =lnglatData? [lnglatData.longitude,lnglatData.latitude]:''
        // item.lnglat = [118.051982,24.607542]
        item.longitude = lnglatData.longitude;
        item.latitude = lnglatData.latitude;
        delete item.item_lonlatjson
        item.idCardNo = item.item_documentid
        delete item.item_documentid
        item.companyName = item.item_companyname
        delete item.item_companyname
        item.ATTENDANCESITENAME = item.item_attendancesitename
        delete item.item_attendancesitename
        delete item.item_deptname
        item.mobilePhone = item.item_phone
        delete item.item_phone
        return item
      })
      this.setState({
        policeList: result,
        total: res.data.total,
      });
      // this.props.dispatch({
      //   type: "command/fetchAttendPoliceList",
      //   payload: {
      //     list: result,
      //   },
      // });
      eventCenter.emit('addPictueMarks', {
        data: {
          data: result
        },
        type: "securityResource"
      });
    })
  }
  // 清除助勤点保安员信息
  clearAttendInfo = () => {
    const { selectAttendInfo } = this.props;
    const that = this;
    this.props.dispatch({
      type: "command/fetchPersonList",
      payload: {
        list: [],
      },
    });
    eventCenter.emit('clearMapTag');
    this.props.dispatch({
      type: 'command/setSelectAttendInfo',
      payload: {}
    })


    recordBack({
      from: 'AttendInfo',
      callback: (result)=>{
        if(result.from == "CreateTrajectoryInfoWindow"){
          recordBack({
            from: result.from,
            callback: (result)=>{
              const data = JSON.parse(JSON.stringify(result));
              recordRemove({
                from: result.from,
                toID: result.toID
              })
              recordTo(data, that);
            }
          });
        } else if(result.from == "ComprehensiveSearch"){
          const data = JSON.parse(JSON.stringify(result));
          recordRemove({
            from: result.from,
            toID: result.toID
          })
          recordTo(data, that);
        } else if (result.from == "ComponeyInfo") {
          const data = JSON.parse(JSON.stringify(result));
          recordRemove({
            from: result.from,
            toID: result.toID
          })
          recordTo(data, that);
        }
      }
    });
  }
  /**
   * 向上级传递打点数据
   * @param {*} optionType
   * @param {*} data
   * @param {*} type
   */
  propsOption(optionType, data, type) {
    switch (optionType) {
      case 'add':
        // this.props.addPictueMarks(data, type);
        // event 发送器: eventCenter.emit("事件名称", 参数列表);
        // 这样做的好处是，爷传孙，不需要父级组件做承载
        eventCenter.emit('addPictueMarks', {
          data,
          type
        });
        break;
      case 'reduce':
        eventCenter.emit('reducePictueMarks', {
          data,
          type
        })
        // this.props.reducePictueMarks(data, type);
        break;
    }
  }
  render() {
    const { layerSatatus, mapStyle, layoutAuthority,selectAttendInfo, mapLayerSwitchState } = this.props
    const { attendInfo, policeList, total, searchData, allHeight,loadText } = this.state
    const cls = mapLayerSwitchState.eventViews ? classNames('map-modal-optimizing-level2', styles.attendInfo) : classNames('map-modal-optimizing-level1', styles.attendInfo);
    return (
      <div className={styles[mapStyle]}>
        <div className={cls}>
          <div className={styles.title}>
            <Icon onClick={this.clearAttendInfo} className={styles.back_icon} type="left" />
            <div className={styles.attend_name}>{selectAttendInfo.attendName}</div>
          </div>
          <div className={styles.content} style={{ height: allHeight, }}>
            <div className={styles.attend_info}>
              <div className={styles.attend_item}>
                负责人：<span>{selectAttendInfo.name}</span>
              </div>
              {/* <div className={styles.attend_item}>
                身份证号码：<span>{selectAttendInfo.idCard}</span>
              </div> */}
              <div className={styles.attend_item}>
                手机号码：<span>{selectAttendInfo.phone}</span>
              </div>
              <div className={styles.attend_item}>
                地址：<span>{selectAttendInfo.addressDetail}</span>
              </div>
              <div className={styles.attend_item}>
                保安员数量：<span>{selectAttendInfo.count}名</span>
              </div>
              <div className={styles.attend_item}>
                服务企业类型：<span>{selectAttendInfo.obj}</span>
              </div>

            </div>
            <div className={styles.attend_list}>
              <PoliceList data={policeList}/>
            </div>
            <div
              className="see-more"
              style={{
                cursor: 'pointer',
                display:
                  this.state.total > this.state.policeList.length
                    ? "block"
                    : "none",
              }}
            >
              <span
                onClick={() => {
                  this.setState({
                    loadText: "加载中"
                  })
                  this._passAttendanceIdGetPersonList(1, this.state.total);
                }}
              >
                {loadText}
              </span>
            </div>
          </div>
        </div>
      </div>
    );
  }
}
