/**
 * Created by Administrator on 2017/12/18 0018.驻勤值守
 */
import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const TaskManager = app => {
  let routers = {
    name: '驻勤管理',
    icon: 'renwuguanli',
    path: 'taskmanager',
    children: [
      {
        name: '考勤组管理',
        path: 'tasklist',
        component: dynamicWrapper(app, ['task'], () =>
          import('../routes/TaskManange/TaskList')
        )
      },
      {
        name: '驻勤日报',
        title: '驻勤日报',
        path: 'daystatistics',
        component: dynamicWrapper(app, ['task'], () =>
          import('../routes/TaskManange/Statistics/DayStatistics')
        )
      },
      {
        name: '驻勤月报',
        title: '驻勤月报',
        path: 'monthstatistics',
        component: dynamicWrapper(app, ['task'], () =>
          import('../routes/TaskManange/Statistics/MonthStatistics')
        )
      },
    ]
  };
  return routers;
};
