/**
 * recordList 记录用户的操作
 **/
import { isEmpty } from '@utils/utils';
import eventCenter from "@common/events"; // 引入 EventEmitter
import { showAttendPointInfo } from '@gis/biz';

export const recordHistory = [];

// 添加用户操作行为
export function recordAdd(data){
  if (isEmpty(data)) {
    return;
  }
  recordHistory.push(data);
  console.log('recordHistory-recordAdd', JSON.parse(JSON.stringify(recordHistory)));
}
// 清空用户操作行为
export function recordClean(){
  recordHistory.splice(0, recordHistory.length);
  console.log('recordHistory-recordClean', recordHistory);
}
// 删除用户操作行为
export function recordRemove({from, toID}){
  let current;
  recordHistory.map((item, index)=>{
    if (item.from == from && item.toID == toID) {
      current = index;
    }
  })
  recordHistory.splice(current, recordHistory.length);
  console.log('recordHistory-recordRemove', recordHistory);
}
// 获取用户上一次操作行为
export function recordBack({from, callback = null, navTo = 1}){
  let current;
  recordHistory.map((item, index)=>{
    // console.log(item.to, from);
    if (item.to == from) {
      console.log('recordBack', item.to, from);
      current = index;
    }
  })
  current = current - navTo + 1;
  const currentJSON = recordHistory[current] ? JSON.parse(JSON.stringify(recordHistory[current])) : {}
  console.log('recordHistory-recordBack', currentJSON);
  if (currentJSON.from == from) {
    return recordBack({
      from: from,
      navTo: navTo+1,
      callback: (json)=>{
        callback && callback(json)
      }
    })
  }
  callback && callback(currentJSON)
}
// 返回跳转事件
export function recordTo(data, that = null){
  console.log('recordTo', data.from, data);
  const { fromData, toID } = data
  switch (data.from) {
    case "APictureData":{ // 返回到保安员标记
      eventCenter.emit('showAPictureData', {
        type: toID,
        typeList: fromData
      });
      break;
    }
    case "ComprehensiveSearch":{ // 返回到搜索结果
      eventCenter.emit('isOpenTopSwitch', {
        type: 'searchViews',
        value: true
      });
      setTimeout(()=>{
        eventCenter.emit('showComprehensiveSearch', {
          data: fromData,
          type: toID
        });
      }, 1000);
      break;
    }
    case "CreateAttendPointInfoWindow":
    case "AttendInfo":{ // 返回到驻勤点人员列表
      const selectAttendId = !isEmpty(fromData.selectAttendId) ? fromData.selectAttendId : fromData.ATTENDANCESITEID;
      const companyName = !isEmpty(fromData.componey) ? fromData.componey : fromData.companyName
      showAttendPointInfo({
        aid: selectAttendId,
        companyName: companyName,
        doMainId: fromData.domainid,
        success: function(result){
          that.props.dispatch({
            type: 'command/setSelectAttendInfo',
            payload: result
          })
        }
      });
      break;
    }
    case "ComponeyInfo":{ // 返回到公司架构
      eventCenter.emit('clearMapModal', 'AttendInfo');
      eventCenter.emit('clearMapTag', 'attendancePoint');
      that.props.dispatch({
        type: 'command/setSelectComponeyInfo',
        payload: fromData
      })
      break;
    }
    case "APictureData":{
      eventCenter.emit('showAPictureData', {
        type: toID,
        typeList: fromData
      });
      break;
    }
  }
}

// 获取
export function getRecordLastJSON(){
  const lastJSON = recordHistory.length > 0 ? recordHistory[recordHistory.length - 1] : {};
  return lastJSON
}
