import dynamic from 'dva/dynamic';
import { TaskManager } from './taskManager';
import { Meeting } from './Meeting';
import { FinancialWallet } from './FinancialWallet';
import { InsuranceManagement } from './InsuranceManagement';
import { Command } from './Command';
/**
 * iverry remark
 * 组件动态加载
 * @param {*} app  dva 实例，加载 models 时需要
 * @param {*} models  dva models(redux) 传入字符串，拼接model文件夹对应的名字 
 * @param {*} component 在返回 Promise 的函数，Promise 返回 React Component
 */
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

// nav data
export const getNavData = app => [
  {
    component: dynamicWrapper(app, ['user', 'login'], () =>
      import('../layouts/BasicLayout')
    ),
    layout: 'BasicLayout',
    name: '首页', // for breadcrumb
    path: '/',
    children: [
      //按照顺序显示菜单
      TaskManager(app),
      /**
       * 会议-云会议
       */
      Meeting(app),
      /**
       * 金融保险模块-保险
       */
      InsuranceManagement(app),
      /**
       * 金融保险模块-金融钱包
       */
      FinancialWallet(app),
      /**
      * 防控指挥
      */
      Command(app),
      {
        name: '异常',
        path: 'exception',
        icon: 'warning',
        children: [
          {
            name: '403',
            path: '403',
            component: dynamicWrapper(app, [], () =>
              import('../routes/Exception/403')
            )
          },
          {
            name: '404',
            path: '404',
            component: dynamicWrapper(app, [], () =>
              import('../routes/Exception/404')
            )
          },
          {
            name: '500',
            path: '500',
            component: dynamicWrapper(app, [], () =>
              import('../routes/Exception/500')
            )
          }
        ]
      }
    ]
  },
  {
    component: dynamicWrapper(app, ['user'], () =>
      import('../layouts/UserLayout')
    ),
    path: '/user',
    layout: 'UserLayout',
    children: [
      {
        name: '帐户',
        icon: 'user',
        path: 'user',
        children: [
          {
            name: '登录',
            path: 'LogOn',
            component: dynamicWrapper(app, [], () =>
              import('../routes/User/LogOn')
            )
          },
          {
            name: '认证',
            path: 'AuthSuccess',
            component: dynamicWrapper(app, [], () =>
              import('../routes/User/AuthSuccess')
            )
          },
          {
            name: '账户充值',
            path: 'RechargeSuccess',
            component: dynamicWrapper(app, [], () =>
              import('../routes/User/RechargeSuccess')
            )
          },
        ]
      }
    ]
  },
];
