import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const InsuranceManagement = app => {
  return {
    name: '企业保险',
    icon: 'renshizhaopin',
    path: 'insurancemanagement',
    children: [
      {
        name: '保险商城', //购买在线保险 保险商城
        path: 'insurance-mart',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceMart')
        )
      },
      {
        name: '人员投保管理', //保险方案
        path: 'insurance-management',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/insuranceManagement/Management')
        )
      },
      
      {
        name: '保险保单管理',
        path: 'enterpriseinsurance',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/EnterpriseInsurance')
        )
      },
      {
        name: '', //新增线下保险记录
        title: '企业保险',
        path: 'enterpriseinsurance/insurancedetails',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Enterprise/Company/InsuranceDetails')
        )
      },
      // {
      //   name: '保险购买', //保险购买
      //   path: 'insurancepurchase',
      //   component: dynamicWrapper(app, ['insurance'], () =>
      //     import('../routes/Insurance/InsuranceManagement/InsurancePurchase')
      //   )
      // },
      // {
      //   name: '保险方案', //保险方案
      //   path: 'insurancescheme',
      //   component: dynamicWrapper(app, ['insurance'], () =>
      //     import('../routes/Insurance/InsuranceManagement/InsuranceScheme')
      //   )
      // },
      {
        name: '保全缴费记录', //保全缴费记录
        path: 'insurancePreservation',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceManagement/InsurancePreservation')
        )
      },
      {
        name: '保险负责人',
        path: 'insurance-officer',
        component: dynamicWrapper(app, ['insurance'], () =>
          import('../routes/Insurance/InsuranceOfficer')
        )
      },
    ]
  };
};
