import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const FinancialWallet = app => {
  return {
    name: '金融钱包',
    icon: 'renshizhaopin',
    path: 'finance',
    children: [
      {
        name: '企业钱包', //购买在线保险 保险商城
        path: 'business-wallet',
        component: dynamicWrapper(app, ['financial'], () =>
          import('../routes/FinancialWallet/BusinessWallet')
        )
      },
      {
        name: '钱包协议', //购买在线保险 保险商城
        // title: '保险商城',
        path: 'agreement/wallet',
        component: dynamicWrapper(app, ['financial'], () =>
          import('../routes/FinancialWallet/Agreement')
        ),
        noShow:true
      },
    ]
  };
};