function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var Util = require('../util');

var Interaction = require('./base');

function getOriginalAttrs(attrs, styles) {
  var origin = {};

  for (var style in styles) {
    origin[style] = attrs[style];
  }

  return origin;
}

var Select = /*#__PURE__*/function (_Interaction) {
  _inheritsLoose(Select, _Interaction);

  function Select() {
    return _Interaction.apply(this, arguments) || this;
  }

  var _proto = Select.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    var defaultCfg = _Interaction.prototype.getDefaultCfg.call(this);

    return Util.mix({}, defaultCfg, {
      startEvent: 'mouseup',
      processEvent: null,
      selectStyle: {
        fillOpacity: 1
      },
      unSelectStyle: {
        fillOpacity: 0.1
      },
      cancelable: true
    });
  };

  _proto.start = function start(ev) {
    var self = this;
    var chart = self.view;
    var selectedShape;
    var unSelectedShapes = [];
    chart.eachShape(function (obj, shape) {
      if (shape.isPointInPath(ev.x, ev.y)) {
        selectedShape = shape;
      } else {
        unSelectedShapes.push(shape);
      }
    });

    if (!selectedShape) {
      self.reset();
      return;
    }

    if (selectedShape.get('_selected')) {
      // 已经被选中
      if (!self.cancelable) {
        // 不允许取消选中则不处理
        return;
      }

      self.reset(); // 允许取消选中
    } else {
      // 未被选中
      var selectStyle = self.selectStyle,
          unSelectStyle = self.unSelectStyle; // 获取选中效果对应的本来效果,保存下来

      var originAttrs = getOriginalAttrs(selectedShape.attr(), selectedShape);
      selectedShape.set('_originAttrs', originAttrs);
      selectedShape.attr(selectStyle);
      Util.each(unSelectedShapes, function (child) {
        var originAttrs = child.get('_originAttrs'); // 先恢复到默认状态下

        if (originAttrs) {
          child.attr(originAttrs);
        }

        child.set('_selected', false); // 保存未选中效果对应的原始效果

        if (unSelectStyle) {
          originAttrs = getOriginalAttrs(child.attr(), unSelectStyle);
          child.set('_originAttrs', originAttrs);
          child.attr(unSelectStyle);
        }
      });
      selectedShape.set('_selected', true);
      self.selectedShape = selectedShape;
      self.canvas.draw();
    }
  };

  _proto.end = function end(ev) {
    var selectedShape = this.selectedShape;

    if (selectedShape && !selectedShape.get('destroyed') && selectedShape.get('origin')) {
      ev.data = selectedShape.get('origin')._origin; // 绘制数据，包含原始数据啊

      ev.shapeInfo = selectedShape.get('origin');
      ev.shape = selectedShape;
      ev.selected = !!selectedShape.get('_selected'); // 返回选中的状态
    }
  };

  _proto.reset = function reset() {
    var self = this;

    if (!self.selectedShape) {
      return;
    }

    var chart = self.view;
    var geom = chart.get('geoms')[0];
    var container = geom.get('container').get('children')[0];
    var children = container.get('children');
    Util.each(children, function (child) {
      var originAttrs = child.get('_originAttrs');

      if (originAttrs) {
        child._attrs = originAttrs;
        child.set('_originAttrs', null);
      }

      child.set('_selected', false);
    });
    self.canvas.draw();
  };

  return Select;
}(Interaction);

module.exports = Select;