var Util = require('../../util');

var TimeUtil = require('@antv/scale/lib/time-util');

module.exports = function (data, scale) {
  var result;
  var field = scale.field,
      type = scale.type;
  var values = Util.Array.values(data, field);

  if (type === 'linear') {
    result = Util.Array.getRange(values);

    if (scale.min < result.min) {
      result.min = scale.min;
    }

    if (scale.max > result.max) {
      result.max = scale.max;
    }
  } else if (type === 'timeCat') {
    Util.each(values, function (v, i) {
      values[i] = TimeUtil.toTimeStamp(v);
    });
    values.sort(function (v1, v2) {
      return v1 - v2;
    });
    result = values;
  } else {
    result = values;
  }

  return result;
};