function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

/**
 * @fileOverview interval geometry
 * @author dxq613@gmail.com
 */
var GeomBase = require('./base');

var Util = require('../util');

var SizeMixin = require('./mixin/size');

require('./shape/interval');

var Interval = /*#__PURE__*/function (_GeomBase) {
  _inheritsLoose(Interval, _GeomBase);

  var _proto = Interval.prototype;

  /**
   * 获取默认的配置属性
   * @protected
   * @return {Object} 默认属性
   */
  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _GeomBase.prototype.getDefaultCfg.call(this);

    cfg.type = 'interval';
    cfg.shapeType = 'interval';
    cfg.generatePoints = true;
    return cfg;
  };

  function Interval(cfg) {
    var _this;

    _this = _GeomBase.call(this, cfg) || this;
    Util.assign(_assertThisInitialized(_this), SizeMixin);
    return _this;
  }

  _proto.createShapePointsCfg = function createShapePointsCfg(obj) {
    var cfg = _GeomBase.prototype.createShapePointsCfg.call(this, obj);

    cfg.size = this.getNormalizedSize(obj);
    return cfg;
  };

  _proto.clearInner = function clearInner() {
    _GeomBase.prototype.clearInner.call(this);

    this.set('defaultSize', null);
  };

  return Interval;
}(GeomBase);

var IntervalStack = /*#__PURE__*/function (_Interval) {
  _inheritsLoose(IntervalStack, _Interval);

  function IntervalStack() {
    return _Interval.apply(this, arguments) || this;
  }

  var _proto2 = IntervalStack.prototype;

  _proto2.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Interval.prototype.getDefaultCfg.call(this);

    cfg.hasDefaultAdjust = true;
    cfg.adjusts = [{
      type: 'stack'
    }];
    return cfg;
  };

  return IntervalStack;
}(Interval);

var IntervalDodge = /*#__PURE__*/function (_Interval2) {
  _inheritsLoose(IntervalDodge, _Interval2);

  function IntervalDodge() {
    return _Interval2.apply(this, arguments) || this;
  }

  var _proto3 = IntervalDodge.prototype;

  _proto3.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Interval2.prototype.getDefaultCfg.call(this);

    cfg.hasDefaultAdjust = true;
    cfg.adjusts = [{
      type: 'dodge'
    }];
    return cfg;
  };

  return IntervalDodge;
}(Interval);

var IntervalSymmetric = /*#__PURE__*/function (_Interval3) {
  _inheritsLoose(IntervalSymmetric, _Interval3);

  function IntervalSymmetric() {
    return _Interval3.apply(this, arguments) || this;
  }

  var _proto4 = IntervalSymmetric.prototype;

  _proto4.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Interval3.prototype.getDefaultCfg.call(this);

    cfg.hasDefaultAdjust = true;
    cfg.adjusts = [{
      type: 'symmetric'
    }];
    return cfg;
  };

  return IntervalSymmetric;
}(Interval);

Interval.Stack = IntervalStack;
Interval.Dodge = IntervalDodge;
Interval.Symmetric = IntervalSymmetric;
GeomBase.Interval = Interval;
GeomBase.IntervalStack = IntervalStack;
GeomBase.IntervalDodge = IntervalDodge;
GeomBase.IntervalSymmetric = IntervalSymmetric;
module.exports = Interval;