function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

/**
 * @fileOverview tree facets
 * @author dxq613@gmail.com
 */
var Base = require('./base');

var Util = require('../util');

var assign = Util.assign;

var Tree = /*#__PURE__*/function (_Base) {
  _inheritsLoose(Tree, _Base);

  function Tree() {
    return _Base.apply(this, arguments) || this;
  }

  var _proto = Tree.prototype;

  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Base.prototype.getDefaultCfg.call(this);

    cfg.type = 'tree';
    cfg.line = {
      lineWidth: 1,
      stroke: '#ddd'
    };
    cfg.lineSmooth = false;
    return cfg;
  };

  _proto.generateFacets = function generateFacets(data) {
    var self = this;
    var fields = self.fields;

    if (!fields.length) {
      throw 'Please specify for the fields for facet!';
    }

    var rst = [];
    var root = self.getRootFacet(data); // if (self.showRoot) {

    rst.push(root); // }

    root.children = self.getChildFacets(data, 1, rst);
    self.setRegion(rst);
    return rst;
  };

  _proto.getRootFacet = function getRootFacet(data) {
    var self = this;
    var facet = {
      type: self.type,
      rows: self.getRows(),
      rowIndex: 0,
      colIndex: 0,
      colValue: self.rootTitle,
      data: data
    };
    return facet;
  };

  _proto.getRows = function getRows() {
    return this.fields.length + 1;
  } // get child
  ;

  _proto.getChildFacets = function getChildFacets(data, level, arr) {
    var self = this;
    var fields = self.fields;
    var length = fields.length;

    if (length < level) {
      return;
    }

    var rst = [];
    var field = fields[level - 1];
    var values = self.getFieldValues(field, data);
    values.forEach(function (value, index) {
      var conditions = [{
        field: field,
        value: value,
        values: values
      }];
      var filter = self.getFilter(conditions);
      var subData = data.filter(filter);

      if (subData.length) {
        var facet = {
          type: self.type,
          colValue: value,
          colField: field,
          colIndex: index,
          rows: self.getRows(),
          rowIndex: level,
          data: subData,
          children: self.getChildFacets(subData, level + 1, arr)
        };
        rst.push(facet);
        arr.push(facet);
      }
    });
    return rst;
  } // 设置 region
  ;

  _proto.setRegion = function setRegion(facets) {
    var self = this;
    self.forceColIndex(facets);
    facets.forEach(function (facet) {
      facet.region = self.getRegion(facet.rows, facet.cols, facet.colIndex, facet.rowIndex);
    });
  } // set column index of facets
  ;

  _proto.forceColIndex = function forceColIndex(facets) {
    var self = this;
    var leafs = [];
    var index = 0;
    facets.forEach(function (facet) {
      if (self.isLeaf(facet)) {
        leafs.push(facet);
        facet.colIndex = index;
        index++;
      }
    });
    leafs.forEach(function (facet) {
      facet.cols = leafs.length;
    });
    var maxLevel = self.fields.length;

    for (var i = maxLevel - 1; i >= 0; i--) {
      var levelFacets = self.getFacetsByLevel(facets, i); // var yIndex = maxLevel - i;

      for (var j = 0; j < levelFacets.length; j++) {
        var facet = levelFacets[j];

        if (!self.isLeaf(facet)) {
          facet.originColIndex = facet.colIndex;
          facet.colIndex = self.getRegionIndex(facet.children);
          facet.cols = leafs.length;
        }
      }
    }
  } // get facet use level
  ;

  _proto.getFacetsByLevel = function getFacetsByLevel(facets, level) {
    var rst = [];
    facets.forEach(function (facet) {
      if (facet.rowIndex === level) {
        rst.push(facet);
      }
    });
    return rst;
  } // set facets region
  ;

  _proto.getRegion = function getRegion(rows, cols, xIndex, yIndex) {
    var xWidth = 1 / cols; // x轴方向的每个分面的偏移

    var yWidth = 1 / rows; // y轴方向的每个分面的偏移

    var start = {
      x: xWidth * xIndex,
      y: yWidth * yIndex
    };
    var end = {
      x: start.x + xWidth,
      y: start.y + yWidth * 2 / 3 // 预留1/3的空隙，方便添加连接线

    };
    return {
      start: start,
      end: end
    };
  } // if the facet has children , make it's column index in the middle of it's children
  ;

  _proto.getRegionIndex = function getRegionIndex(children) {
    var first = children[0];
    var last = children[children.length - 1];
    return (last.colIndex - first.colIndex) / 2 + first.colIndex;
  } // is  a leaf without children
  ;

  _proto.isLeaf = function isLeaf(facet) {
    return !facet.children || !facet.children.length;
  };

  _proto.setXAxis = function setXAxis(xField, axes, facet) {
    // 当是最后一行或者下面没有 view 时文本不显示
    if (facet.rowIndex !== facet.rows - 1) {
      axes[xField].label = null;
      axes[xField].title = null;
    }
  } // 设置 y 坐标轴的文本、title 是否显示
  ;

  _proto.setYAxis = function setYAxis(yField, axes, facet) {
    if (facet.originColIndex !== 0 && facet.colIndex !== 0) {
      axes[yField].title = null;
      axes[yField].label = null;
    }
  } // 绘制完成后
  ;

  _proto.onPaint = function onPaint() {
    _Base.prototype.onPaint.call(this);

    this.group.clear();

    if (this.facets && this.line) {
      this.drawLines(this.facets, this.group);
    }
  };

  _proto.drawLines = function drawLines(facets, group) {
    var self = this;
    var lineGroup = group.addGroup();
    facets.forEach(function (facet) {
      if (!self.isLeaf(facet)) {
        var children = facet.children;

        self._addFacetLines(facet, children, lineGroup);
      }
    });
  } // add lines with it's children
  ;

  _proto._addFacetLines = function _addFacetLines(facet, children, group) {
    var self = this;
    var view = facet.view;
    var region = view.getViewRegion();
    var start = {
      x: region.start.x + (region.end.x - region.start.x) / 2,
      y: region.start.y
    };
    children.forEach(function (subFacet) {
      var subRegion = subFacet.view.getViewRegion();
      var end = {
        x: subRegion.start.x + (subRegion.end.x - subRegion.start.x) / 2,
        y: subRegion.end.y
      };
      var middle1 = {
        x: start.x,
        y: start.y + (end.y - start.y) / 2
      };
      var middle2 = {
        x: end.x,
        y: middle1.y
      };

      self._drawLine([start, middle1, middle2, end], group);
    });
  };

  _proto._getPath = function _getPath(points) {
    var self = this;
    var path = [];
    var smooth = self.lineSmooth;

    if (smooth) {
      path.push(['M', points[0].x, points[0].y]);
      path.push(['C', points[1].x, points[1].y, points[2].x, points[2].y, points[3].x, points[3].y]);
    } else {
      points.forEach(function (point, index) {
        if (index === 0) {
          path.push(['M', point.x, point.y]);
        } else {
          path.push(['L', point.x, point.y]);
        }
      });
    }

    return path;
  } // draw line width points
  ;

  _proto._drawLine = function _drawLine(points, group) {
    var self = this;

    var path = self._getPath(points);

    var line = self.line;
    group.addShape('path', {
      attrs: assign({
        path: path
      }, line)
    });
  };

  return Tree;
}(Base);

module.exports = Tree;