var Util = require('../../util');

var Guide = require('../../component/guide');

var GuideController = /*#__PURE__*/function () {
  function GuideController(cfg) {
    this.guides = [];
    this.options = [];
    this.xScales = null;
    this.yScales = null;
    this.view = null;
    this.viewTheme = null;
    this.frontGroup = null;
    this.backGroup = null;
    Util.mix(this, cfg);
  }

  var _proto = GuideController.prototype;

  _proto._creatGuides = function _creatGuides() {
    var self = this;
    var options = this.options;
    var xScales = this.xScales;
    var yScales = this.yScales;
    var view = this.view;
    var viewTheme = this.viewTheme; // @2019-01-18 by blue.lb 这里如果给 backContainer 添加 group 的话，会直接导致 BBoxOfBackPlot 函数中计算 element.getBBox() 出错

    if (this.backContainer && view) {
      this.backGroup = this.backContainer.addGroup({
        viewId: view.get('_id')
      });
    }

    if (this.frontContainer && view) {
      this.frontGroup = this.frontContainer.addGroup({
        viewId: view.get('_id')
      });
    }

    options.forEach(function (option) {
      var type = option.type;
      var config = Util.deepMix({
        xScales: xScales,
        yScales: yScales,
        viewTheme: viewTheme
      }, viewTheme ? viewTheme.guide[type] : {}, option);
      type = Util.upperFirst(type);
      var guide = new Guide[type](config);
      self.guides.push(guide);
    });
    return self.guides;
  };

  _proto.line = function line(cfg) {
    if (cfg === void 0) {
      cfg = {};
    }

    this.options.push(Util.mix({
      type: 'line'
    }, cfg));
    return this;
  };

  _proto.arc = function arc(cfg) {
    if (cfg === void 0) {
      cfg = {};
    }

    this.options.push(Util.mix({
      type: 'arc'
    }, cfg));
    return this;
  };

  _proto.text = function text(cfg) {
    if (cfg === void 0) {
      cfg = {};
    }

    this.options.push(Util.mix({
      type: 'text'
    }, cfg));
    return this;
  };

  _proto.image = function image(cfg) {
    if (cfg === void 0) {
      cfg = {};
    }

    this.options.push(Util.mix({
      type: 'image'
    }, cfg));
    return this;
  };

  _proto.region = function region(cfg) {
    if (cfg === void 0) {
      cfg = {};
    }

    this.options.push(Util.mix({
      type: 'region'
    }, cfg));
    return this;
  };

  _proto.regionFilter = function regionFilter(cfg) {
    if (cfg === void 0) {
      cfg = {};
    }

    this.options.push(Util.mix({
      type: 'regionFilter'
    }, cfg));
    return this;
  };

  _proto.dataMarker = function dataMarker(cfg) {
    if (cfg === void 0) {
      cfg = {};
    }

    this.options.push(Util.mix({
      type: 'dataMarker'
    }, cfg));
    return this;
  };

  _proto.dataRegion = function dataRegion(cfg) {
    if (cfg === void 0) {
      cfg = {};
    }

    this.options.push(Util.mix({
      type: 'dataRegion'
    }, cfg));
    return this;
  };

  _proto.html = function html(cfg) {
    if (cfg === void 0) {
      cfg = {};
    }

    this.options.push(Util.mix({
      type: 'html'
    }, cfg));
    return this;
  };

  _proto.render = function render(coord) {
    var self = this;
    var view = self.view;
    var viewData = view && view.get('data');

    var guides = self._creatGuides();

    Util.each(guides, function (guide) {
      var container;

      if (guide.get('top')) {
        // 默认 guide 绘制到 backPlot，用户也可以声明 top: true，显示在最上层
        // @2019-01-18 by blue.lb 直接用传入的就行
        container = self.frontGroup || self.frontContainer; // container = self.frontContainer;
      } else {
        // @2019-01-18 by blue.lb 直接用传入的就行
        container = self.backGroup || self.backContainer; // container = self.backContainer;
      }

      guide.render(coord, container, viewData, view);
    });
  };

  _proto.clear = function clear() {
    this.options = [];
    this.reset();
  };

  _proto.changeVisible = function changeVisible(visible) {
    var guides = this.guides;
    Util.each(guides, function (guide) {
      guide.changeVisible(visible);
    });
  };

  _proto.reset = function reset() {
    var guides = this.guides;
    Util.each(guides, function (guide) {
      guide.clear();
    });
    this.guides = []; // @2019-01-18 by blue.lb 删除这部分

    this.backGroup && this.backGroup.remove();
    this.frontGroup && this.frontGroup.remove();
  };

  return GuideController;
}();

module.exports = GuideController;