var Greedy = /*#__PURE__*/function () {
  function Greedy() {
    this.bitmap = [];
  }

  var _proto = Greedy.prototype;

  _proto.hasGap = function hasGap(bbox) {
    var hasGap = true;
    var bitmap = this.bitmap;
    var minX = Math.floor(bbox.minX);
    var maxX = Math.ceil(bbox.maxX);
    var minY = Math.floor(bbox.minY);
    var maxY = Math.ceil(bbox.maxY) - 1;

    for (var i = minX; i < maxX; i++) {
      if (!bitmap[i]) {
        bitmap[i] = [];
        continue;
      }

      if (i === minX || i === maxX - 1) {
        for (var j = minY; j <= maxY; j++) {
          if (bitmap[i][j]) {
            hasGap = false;
            break;
          }
        }
      } else {
        if (bitmap[i][minY] || bitmap[i][maxY]) {
          hasGap = false;
          break;
        }
      }
    }

    return hasGap;
  };

  _proto.fillGap = function fillGap(bbox) {
    var bitmap = this.bitmap;
    var minX = Math.floor(bbox.minX);
    var maxX = Math.ceil(bbox.maxX) - 1;
    var minY = Math.floor(bbox.minY);
    var maxY = Math.ceil(bbox.maxY) - 1;

    for (var i = minX; i <= maxX; i++) {
      for (var j = minY; j < maxY; j += 8) {
        if (!bitmap[i]) {
          bitmap[i] = [];
        }

        bitmap[i][j] = true;
      }

      bitmap[i][maxY] = true;
    }

    for (var _i = minY; _i <= maxY; _i++) {
      bitmap[minX][_i] = true;
      bitmap[maxX][_i] = true;
    }
  };

  return Greedy;
}();

module.exports = Greedy;