DROP TABLE if EXISTS com_task_schedul;
CREATE TABLE `com_task_schedul` (
  `taskSchedulId` bigint(20) NOT NULL COMMENT '任务排班制ID',
  `active` bit(1) DEFAULT NULL COMMENT '是否有效',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `create_by` varchar(50) DEFAULT NULL COMMENT '创建人ID',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `update_by` varchar(50) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `schedulDate` date DEFAULT NULL COMMENT '排班日期',
  `isRest` varchar(1) DEFAULT NULL COMMENT '是否休息',
  `comTaskId` bigint(20) NOT NULL COMMENT '任务ID',
  `perId` bigint(20) NOT NULL COMMENT '排班人员ID',
  `shiftId` bigint(20) DEFAULT NULL COMMENT '班次ID',
  PRIMARY KEY (`taskSchedulId`),
  KEY `index_com_task_schedul_comTaskId` (`comTaskId`),
  KEY `index_com_task_schedul_comId` (`comId`),
  KEY `index_com_task_schedul` (`perId`,`schedulDate`,`shiftId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='任务排班制明细'


DROP TABLE if EXISTS per_task_card_record;
CREATE TABLE `per_task_card_record` (
  `taskCardRecordId` bigint(20) NOT NULL COMMENT '任务打卡记录ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `setClockInTime` datetime DEFAULT NULL COMMENT '设置的打卡时间',
  `clockInDate` date DEFAULT NULL COMMENT '打卡日期',
  `clockInTime` datetime DEFAULT NULL COMMENT '打卡时间',
  `clockInType` varchar(6) DEFAULT NULL COMMENT '打卡类别(上班打卡、下班打卡)',
  `clockInRound` int(3) DEFAULT NULL COMMENT '第几轮打卡',
  `placeLongitude` varchar(50) DEFAULT NULL COMMENT '打卡地点经度',
  `palceLatitude` varchar(50) DEFAULT NULL COMMENT '打卡地点纬度',
  `clockInWay` varchar(6) DEFAULT NULL COMMENT '打卡方式(wifi打卡、地点打卡)',
  `attendAddress` varchar(100) DEFAULT NULL COMMENT '打卡地点',
  `attendStatus` varchar(6) DEFAULT NULL COMMENT '考勤状态',
  `comId` bigint(20) NOT NULL COMMENT '所在企业ID',
  `shiftId` bigint(20) DEFAULT NULL COMMENT '班次ID',
  `shiftRuleId` bigint(20) DEFAULT NULL COMMENT '班次规则ID',
  `attendWifiId` bigint(20) DEFAULT NULL COMMENT '考勤WIFIID',
  `perId` bigint(20) NOT NULL COMMENT '打卡人员ID',
  `approveApplyId` bigint(20) DEFAULT NULL COMMENT '审批申请ID',
  `remark` varchar(50) DEFAULT NULL COMMENT '备注',
  `comTaskId` bigint(20) NOT NULL COMMENT '任务ID',
  PRIMARY KEY (`taskCardRecordId`),
  KEY `index_per_task_card_record_comId` (`comId`),
  KEY `index_per_task_card` (`comTaskId`,`perId`,`clockInDate`,`clockInType`,`shiftId`,`shiftRuleId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='任务打卡记录'


DROP TABLE if EXISTS com_shift;
CREATE TABLE `com_shift` (
  `shiftId` bigint(20) NOT NULL COMMENT '班次ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `shiftName` varchar(20) DEFAULT NULL COMMENT '班次名称',
  `shiftRuleDetail` varchar(500) DEFAULT NULL COMMENT '班次规则详情',
  `shiftType` varchar(6) DEFAULT NULL COMMENT '班次类型',
  `effectRule` varchar(6) DEFAULT NULL COMMENT '生效规则',
  `effectStartTime` datetime DEFAULT NULL COMMENT '生效开始时间',
  `effectEndTime` datetime DEFAULT NULL COMMENT '生效截止时间',
  `commutTimes` int(3) DEFAULT NULL COMMENT '每天上下班次数',
  `permitLateUp` int(3) DEFAULT NULL COMMENT '允许迟到时间上限',
  `seriousLateLow` int(3) DEFAULT NULL COMMENT '严重迟到时间下限',
  `absentLow` int(3) DEFAULT NULL COMMENT '旷工时间下限',
  `clockWorkLimit` int(3) DEFAULT NULL COMMENT '打卡时限上限',
  `permitLateSwitch` varchar(1) DEFAULT NULL COMMENT '允许迟到校验开关',
  `seriousLateSwitch` varchar(1) DEFAULT NULL COMMENT '严重迟到校验开关',
  `absentSwitch` varchar(1) DEFAULT NULL COMMENT '旷工校验开关',
  `clockLimitSwitch` varchar(1) DEFAULT NULL COMMENT '打卡时限开关',
  `comId` bigint(20) DEFAULT NULL COMMENT '企业ID',
  PRIMARY KEY (`shiftId`),
  KEY `index_com_shift_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业班次'

DROP TABLE if EXISTS com_shift_rule;
CREATE TABLE `com_shift_rule` (
  `shiftRuleId` bigint(20) NOT NULL COMMENT '班次规则ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) DEFAULT NULL COMMENT '企业ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `commutRound` int(3) DEFAULT NULL COMMENT '上下班第几轮',
  `startWorkTime` time DEFAULT NULL COMMENT '上班时间',
  `endWorkTime` time DEFAULT NULL COMMENT '下班时间',
  `isStartNextDay` varchar(1) DEFAULT '0' COMMENT '上班时间是否是次日',
  `isEndNextDay` varchar(1) DEFAULT '0' COMMENT '下班时间是否是次日',
  `shiftId` bigint(20) NOT NULL COMMENT '班次ID',
  PRIMARY KEY (`shiftRuleId`),
  KEY `index_com_shift_rule_shiftId` (`shiftId`),
  KEY `index_com_shift_rule_comId` (`comId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业班次规则'


DROP TABLE if EXISTS person_clock_in;
CREATE TABLE `person_clock_in`(
  `id` int(11) NOT NULL AUTO_INCREMENT  COMMENT '主键',
  `personId` bigint(20) NOT NULL COMMENT '人员id',
  `workDate` date DEFAULT NULL COMMENT '上班日期',
  `startWorkTime` datetime DEFAULT NULL COMMENT '上班时间',
  `endWorkTime` datetime DEFAULT NULL COMMENT '下班时间',
  `shiftRuleId` bigint(20) DEFAULT NULL COMMENT '班次规则ID',
  `clockInRound` int(3) DEFAULT NULL COMMENT '第几轮打卡',
  `updateTime` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
)ENGINE=InnoDB  AUTO_INCREMENT=1 CHARSET=utf8 COMMENT='人员打卡详情表'