/*
Navicat MySQL Data Transfer

Source Server         : 百川信测试环境3345
Source Server Version : 50720
Source Host           : 183.250.166.207:3345
Source Database       : gxbbd

Target Server Type    : MYSQL
Target Server Version : 50720
File Encoding         : 65001

Date: 2019-05-02 19:35:45
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for module
-- ----------------------------
DROP TABLE IF EXISTS `module`;
CREATE TABLE `module` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `native_code` int(11) NOT NULL COMMENT '区域编码',
  `code` varchar(50) NOT NULL COMMENT '模块代码',
  `name` varchar(50) NOT NULL COMMENT '名称',
  `url` varchar(100) DEFAULT NULL COMMENT '路径url',
  `seq` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `index` bit(1) NOT NULL DEFAULT b'0',
  `shortcut` bit(1) NOT NULL DEFAULT b'0',
  `class` varchar(100) DEFAULT NULL,
  `action` varchar(100) DEFAULT NULL COMMENT 'action',
  `active` bit(1) NOT NULL DEFAULT b'1' COMMENT '是否有效',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `update_time` datetime NOT NULL COMMENT '更新时间',
  `update_by` varchar(200) NOT NULL COMMENT '更新人',
  `moduletype` varchar(1) DEFAULT NULL COMMENT '公安1公司2',
  `p_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_module_native` (`native_code`),
  CONSTRAINT `fk_module_native` FOREIGN KEY (`native_code`) REFERENCES `native` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=167 DEFAULT CHARSET=utf8 COMMENT='系统模块（配置表）';

-- ----------------------------
-- Records of module
-- ----------------------------
INSERT INTO `module` VALUES ('1', '3502', 'search', '一键搜', null, '99', '', '\0', '', '', '', '2017-02-28 22:53:42', '2017-02-28 22:53:45', 'system', '1', '123');
INSERT INTO `module` VALUES ('2', '3502', 'person', '人员中心', null, '99', '', '\0', '', '', '', '2017-03-01 10:28:44', '2017-03-01 10:28:46', 'system', '1', '123');
INSERT INTO `module` VALUES ('3', '3502', 'task', '任务中心', null, '99', '', '\0', '', '', '', '2017-03-01 10:29:07', '2017-03-01 10:29:10', 'system', '1', '123');
INSERT INTO `module` VALUES ('4', '3502', 'ungentask', '紧急任务', null, '99', '', '\0', '', '', '', '2017-03-01 21:09:22', '2017-03-01 21:09:25', 'system', '1', '123');
INSERT INTO `module` VALUES ('6', '3502', 'complaintInfo', '市民意见建议', null, '99', '\0', '\0', '', '', '', '2017-03-01 10:29:54', '2017-03-01 10:29:57', 'system', '1', '147');
INSERT INTO `module` VALUES ('64', '3502', 'xhInfomanager', '保安协会管理', null, '99', '\0', '\0', null, null, '', '2017-06-30 17:08:00', '2017-06-30 17:08:04', 'system', '1', '142');
INSERT INTO `module` VALUES ('65', '3502', 'jdManager', '监督检查情况管理', null, '99', '\0', '\0', null, null, '', '2017-06-30 17:41:19', '2017-06-30 17:41:21', 'system', '1', '147');
INSERT INTO `module` VALUES ('67', '3502', 'traincompanyapply', '保安培训单位许可审批', null, '99', '\0', '\0', null, null, '', '2017-06-30 17:55:58', '2017-05-01 17:55:55', 'system', '1', '125');
INSERT INTO `module` VALUES ('68', '3502', 'subsidiary', '保安服务公司设立分公司备案', null, '99', '\0', '\0', null, null, '', '2017-05-01 17:59:19', '2017-06-30 17:59:22', 'system', '1', '128');
INSERT INTO `module` VALUES ('69', '3502', 'crosscompany', '保安跨区域服务备案', null, '99', '\0', '\0', null, null, '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1', '128');
INSERT INTO `module` VALUES ('70', '3502', 'confesscompany', '自行招用保安员单位备案', '', '99', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1', '128');
INSERT INTO `module` VALUES ('71', '3502', 'legalchange', '保安服务（培训）许可证项目变更', '', '99', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1', '139');
INSERT INTO `module` VALUES ('74', '3502', 'yearreport', '保安服务公司年度报告备案', '', '99', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1', '128');
INSERT INTO `module` VALUES ('75', '3502', 'orgManager', '机构管理', '', '99', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1', '149');
INSERT INTO `module` VALUES ('76', '3502', 'userManager', '用户管理', '', '99', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1', '149');
INSERT INTO `module` VALUES ('77', '3502', 'roleManager', '角色管理', '', '99', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1', '149');
INSERT INTO `module` VALUES ('78', '3502', 'companyInfoManager', '保安服务公司信息', '', '99', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1', '142');
INSERT INTO `module` VALUES ('110', '3502', 'personInfoManager', '保安员管理', '', '99', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1', '142');
INSERT INTO `module` VALUES ('111', '3502', 'problemPerson', '问题人员', '', '99', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1', '147');
INSERT INTO `module` VALUES ('112', '3502', 'goodThing', '好人好事管理', '', '99', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1', '142');
INSERT INTO `module` VALUES ('113', '3502', 'dataCount', '统计管理', '', '6', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1', '122');
INSERT INTO `module` VALUES ('114', '3502', 'sponsorlicense', '保安服务公司许可审批', '', '99', '\0', '\0', '', '', '', '2017-06-30 17:41:19', '2017-06-30 17:41:21', 'system', '1', '125');
INSERT INTO `module` VALUES ('115', '3502', 'armtrainorg', '枪支培训机构备案', '', '99', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1', '128');
INSERT INTO `module` VALUES ('119', '3502', 'newNotify', '消息通知', '', '99', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1', '148');
INSERT INTO `module` VALUES ('122', '3502', 'check_all', '全选', null, '0', '\0', '\0', null, null, '', '2018-07-06 16:12:21', '2018-07-06 16:12:25', 'system', '1', null);
INSERT INTO `module` VALUES ('123', '3502', 'homePage', '首页', null, '1', '\0', '\0', null, null, '', '2018-07-06 16:50:28', '2018-07-06 16:50:31', 'system', '1', '122');
INSERT INTO `module` VALUES ('125', '3502', 'permit', '许可管理', null, '3', '\0', '\0', null, null, '', '2018-07-06 16:52:35', '2018-07-06 16:52:38', 'system', '1', '122');
INSERT INTO `module` VALUES ('128', '3502', 'keepOnRecord', '备案管理', null, '4', '\0', '\0', null, null, '', '2018-07-06 16:54:52', '2018-07-06 16:54:56', 'system', '1', '122');
INSERT INTO `module` VALUES ('129', '3502', 'approvalConfigManager', '审批业务管理', null, '99', '\0', '\0', null, null, '', '2018-12-01 10:51:45', '2018-12-01 10:51:45', 'system', '1', '149');
INSERT INTO `module` VALUES ('130', '3502', 'sponsorlicensePrint', '保安服务公司许可证打印', '', '99', '\0', '\0', '', '', '', '2017-06-30 17:41:19', '2017-06-30 17:41:21', 'system', '1', '125');
INSERT INTO `module` VALUES ('131', '3502', 'traincompanyapplyPrint', '保安培训单位许可证打印', '', '99', '\0', '\0', '', '', '', '2017-06-30 17:41:19', '2017-06-30 17:41:21', 'system', '1', '125');
INSERT INTO `module` VALUES ('132', '3502', 'examinationarrange', '考试安排', '', '99', '\0', '\0', '', '', '', '2017-06-30 17:41:19', '2017-06-30 17:41:21', 'system', '1', '125');
INSERT INTO `module` VALUES ('133', '3502', 'personmakeup', '补考人员', '', '99', '\0', '\0', '', '', '', '2017-06-30 17:41:19', '2017-06-30 17:41:21', 'system', '1', '125');
INSERT INTO `module` VALUES ('134', '3502', 'personcertificate', '保安员资格证考试报名', '', '99', '\0', '\0', '', '', '', '2017-06-30 17:41:19', '2017-06-30 17:41:21', 'system', '1', '125');
INSERT INTO `module` VALUES ('135', '3502', 'personcertificatePrint', '保安员资格证打印', '', '99', '\0', '\0', '', '', '', '2017-06-30 17:41:19', '2017-06-30 17:41:21', 'system', '1', '125');
INSERT INTO `module` VALUES ('136', '3502', 'company', '公司统计', '', '99', '', '\0', '', '', '', '2017-03-01 21:09:22', '2017-03-01 21:09:25', 'system', '1', '123');
INSERT INTO `module` VALUES ('137', '3502', 'help', '常见问题', '', '99', '', '\0', '', '', '', '2017-03-01 21:09:22', '2017-03-01 21:09:25', 'system', '1', '123');
INSERT INTO `module` VALUES ('138', '3502', 'helpDoc', '帮助文档', '', '99', '', '\0', '', '', '', '2017-03-01 21:09:22', '2017-03-01 21:09:25', 'system', '1', '123');
INSERT INTO `module` VALUES ('139', '3502', 'change', '变更管理', '', '5', '\0', '\0', '', '', '', '2018-07-06 16:52:35', '2018-07-06 16:52:38', 'system', '1', '122');
INSERT INTO `module` VALUES ('140', '3502', 'legalchangePrint', '保安服务（培训许可变更打印）', '', '99', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1', '139');
INSERT INTO `module` VALUES ('141', '3502', 'confesscompanyundo', '自行招用保安员单位撤销备案', '', '99', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1', '139');
INSERT INTO `module` VALUES ('142', '3502', 'industry', '行业信息', '', '7', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1', '122');
INSERT INTO `module` VALUES ('143', '3502', 'trainInfoManager', '保安培训公司信息', '', '99', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1', '142');
INSERT INTO `module` VALUES ('144', '3502', 'confessInfoManager', '自行招用保安公司信息', '', '99', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1', '142');
INSERT INTO `module` VALUES ('145', '3502', 'subsidiaryInfoManager', '保安服务分公司信息', '', '99', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1', '142');
INSERT INTO `module` VALUES ('146', '3502', 'guardInfoManager', '保安师管理', '', '99', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1', '142');
INSERT INTO `module` VALUES ('147', '3502', 'proposal', '建议管理', '', '8', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1', '122');
INSERT INTO `module` VALUES ('148', '3502', 'news', '消息管理', '', '9', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1', '122');
INSERT INTO `module` VALUES ('149', '3502', 'systemConfig', '系统管理', '', '10', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '1', '122');
INSERT INTO `module` VALUES ('150', '3502', 'traincompanyapply', '保安培训单位许可审批', '', '3', '\0', '\0', '', '', '', '2017-06-30 17:55:58', '2017-05-01 17:55:55', 'system', '2', null);
INSERT INTO `module` VALUES ('151', '3502', 'traincompanyapply', '保安培训单位许可审批', '', '3', '\0', '\0', '', '', '', '2017-06-30 17:55:58', '2017-05-01 17:55:55', 'system', '4', null);
INSERT INTO `module` VALUES ('152', '3502', 'sponsorlicense', '保安服务公司许可审批', '', '1', '\0', '\0', '', '', '', '2017-06-30 17:41:19', '2017-06-30 17:41:21', 'system', '4', null);
INSERT INTO `module` VALUES ('153', '3502', 'personcertificate', '保安员资格证考试报名', '', '5', '\0', '\0', '', '', '', '2017-06-30 17:41:19', '2017-06-30 17:41:21', 'system', '2', null);
INSERT INTO `module` VALUES ('154', '3502', 'personcertificate', '保安员资格证考试报名', '', '5', '\0', '\0', '', '', '', '2017-06-30 17:41:19', '2017-06-30 17:41:21', 'system', '4', null);
INSERT INTO `module` VALUES ('155', '3502', 'legalchange', '保安服务（培训）许可证项目变更', '', '1', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '2', null);
INSERT INTO `module` VALUES ('156', '3502', 'confesscompanyundo', '自行招用保安员单位撤销备案', '', '3', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '2', null);
INSERT INTO `module` VALUES ('157', '3502', 'confesscompanyundo', '自行招用保安员单位撤销备案', '', '3', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '4', null);
INSERT INTO `module` VALUES ('158', '3502', 'subsidiary', '保安服务公司设立分公司备案', '', '1', '\0', '\0', '', '', '', '2017-05-01 17:59:19', '2017-06-30 17:59:22', 'system', '2', null);
INSERT INTO `module` VALUES ('159', '3502', 'subsidiary', '保安服务公司设立分公司备案', '', '1', '\0', '\0', '', '', '', '2017-05-01 17:59:19', '2017-06-30 17:59:22', 'system', '4', null);
INSERT INTO `module` VALUES ('160', '3502', 'crosscompany', '保安跨区域服务备案', '', '3', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '2', null);
INSERT INTO `module` VALUES ('161', '3502', 'crosscompany', '保安跨区域服务备案', '', '3', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '4', null);
INSERT INTO `module` VALUES ('162', '3502', 'yearreport', '保安服务公司年度报告备案', '', '4', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '2', null);
INSERT INTO `module` VALUES ('163', '3502', 'confesscompany', '自行招用保安员单位备案', '', '2', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '4', null);
INSERT INTO `module` VALUES ('165', '3502', 'todoList', '审批事项', '', '2', '\0', '\0', '', '', '', '2017-03-01 10:29:32', '2017-03-01 10:29:34', 'system', '1', '166');
INSERT INTO `module` VALUES ('166', '3502', 'needToDo', '待办事项', '', '1', '\0', '\0', '', '', '', '2018-07-06 16:50:28', '2018-07-06 16:50:31', 'system', '1', '122');
INSERT INTO `module` (`id`, `native_code`, `code`, `name`, `url`, `seq`, `index`, `shortcut`, `class`, `action`, `active`, `create_time`, `update_time`, `update_by`, `moduletype`, `p_id`) VALUES ('168', '3502', 'armtrainorg', '枪支培训机构备案', '', '4', '\0', '\0', '', '', '', '2017-06-30 18:00:19', '2017-06-30 18:00:21', 'system', '2', NULL);

-- ----------------------------
-- Table structure for operation
-- ----------------------------
DROP TABLE IF EXISTS `operation`;
CREATE TABLE `operation` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `native_code` int(11) NOT NULL COMMENT '区域编号',
  `code` varchar(50) NOT NULL,
  `name` varchar(20) NOT NULL COMMENT '区域名称',
  `module_id` int(11) NOT NULL COMMENT '模块id',
  `active` bit(1) NOT NULL COMMENT '是否可用',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `update_time` datetime NOT NULL COMMENT '更新时间',
  `update_by` varchar(200) NOT NULL COMMENT '修改者',
  PRIMARY KEY (`id`),
  KEY `fk_operation_module` (`module_id`),
  KEY `fk_operation_native` (`native_code`)
) ENGINE=InnoDB AUTO_INCREMENT=351 DEFAULT CHARSET=utf8 COMMENT='业务模块方法(配置表)';

-- ----------------------------
-- Records of operation
-- ----------------------------
INSERT INTO `operation` VALUES ('1', '3502', 'query', '查询', '1', '', '2017-02-28 22:54:18', '2017-02-28 22:54:20', 'system');
INSERT INTO `operation` VALUES ('2', '3502', 'query', '查询', '2', '', '2017-03-01 13:01:19', '2017-03-01 13:01:22', 'system');
INSERT INTO `operation` VALUES ('3', '3502', 'query', '查询', '3', '', '2017-03-01 13:01:45', '2017-03-01 13:01:48', 'system');
INSERT INTO `operation` VALUES ('4', '3502', 'query', '查询', '4', '', '2017-03-01 13:02:14', '2017-03-01 13:02:16', 'system');
INSERT INTO `operation` VALUES ('5', '3502', 'query', '查询', '165', '', '2017-03-01 13:02:49', '2017-03-01 13:02:53', 'system');
INSERT INTO `operation` VALUES ('8', '3502', 'query', '查询', '6', '', '2017-03-01 21:21:21', '2017-03-01 21:21:23', 'system');
INSERT INTO `operation` VALUES ('43', '3502', 'endTask', '结束', '4', '', '2017-06-29 23:17:47', '2017-06-29 23:17:50', 'system');
INSERT INTO `operation` VALUES ('53', '3502', 'createTask', '创建', '4', '', '2017-06-29 23:23:20', '2017-06-29 23:23:22', 'system');
INSERT INTO `operation` VALUES ('54', '3502', 'approval', '审批', '165', '', '2017-06-29 23:30:20', '2017-06-29 23:30:23', 'system');
INSERT INTO `operation` VALUES ('56', '3502', 'add', '新增', '64', '', '2017-06-30 17:09:27', '2017-06-30 17:09:29', 'system');
INSERT INTO `operation` VALUES ('60', '3502', 'del', '删除', '64', '', '2017-06-30 17:14:15', '2017-06-30 17:14:18', 'system');
INSERT INTO `operation` VALUES ('61', '3502', 'edit', '修改', '64', '', '2017-06-30 17:14:38', '2017-06-30 17:14:40', 'system');
INSERT INTO `operation` VALUES ('63', '3502', 'add', '新增', '65', '', '2017-06-30 17:42:37', '2017-06-30 17:42:39', 'system');
INSERT INTO `operation` VALUES ('64', '3502', 'edit', '修改', '65', '', '2017-06-30 17:42:37', '2017-06-30 17:42:39', 'system');
INSERT INTO `operation` VALUES ('65', '3502', 'del', '删除', '65', '', '2017-06-30 17:50:11', '2017-06-30 17:50:12', 'system');
INSERT INTO `operation` VALUES ('66', '3502', 'query', '查询', '114', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('67', '3502', 'query', '查询', '67', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('68', '3502', 'query', '查询', '68', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('69', '3502', 'query', '查询', '69', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('70', '3502', 'query', '查询', '70', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('71', '3502', 'query', '查询', '71', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('72', '3502', 'view', '查看', '134', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('74', '3502', 'query', '查询', '74', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('75', '3502', 'view', '查看', '75', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('76', '3502', 'add', '新增', '75', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('77', '3502', 'edit', '修改', '75', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('78', '3502', 'del', '删除', '75', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('79', '3502', 'copy', '复制', '75', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('80', '3502', 'view', '查看', '76', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('81', '3502', 'add', '新增', '76', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('82', '3502', 'edit', '修改', '76', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('83', '3502', 'reset', '重置密码', '76', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('84', '3502', 'del', '删除', '76', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('85', '3502', 'view', '查看', '77', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('86', '3502', 'add', '新增', '77', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('87', '3502', 'edit', '修改', '77', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('88', '3502', 'copy', '复制', '77', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('89', '3502', 'del', '删除', '77', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('90', '3502', 'view', '查看', '78', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('91', '3502', 'edit', '修改', '78', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('92', '3502', 'del', '删除', '78', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('95', '3502', 'export', '导出', '78', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('96', '3502', 'add', '新增', '78', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('211', '3502', 'batchApproval', '批量审批通过', '165', '', '2017-06-29 23:30:20', '2017-06-29 23:30:23', 'system');
INSERT INTO `operation` VALUES ('212', '3502', 'view', '查看', '165', '', '2017-06-29 23:30:20', '2017-06-29 23:30:23', 'system');
INSERT INTO `operation` VALUES ('214', '3502', 'query', '查询', '110', '', '2017-08-13 14:27:27', '2017-08-13 14:27:29', 'system');
INSERT INTO `operation` VALUES ('215', '3502', 'query', '查询', '111', '', '2017-08-13 14:27:27', '2017-08-13 14:27:29', 'system');
INSERT INTO `operation` VALUES ('216', '3502', 'query', '查询', '112', '', '2017-08-13 14:27:27', '2017-08-13 14:27:29', 'system');
INSERT INTO `operation` VALUES ('217', '3502', 'approval', '审批情况分析', '113', '', '2017-08-13 14:27:27', '2017-08-13 14:27:29', 'system');
INSERT INTO `operation` VALUES ('218', '3502', 'personCertificate', '保安员资格证考试报名分析', '113', '', '2017-08-13 14:27:27', '2017-08-13 14:27:29', 'system');
INSERT INTO `operation` VALUES ('219', '3502', 'securityCompany', '保安服务公司分析', '113', '', '2017-08-13 14:27:27', '2017-08-13 14:27:29', 'system');
INSERT INTO `operation` VALUES ('220', '3502', 'securityPerson', '保安员分析', '113', '', '2017-08-13 14:27:27', '2017-08-13 14:27:29', 'system');
INSERT INTO `operation` VALUES ('221', '3502', 'personCertificateStatistics', '保安员资格证考试报名数据统计', '113', '', '2017-08-13 14:27:27', '2017-08-13 14:27:29', 'system');
INSERT INTO `operation` VALUES ('223', '3502', 'query', '查询', '115', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('227', '3502', 'fingerprint', '获取指纹卡号', '134', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('229', '3502', 'export', '导出', '134', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('232', '3502', 'add', '发布消息', '119', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('233', '3502', 'del', '删除', '119', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('236', '3502', 'search', '查询', '119', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('237', '3502', 'view', '查看', '119', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('238', '3502', 'cancel', '撤消', '119', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('239', '3502', 'edit', '修改', '119', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('241', '3502', 'edit', '新增审批层级', '129', '', '2018-12-01 10:51:45', '2018-12-01 10:51:45', 'system');
INSERT INTO `operation` VALUES ('242', '3502', 'repulse', '打回', '134', '', '2018-12-26 13:58:41', '2018-12-26 13:58:41', 'system');
INSERT INTO `operation` VALUES ('243', '3502', 'scoreConfirm', '确认成绩', '134', '', '2018-12-26 13:58:41', '2018-12-26 13:58:41', 'system');
INSERT INTO `operation` VALUES ('246', '3502', 'view', '查看', '114', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('247', '3502', 'uploadfile', '上传过程文件', '114', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('248', '3502', 'printDetail', '打印详细', '114', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('249', '3502', 'replyidea', '批复意见', '114', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('250', '3502', 'replyfile', '上传批复文件', '114', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('251', '3502', 'certificate', '制证', '114', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('252', '3502', 'printDispose', '打印处理签', '114', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('253', '3502', 'view', '查看', '67', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('254', '3502', 'printDetail', '打印详情', '67', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('255', '3502', 'uploadfile', '上传过程文件', '67', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('256', '3502', 'replyidea', '批复意见', '67', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('257', '3502', 'replyfile', '上传批复文件', '67', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('258', '3502', 'certificate', '制证', '67', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('259', '3502', 'printDispose', '打印处理签', '67', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('260', '3502', 'export', '导出', '67', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('261', '3502', 'export', '导出', '114', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('262', '3502', 'query', '查询', '130', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('263', '3502', 'query', '查询', '131', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('264', '3502', 'query', '查询', '132', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('265', '3502', 'query', '查询', '133', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('266', '3502', 'query', '查询', '136', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('267', '3502', 'query', '查询', '134', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('268', '3502', 'view', '查看', '137', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('269', '3502', 'view', '查看', '138', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('270', '3502', 'query', '查看', '135', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('271', '3502', 'payConfirm', '缴费确认', '134', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('272', '3502', 'print', '打印', '135', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('273', '3502', 'query', '查询', '140', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('274', '3502', 'query', '查询', '141', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('275', '3502', 'trainCompany', '保安培训公司分析', '113', '', '2017-08-13 14:27:27', '2017-08-13 14:27:29', 'system');
INSERT INTO `operation` VALUES ('276', '3502', 'confessCompany', '自招保安公司分析', '113', '', '2017-08-13 14:27:27', '2017-08-13 14:27:29', 'system');
INSERT INTO `operation` VALUES ('277', '3502', 'securityCompanyManager', '保安服务公司管理数据查询', '113', '', '2017-08-13 14:27:27', '2017-08-13 14:27:29', 'system');
INSERT INTO `operation` VALUES ('278', '3502', 'trainCompanyManager', '保安培训公司管理数据查询', '113', '', '2017-08-13 14:27:27', '2017-08-13 14:27:29', 'system');
INSERT INTO `operation` VALUES ('279', '3502', 'confessCompanyManager', '自招保安公司管理数据查询', '113', '', '2017-08-13 14:27:27', '2017-08-13 14:27:29', 'system');
INSERT INTO `operation` VALUES ('280', '3502', 'securityPersonManager', '保安员数据查询', '113', '', '2017-08-13 14:27:27', '2017-08-13 14:27:29', 'system');
INSERT INTO `operation` VALUES ('281', '3502', 'query', '查询', '64', '', '2017-06-30 17:09:49', '2017-06-30 17:09:51', 'system');
INSERT INTO `operation` VALUES ('282', '3502', 'query', '查询', '78', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('283', '3502', 'query', '查询', '143', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('284', '3502', 'query', '查询', '144', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('285', '3502', 'query', '查询', '145', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('286', '3502', 'query', '查询', '146', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('287', '3502', 'query', '查询', '65', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('288', '3502', 'query', '查询', '119', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('289', '3502', 'query', '查询', '75', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('290', '3502', 'query', '查询', '77', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('291', '3502', 'query', '查询', '76', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('292', '3502', 'query', '查询', '129', '', '2018-12-01 10:51:45', '2018-12-01 10:51:45', 'system');
INSERT INTO `operation` VALUES ('293', '3502', 'print', '打印', '130', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('294', '3502', 'download', '下载PDF文件', '130', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('295', '3502', 'edit', '修改', '130', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('296', '3502', 'print', '打印', '131', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('297', '3502', 'download', '下载PDF', '131', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('298', '3502', 'edit', '修改', '131', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('299', '3502', 'export', '导出', '135', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('300', '3502', 'receive', '领取', '135', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('301', '3502', 'uploadImg', '上传头像', '135', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('302', '3502', 'import', '导入', '135', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('303', '3502', 'export', '导出', '68', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('304', '3502', 'view', '查看', '68', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('305', '3502', 'export', '导出', '70', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('306', '3502', 'view', '查看', '70', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('307', '3502', 'uploadReceipt', '上传回执单', '70', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('308', '3502', 'view', '查看', '69', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('309', '3502', 'export', '导出', '69', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('310', '3502', 'uploadReceipt', '上传回执单', '69', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('311', '3502', 'view', '查看', '74', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('312', '3502', 'seal', '盖章', '74', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('313', '3502', 'view', '查看', '115', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('314', '3502', 'view', '查看', '71', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('315', '3502', 'export', '导出', '71', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('316', '3502', 'certificate', '制证', '71', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('317', '3502', 'printDetail', '打印详细', '71', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('318', '3502', 'printHandle', '打印处理签', '71', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('319', '3502', 'uploadReceipt', '上传回执单', '71', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('320', '3502', 'download', '下载PDF', '140', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('321', '3502', 'edit', '修改', '140', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('322', '3502', 'print', '打印', '140', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('323', '3502', 'view', '查看', '141', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('324', '3502', 'export', '导出', '141', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('325', '3502', 'uploadReceipt', '上传通知书', '141', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('326', '3502', 'view', '查看', '112', '', '2017-08-13 14:27:27', '2017-08-13 14:27:29', 'system');
INSERT INTO `operation` VALUES ('327', '3502', 'export', '导出', '110', '', '2017-08-13 14:27:27', '2017-08-13 14:27:29', 'system');
INSERT INTO `operation` VALUES ('328', '3502', 'view', '查看', '110', '', '2017-08-13 14:27:27', '2017-08-13 14:27:29', 'system');
INSERT INTO `operation` VALUES ('329', '3502', 'export', '导出', '146', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('330', '3502', 'import', '导入', '146', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('331', '3502', 'edit', '修改', '146', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('332', '3502', 'add', '新增', '146', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('333', '3502', 'view', '查看', '129', '', '2018-12-01 10:51:45', '2018-12-01 10:51:45', 'system');
INSERT INTO `operation` VALUES ('334', '3502', 'enterFingerprint', '录入指纹', '134', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('335', '3502', 'approvalResult', '审查报告', '134', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('336', '3502', 'examPersonMark', '录入成绩', '134', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('337', '3502', 'view', '查看', '151', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('338', '3502', 'view', '查看', '152', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('339', '3502', 'view', '查看', '154', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('340', '3502', 'view', '查看', '157', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('341', '3502', 'view', '查看', '159', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('342', '3502', 'view', '查看', '161', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('343', '3502', 'view', '查看', '163', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('344', '3502', 'view', '查看', '150', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('345', '3502', 'view', '查看', '153', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('346', '3502', 'view', '查看', '155', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('347', '3502', 'view', '查看', '156', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('348', '3502', 'view', '查看', '158', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('349', '3502', 'view', '查看', '160', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` VALUES ('350', '3502', 'view', '查看', '162', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `operation` (`id`, `native_code`, `code`, `name`, `module_id`, `active`, `create_time`, `update_time`, `update_by`) VALUES ('351', '3502', 'view', '查看', '168', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');
INSERT INTO `module` (`id`, `native_code`, `code`, `name`, `url`, `seq`, `index`, `shortcut`, `class`, `action`, `active`, `create_time`, `update_time`, `update_by`, `moduletype`, `p_id`) VALUES ('169', '3502', 'todoList', '审批进度', '', '2', '\0', '\0', '', '', '', '2017-03-01 10:29:32', '2017-03-01 10:29:34', 'system', '4', '166');
INSERT INTO `module` (`id`, `native_code`, `code`, `name`, `url`, `seq`, `index`, `shortcut`, `class`, `action`, `active`, `create_time`, `update_time`, `update_by`, `moduletype`, `p_id`) VALUES ('170', '3502', 'todoList', '审批进度', '', '2', '\0', '\0', '', '', '', '2017-03-01 10:29:32', '2017-03-01 10:29:34', 'system', '2', '166');
INSERT INTO `operation` (`id`, `native_code`, `code`, `name`, `module_id`, `active`, `create_time`, `update_time`, `update_by`) VALUES ('353', '3502', 'view', '查看', '170', '', '2017-06-30 17:53:18', '2017-06-30 17:53:20', 'system');




