/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.util.redis;

import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;

@Service
public class RedisUtil {
    private Logger log = LoggerFactory.getLogger(RedisUtil.class);
    @Autowired
    protected RedisTemplate<String, String> redisTemplate;
    @Value(value="${redisPrefixKey}")
    public String REDIS_PREFIX_KEY = "ARS:";

    public void setRedisTemplate(RedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    protected RedisSerializer<String> getRedisSerializer() {
        return this.redisTemplate.getStringSerializer();
    }

    public void set(String key, String value) {
        this.redisTemplate.opsForValue().set((Object)(this.REDIS_PREFIX_KEY + key), (Object)value);
    }

    public void multiSet(Map<String, String> map) {
        this.redisTemplate.opsForValue().multiSet(map);
    }

    public void set(String key, String value, int timeout) {
        this.redisTemplate.opsForValue().set((Object)(this.REDIS_PREFIX_KEY + key), (Object)value, (long)timeout, TimeUnit.SECONDS);
    }

    public void set(String key, String value, int timeout, TimeUnit timeUnit) {
        this.redisTemplate.opsForValue().set((Object)(this.REDIS_PREFIX_KEY + key), (Object)value, (long)timeout, timeUnit);
    }

    public String get(String key) {
        return (String)this.redisTemplate.opsForValue().get((Object)(this.REDIS_PREFIX_KEY + key));
    }

    public boolean hasKey(String key) {
        String value = (String)this.redisTemplate.opsForValue().get((Object)(this.REDIS_PREFIX_KEY + key));
        return value != null && "".equals(value);
    }

    public void delete(String key) {
        this.redisTemplate.delete((Object)(this.REDIS_PREFIX_KEY + key));
    }

    public String createAutoID(String key, int length, long timeout) {
        key = MessageFormat.format("{0}{1}", this.REDIS_PREFIX_KEY, key);
        Long autoID = this.redisTemplate.opsForValue().increment((Object)key, 1L);
        this.redisTemplate.expire((Object)key, timeout, TimeUnit.DAYS);
        return this.getSequence(autoID, length);
    }

    public Long getCount(String key, long timeout) {
        key = MessageFormat.format("{0}{1}", this.REDIS_PREFIX_KEY, key);
        Long autoID = this.redisTemplate.opsForValue().increment((Object)key, 1L);
        this.redisTemplate.expire((Object)key, timeout, TimeUnit.DAYS);
        return autoID;
    }

    private String getSequence(long seq, int length) {
        String str = String.valueOf(seq);
        int len = str.length();
        if (len >= length) {
            return str;
        }
        int rest = length - len;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < rest; ++i) {
            sb.append('0');
        }
        sb.append(str);
        return sb.toString();
    }
}

