/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.util.thread;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolManager {
    private static ThreadPoolManager sThreadPoolManager = new ThreadPoolManager();
    private static final int SIZE_CORE_POOL = 15;
    private static final int SIZE_MAX_POOL = 15;
    private final ThreadPoolExecutor mThreadPool = new ThreadPoolExecutor(15, 15, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());

    public static ThreadPoolManager newInstance() {
        return sThreadPoolManager;
    }

    private ThreadPoolManager() {
    }

    public void perpare() {
        if (this.mThreadPool.isShutdown() && !this.mThreadPool.prestartCoreThread()) {
            int n = this.mThreadPool.prestartAllCoreThreads();
        }
    }

    public void addExecuteTask(Runnable task) {
        if (task != null) {
            this.mThreadPool.execute(task);
        }
    }

    public Future submitTask(Callable task) {
        if (task != null) {
            return this.mThreadPool.submit(task);
        }
        return null;
    }

    protected boolean isTaskEnd() {
        return this.mThreadPool.getActiveCount() == 0;
    }

    public int getQueue() {
        return this.mThreadPool.getQueue().size();
    }

    public int getPoolSize() {
        return this.mThreadPool.getPoolSize();
    }

    public long getCompletedTaskCount() {
        return this.mThreadPool.getCompletedTaskCount();
    }

    public void shutdown() {
        this.mThreadPool.shutdown();
    }
}

