/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.util.huawei;

import com.bcxin.ars.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CheckPathUtil {
    private static final Logger log = LoggerFactory.getLogger(CheckPathUtil.class);
    private static HashMap<String, String> filePathMap = new HashMap();
    private static HashMap<String, String> urlPathMap = new HashMap();
    private static HashMap<String, String> jsonPathMap = new HashMap();

    private static String checkPath(String path, HashMap<String, String> map) {
        String temp = "";
        for (int i = 0; i < path.length(); ++i) {
            if (map.get(path.charAt(i) + "") != null) {
                temp = temp + map.get(path.charAt(i) + "");
                continue;
            }
            if (!CheckPathUtil.isChinese(path.charAt(i))) continue;
            temp = temp + path.charAt(i);
        }
        return temp;
    }

    public static String filePathFormat(String path) {
        path = CheckPathUtil.checkPath(path, filePathMap);
        return path;
    }

    public static String urlPathFormat(String path) {
        path = CheckPathUtil.checkPath(path, urlPathMap);
        return path;
    }

    public static String filePathFormatWithEncode(String path, String charset) {
        try {
            path = CheckPathUtil.checkPath(URLEncoder.encode(path, charset), filePathMap);
            return URLDecoder.decode(path, charset);
        }
        catch (UnsupportedEncodingException e) {
            log.error("unsupportedEncoding exception in filepathformat");
            return "";
        }
    }

    public static String urlPathFormatWithEncode(String path, String charset) {
        try {
            path = CheckPathUtil.checkPath(URLEncoder.encode(path, charset), urlPathMap);
            return URLDecoder.decode(path, charset);
        }
        catch (UnsupportedEncodingException e) {
            log.error("unsupportedEncoding exception in urlpathformat");
            return "";
        }
    }

    public static String jsonPathFormatWithEncode(String path, String charset) {
        try {
            path = CheckPathUtil.checkPath(URLEncoder.encode(path, charset), jsonPathMap);
            return URLDecoder.decode(path, charset);
        }
        catch (UnsupportedEncodingException e) {
            log.error("Json path format with encode failed");
            return "";
        }
    }

    private static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static String getIpFromHttpAddress(String httpAddress) {
        if (StringUtil.isEmpty(httpAddress)) {
            return null;
        }
        try {
            URL url = new URL(CheckPathUtil.urlPathFormatWithEncode(httpAddress, "UTF-8"));
            return url.getHost();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static int getPortFromHttpAddress(String httpAddress) {
        if (StringUtil.isEmpty(httpAddress)) {
            return -1;
        }
        try {
            URL url = new URL(CheckPathUtil.urlPathFormatWithEncode(httpAddress, "UTF-8"));
            return url.getPort();
        }
        catch (MalformedURLException malformedURLException) {
            return -1;
        }
    }

    public static String getSchemeFromHttpAddress(String httpAddress) {
        if (StringUtil.isEmpty(httpAddress)) {
            return null;
        }
        try {
            URL url = new URL(CheckPathUtil.urlPathFormatWithEncode(httpAddress, "UTF-8"));
            return url.getProtocol();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    static {
        filePathMap.put("a", "a");
        filePathMap.put("b", "b");
        filePathMap.put("c", "c");
        filePathMap.put("d", "d");
        filePathMap.put("e", "e");
        filePathMap.put("f", "f");
        filePathMap.put("g", "g");
        filePathMap.put("h", "h");
        filePathMap.put("i", "i");
        filePathMap.put("j", "j");
        filePathMap.put("k", "k");
        filePathMap.put("l", "l");
        filePathMap.put("m", "m");
        filePathMap.put("n", "n");
        filePathMap.put("o", "o");
        filePathMap.put("p", "p");
        filePathMap.put("q", "q");
        filePathMap.put("r", "r");
        filePathMap.put("s", "s");
        filePathMap.put("t", "t");
        filePathMap.put("u", "u");
        filePathMap.put("v", "v");
        filePathMap.put("w", "w");
        filePathMap.put("x", "x");
        filePathMap.put("y", "y");
        filePathMap.put("z", "z");
        filePathMap.put("A", "A");
        filePathMap.put("B", "B");
        filePathMap.put("C", "C");
        filePathMap.put("D", "D");
        filePathMap.put("E", "E");
        filePathMap.put("F", "F");
        filePathMap.put("G", "G");
        filePathMap.put("H", "H");
        filePathMap.put("I", "I");
        filePathMap.put("J", "J");
        filePathMap.put("K", "K");
        filePathMap.put("L", "L");
        filePathMap.put("M", "M");
        filePathMap.put("N", "N");
        filePathMap.put("O", "O");
        filePathMap.put("P", "P");
        filePathMap.put("Q", "Q");
        filePathMap.put("R", "R");
        filePathMap.put("S", "S");
        filePathMap.put("T", "T");
        filePathMap.put("U", "U");
        filePathMap.put("V", "V");
        filePathMap.put("W", "W");
        filePathMap.put("X", "X");
        filePathMap.put("Y", "Y");
        filePathMap.put("Z", "Z");
        filePathMap.put("0", "0");
        filePathMap.put("1", "1");
        filePathMap.put("2", "2");
        filePathMap.put("3", "3");
        filePathMap.put("4", "4");
        filePathMap.put("5", "5");
        filePathMap.put("6", "6");
        filePathMap.put("7", "7");
        filePathMap.put("8", "8");
        filePathMap.put("9", "9");
        filePathMap.put(".", ".");
        filePathMap.put(":", ":");
        filePathMap.put("/", "/");
        filePathMap.put("\\", "\\");
        filePathMap.put("-", "-");
        filePathMap.put("_", "_");
        filePathMap.put("%", "%");
        urlPathMap.putAll(filePathMap);
        urlPathMap.put("`", "`");
        urlPathMap.put("~", "~");
        urlPathMap.put("!", "!");
        urlPathMap.put("@", "@");
        urlPathMap.put("#", "#");
        urlPathMap.put("$", "$");
        urlPathMap.put("^", "^");
        urlPathMap.put("&", "&");
        urlPathMap.put("*", "*");
        urlPathMap.put("(", "(");
        urlPathMap.put(")", ")");
        urlPathMap.put("=", "=");
        urlPathMap.put("+", "+");
        urlPathMap.put("[", "[");
        urlPathMap.put("{", "{");
        urlPathMap.put("]", "]");
        urlPathMap.put("}", "}");
        urlPathMap.put(";", ";");
        urlPathMap.put(":", ":");
        urlPathMap.put("'", "'");
        urlPathMap.put("\"", "\"");
        urlPathMap.put("|", "|");
        urlPathMap.put(",", ",");
        urlPathMap.put("<", "<");
        urlPathMap.put(".", ".");
        urlPathMap.put(">", ">");
        urlPathMap.put("/", "/");
        urlPathMap.put("?", "?");
        jsonPathMap.putAll(urlPathMap);
        jsonPathMap.put(" ", " ");
    }
}

