package com.bcxin.ars.util;

import com.itextpdf.text.*;
import com.itextpdf.text.pdf.*;

import java.io.FileOutputStream;
import java.io.IOException;

/**
 * @Auther linqinglin
 * @date 2020/11/15 10:36
 */
public class ItextPDFUtil {

    /**
     * 表格各种属性综合使用
     *
     * @throws IOException
     * @throws DocumentException
     */
    public static void createTablePdf() throws IOException, DocumentException {
        Document document = new Document(PageSize.A4, 10, 10, 10, 10);
//        Document document = new Document();
        // 创建PdfWriter对象
        PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream("d:\\2.pdf"));
        // 打开文档
        document.open();
//        document.add(new Paragraph("北京市保安员培训资金补贴审批表"));
        // 添加表格，3列
        PdfPTable table = new PdfPTable(3);
        //设置表格宽度比例为%100
        table.setWidthPercentage(100);
        // 设置表格的宽度
        table.setTotalWidth(560);
        // 也可以每列分别设置宽度
        table.setTotalWidth(new float[] { 80, 160, 320 });
        // 锁住宽度
        table.setLockedWidth(true);
        // 设置表格上面空白宽度
        table.setSpacingBefore(10f);
        // 设置表格下面空白宽度
        table.setSpacingAfter(10f);
        // 设置表格默认为无边框
        table.getDefaultCell().setBorder(0);
        PdfContentByte cb = writer.getDirectContent();

        // 构建每个单元格

        PdfPCell cell1 = new PdfPCell(new Paragraph("北京市保安员培训资金补贴审批表",ItextPDFUtil.setFont(22)));

        // 设置距左边的距离
//        cell1.setPaddingLeft(10);
        // 设置占用列数
        cell1.setColspan(3);
        cell1.setRowspan(1);
        // 设置高度
        cell1.setFixedHeight(120);

        cell1.setHorizontalAlignment(Element.ALIGN_CENTER);
        cell1.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell1.setBorder(Rectangle.NO_BORDER);
        table.addCell(cell1);

        PdfPCell cell2 = new PdfPCell(new Paragraph("申请事项\r\n基本情况",ItextPDFUtil.setFont(16)));
        // 设置跨行
        cell2.setRowspan(4);
        // 边框颜色
        cell2.setBorderColor(BaseColor.BLACK);
        // 设置距左边的距离
//        cell2.setPaddingLeft(10);
        // 设置高度
        cell2.setFixedHeight(40);
        // 设置内容水平居中显示
        cell2.setHorizontalAlignment(Element.ALIGN_CENTER);
        // 设置垂直居中
        cell2.setVerticalAlignment(Element.ALIGN_MIDDLE);
        table.addCell(cell2);


        PdfPCell cell3 = new PdfPCell(new Paragraph("补贴内容",ItextPDFUtil.setFont(16)));
        // 设置跨行
        cell3.setRowspan(2);
        // 边框颜色
        cell3.setBorderColor(BaseColor.BLACK);
        // 设置距左边的距离
//        cell3.setPaddingLeft(10);
        // 设置高度
        cell3.setFixedHeight(40);
        // 设置内容水平居中显示
        cell3.setHorizontalAlignment(Element.ALIGN_CENTER);
        // 设置垂直居中
        cell3.setVerticalAlignment(Element.ALIGN_MIDDLE);
        table.addCell(cell3);

        PdfPCell cell4 = new PdfPCell(new Paragraph("保安员岗位资格培训补贴",ItextPDFUtil.setFont(16)));
        // 边框颜色
        cell4.setBorderColor(BaseColor.BLACK);
        // 设置距左边的距离
//        cell4.setPaddingLeft(10);
        // 设置高度
        cell4.setFixedHeight(40);
        // 设置内容水平居中显示
        cell4.setHorizontalAlignment(Element.ALIGN_CENTER);
        // 设置垂直居中
        cell4.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell4.setRowspan(1);
        table.addCell(cell4);

        PdfPCell cell5 = new PdfPCell(new Paragraph("保安员职业技能培训补贴",ItextPDFUtil.setFont(16)));
        // 边框颜色
        cell5.setBorderColor(BaseColor.BLACK);
        // 设置距左边的距离
//        cell5.setPaddingLeft(10);
        // 设置高度
        cell5.setFixedHeight(40);
        // 设置内容水平居中显示
        cell5.setHorizontalAlignment(Element.ALIGN_CENTER);
        // 设置垂直居中
        cell5.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell5.setRowspan(1);
        table.addCell(cell5);

        PdfPCell cell6 = new PdfPCell(new Paragraph("申请补贴周期",ItextPDFUtil.setFont(16)));
        // 边框颜色
        cell6.setBorderColor(BaseColor.BLACK);
        // 设置距左边的距离
//        cell6.setPaddingLeft(10);
        // 设置高度
        cell6.setFixedHeight(40);
        // 设置内容水平居中显示
        cell6.setHorizontalAlignment(Element.ALIGN_CENTER);
        // 设置垂直居中
        cell6.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell6.setRowspan(1);
        table.addCell(cell6);


        PdfPCell cell7 = new PdfPCell(new Paragraph("202*年*月*日—202*年*月*日",ItextPDFUtil.setFont(16)));
        // 边框颜色
        cell7.setBorderColor(BaseColor.BLACK);
        // 设置距左边的距离
//        cell7.setPaddingLeft(10);
        // 设置高度
        cell7.setFixedHeight(40);
        // 设置内容水平居中显示
        cell7.setHorizontalAlignment(Element.ALIGN_CENTER);
        // 设置垂直居中
        cell7.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell7.setRowspan(1);
        table.addCell(cell7);


        PdfPCell cell8 = new PdfPCell(new Paragraph("补贴资金总额",ItextPDFUtil.setFont(16)));
        // 边框颜色
        cell8.setBorderColor(BaseColor.BLACK);
        // 设置距左边的距离
//        cell8.setPaddingLeft(10);
        // 设置高度
        cell8.setFixedHeight(40);
        // 设置内容水平居中显示
        cell8.setHorizontalAlignment(Element.ALIGN_CENTER);
        // 设置垂直居中
        cell8.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell8.setRowspan(1);
        table.addCell(cell8);


        PdfPCell cell9 = new PdfPCell(new Paragraph("",ItextPDFUtil.setFont(16)));
        // 边框颜色
        cell9.setBorderColor(BaseColor.BLACK);
        // 设置距左边的距离
//        cell9.setPaddingLeft(10);
        // 设置高度
        cell9.setFixedHeight(40);
        // 设置内容水平居中显示
        cell9.setHorizontalAlignment(Element.ALIGN_CENTER);
        // 设置垂直居中
        cell9.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell9.setRowspan(1);
        table.addCell(cell9);

        PdfPCell cell10 = new PdfPCell(new Paragraph("总队主管\r\n领导意见",ItextPDFUtil.setFont(16)));
        // 边框颜色
        cell10.setBorderColor(BaseColor.BLACK);
        // 设置距左边的距离
//        cell9.setPaddingLeft(10);
        // 设置高度
        cell10.setFixedHeight(120);
        // 设置内容水平居中显示
        cell10.setHorizontalAlignment(Element.ALIGN_CENTER);
        // 设置垂直居中
        cell10.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell10.setRowspan(2);
        table.addCell(cell10);

        PdfPCell cell11 = new PdfPCell(new Paragraph("",ItextPDFUtil.setFont(16)));
        // 边框颜色
        cell11.setBorderColor(BaseColor.BLACK);
        // 设置距左边的距离
//        cell9.setPaddingLeft(10);
        // 设置高度
        cell11.setFixedHeight(80);
        // 设置内容水平居中显示
        cell11.setHorizontalAlignment(Element.ALIGN_CENTER);
        // 设置垂直居中
        cell11.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell11.setRowspan(1);
        cell11.setColspan(2);
        //隐藏下边框
        cell11.disableBorderSide(2);
        table.addCell(cell11);

        PdfPCell cell12 = new PdfPCell(new Paragraph("签字:",ItextPDFUtil.setFont(16)));
        // 边框颜色
        cell12.setBorderColor(BaseColor.BLACK);
        // 设置距左边的距离
        cell12.setPaddingLeft(10);
        cell12.setBorder(Rectangle.NO_BORDER);
        // 设置高度
        cell12.setFixedHeight(40);
        // 设置内容水平居中显示
        cell12.setHorizontalAlignment(Element.ALIGN_LEFT);
        // 设置垂直居中
        cell12.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell12.setRowspan(1);
        cell12.setColspan(1);
        table.addCell(cell12);

        PdfPCell cell13 = new PdfPCell(new Paragraph("年    月    日",ItextPDFUtil.setFont(16)));
        // 边框颜色
        cell13.setBorderColor(BaseColor.BLACK);
        //隐藏左、上、下边框
        cell13.disableBorderSide(7);
        // 设置距右边的距离
        cell13.setPaddingRight(20);
        // 设置高度
        cell13.setFixedHeight(40);
        // 设置内容水平居中显示
        cell13.setHorizontalAlignment(Element.ALIGN_RIGHT);
        // 设置垂直居中
        cell13.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell13.setRowspan(1);
        cell13.setColspan(1);
        table.addCell(cell13);


        PdfPCell cell14 = new PdfPCell(new Paragraph("保安管理\r\n支队领导\r\n意见",ItextPDFUtil.setFont(16)));
        // 边框颜色
        cell14.setBorderColor(BaseColor.BLACK);
        // 设置高度
        cell14.setFixedHeight(120);
        // 设置内容水平居中显示
        cell14.setHorizontalAlignment(Element.ALIGN_CENTER);
        // 设置垂直居中
        cell14.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell14.setRowspan(2);
        table.addCell(cell14);

        PdfPCell cell15 = new PdfPCell(new Paragraph("拟同意，请       审批。",ItextPDFUtil.setFont(16)));
        // 边框颜色
        cell15.setBorderColor(BaseColor.BLACK);
        // 设置高度
        cell15.setFixedHeight(80);
        // 设置内容水平居中显示
        cell15.setHorizontalAlignment(Element.ALIGN_CENTER);
        // 设置垂直居中
        cell15.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell15.setRowspan(1);
        cell15.setColspan(2);
        //隐藏下边框
        cell15.disableBorderSide(2);
        table.addCell(cell15);

        PdfPCell cell16 = new PdfPCell(new Paragraph("签字:",ItextPDFUtil.setFont(16)));
        // 边框颜色
        cell16.setBorderColor(BaseColor.BLACK);
        // 设置距左边的距离
        cell16.setPaddingLeft(10);
        cell16.setBorder(Rectangle.NO_BORDER);
        // 设置高度
        cell16.setFixedHeight(40);
        // 设置内容水平居中显示
        cell16.setHorizontalAlignment(Element.ALIGN_LEFT);
        // 设置垂直居中
        cell16.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell16.setRowspan(1);
        cell16.setColspan(1);
        table.addCell(cell16);

        PdfPCell cell17 = new PdfPCell(new Paragraph("年    月    日",ItextPDFUtil.setFont(16)));
        // 边框颜色
        cell17.setBorderColor(BaseColor.BLACK);
        //隐藏左、上、下边框
        cell17.disableBorderSide(7);
        // 设置距右边的距离
        cell17.setPaddingRight(20);
        // 设置高度
        cell17.setFixedHeight(40);
        // 设置内容水平居中显示
        cell17.setHorizontalAlignment(Element.ALIGN_RIGHT);
        // 设置垂直居中
        cell17.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell17.setRowspan(1);
        cell17.setColspan(1);
        table.addCell(cell17);


        PdfPCell cell18 = new PdfPCell(new Paragraph("承办人\r\n意见",ItextPDFUtil.setFont(16)));
        // 边框颜色
        cell18.setBorderColor(BaseColor.BLACK);
        // 设置距左边的距离
//        cell9.setPaddingLeft(10);
        // 设置高度
        cell18.setFixedHeight(120);
        // 设置内容水平居中显示
        cell18.setHorizontalAlignment(Element.ALIGN_CENTER);
        // 设置垂直居中
        cell18.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell18.setRowspan(2);
        table.addCell(cell18);

        PdfPCell cell19 = new PdfPCell(new Paragraph("经审核，补贴人员均符合资格，金额核对无误。",ItextPDFUtil.setFont(16)));
        // 边框颜色
        cell19.setBorderColor(BaseColor.BLACK);
        // 设置高度
        cell19.setFixedHeight(80);
        // 设置内容水平居中显示
        cell19.setHorizontalAlignment(Element.ALIGN_CENTER);
        // 设置垂直居中
        cell19.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell19.setRowspan(1);
        cell19.setColspan(2);
        //隐藏下边框
        cell19.disableBorderSide(2);
        table.addCell(cell19);

        PdfPCell cell20 = new PdfPCell(new Paragraph("签字:",ItextPDFUtil.setFont(16)));
        // 边框颜色
        cell20.setBorderColor(BaseColor.BLACK);
        // 设置距左边的距离
        cell20.setPaddingLeft(10);
        //隐藏右、上边框
        cell20.disableBorderSide(9);
        // 设置高度
        cell20.setFixedHeight(40);
        // 设置内容水平居中显示
        cell20.setHorizontalAlignment(Element.ALIGN_LEFT);
        // 设置垂直居中
        cell20.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell20.setRowspan(1);
        cell20.setColspan(1);
        table.addCell(cell20);

        PdfPCell cell21 = new PdfPCell(new Paragraph("年    月    日",ItextPDFUtil.setFont(16)));
        // 边框颜色
        cell21.setBorderColor(BaseColor.BLACK);
        //隐藏左、上边框
        cell21.disableBorderSide(5);
        // 设置距右边的距离
        cell21.setPaddingRight(20);
        // 设置高度
        cell21.setFixedHeight(40);
        // 设置内容水平居中显示
        cell21.setHorizontalAlignment(Element.ALIGN_RIGHT);
        // 设置垂直居中
        cell21.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell21.setRowspan(1);
        cell21.setColspan(1);
        table.addCell(cell21);
        document.add(table);
        document.newPage();


        // 关闭文档
        document.close();
    }

    /**
     * 设置字体编码格式
     * @return
     */
    public static Font setFont(int fontSize){
        BaseFont baseFont = null;
        try {
            baseFont = BaseFont.createFont("STSongStd-Light" ,"UniGB-UCS2-H",BaseFont.NOT_EMBEDDED);
        } catch (DocumentException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        Font font = new Font(baseFont, fontSize, Font.NORMAL);
        return font;
    }

    public static void main(String[] args) {
        try {
            createTablePdf();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (DocumentException e) {
            e.printStackTrace();
        }
    }
}
