package com.bcxin.ars.util;

import net.coobird.thumbnailator.Thumbnails;

import javax.imageio.ImageIO;
import javax.swing.*;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.*;
import java.net.URL;
import java.util.Base64;

/**
 * @author linqinglin
 * @date 2020/03/30 0030 17:47
 */
public class ImageUtil {

    public static String generateImgByUrl(String url) throws Exception {

        //load the webpage into the editor
        //JEditorPane ed = new JEditorPane(new URL("https://www.baidu.com/"));
        JEditorPane ed = new JEditorPane(new URL(url));
        ed.setSize(1200,900);

        //create a new image
        BufferedImage image = new BufferedImage(ed.getWidth(), ed.getHeight(), BufferedImage.TYPE_INT_ARGB);

        //paint the editor onto the image
        SwingUtilities.paintComponent(image.createGraphics(), ed, new JPanel(), 0, 0, image.getWidth(), image.getHeight());
        //save the image to file

        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

        ImageIO.write((RenderedImage)image, "png", new File("E:\\1.png"));
        ImageIO.write((RenderedImage)image, "jpg", outputStream);
        Base64.Encoder encoder = Base64.getEncoder();

        return "data:image/jpg;base64," + encoder.encodeToString(outputStream.toByteArray());
    }

    public static byte[] readFileToByteArray(File file) throws Exception {
        byte[] fileb = null;
        InputStream is = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();

        try {
            is = new FileInputStream(file);
            byte[] b = new byte[1024];

            int n;
            while ((n = is.read(b)) != -1) {
                out.write(b, 0, n);
            }

            fileb = out.toByteArray();
            return fileb;
        } catch (Exception var16) {
            throw new Exception("readFileToByteArray", var16);
        } finally {
            if (is != null) {
                try {
                    is.close();
                } catch (Exception var15) {
                    ;
                }
            }

            if (out != null) {
                try {
                    out.close();
                } catch (Exception var14) {
                    ;
                }
            }

        }
    }



    public static void main(String[] args) throws IOException {
        File dir = new File("C:\\Users\\Administrator\\Documents\\WeChat Files\\maidou070\\FileStorage\\File\\2020-09\\申请设立保安服务公司材料参考模板\\7拟设保安服务公司住所的所有权或者使用权的房产证\\房产证\\");
        for (File file : dir.listFiles()) {
            System.out.println(file.getPath());
            System.out.println(file.length());
            if(file.length() > 800000) {
                Thumbnails.of(new FileInputStream(file)).scale(0.5).toFile(new File(file.getPath()));
            }
        }

        try {
            //System.out.println(ImageUtil.generateImgByUrl("https://zhidao.baidu.com/question/714700442134411245.html"));
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}
