package com.bcxin.ars.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dto.AjaxResult;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHeaders;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
/**
 * Http请求工具类
 * @author subh
 */
public class HttpClientUtils {

	/**
	 * 日志
	 */
	public static Logger logger = LoggerFactory.getLogger(HttpClientUtils.class);

    /****
     * 带文件发送post请求
     * @param url 地址
     * @param value 文件
     * @return
     * @throws Exception
     */
    public static AjaxResult FilePost(String url, File value) throws  Exception {
        String BOUNDARY = java.util.UUID.randomUUID().toString();
        MultipartEntity multipartEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE, "--------------------"+BOUNDARY, Charset.defaultCharset());
        //multipartEntity.addPart("key",new StringBody("123456",Charset.forName("UTF-8")));
        //multipartEntity.addPart("from",new StringBody("cw",Charset.forName("UTF-8")));
        multipartEntity.addPart("file", new FileBody(value));
        //InputStream inputStream=new FileInputStream(value);;
        //inputStream=new ByteArrayInputStream("字符串转输入流".getBytes(Charset.forName("UTF-8")));
        //inputStream= IOUtil.newInputStream(ByteBuffer.wrap("字符串".getBytes()));
        //multipartEntity.addPart("image_binary",new InputStreamBody(inputStream,"1.jpg"));
        HttpPost request = new HttpPost(url);
        request.setEntity(multipartEntity);
        request.addHeader("Content-Type", "multipart/form-data; boundary=--------------------"+BOUNDARY);
        //request.addHeader("Content-Type","image/jpeg");  //视情况而定

        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpResponse response = httpClient.execute(request);
        InputStream is = response.getEntity().getContent();
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        StringBuffer buffer = new StringBuffer();
        String line = "";
        while ((line = in.readLine()) != null) {
            buffer.append(line);
        }
        AjaxResult ajaxResult = JSONObject.parseObject(buffer.toString(), AjaxResult.class);
        return ajaxResult;
    }

    public static void main(String[] args) throws  Exception {
        File file =  new File("E:\\1.txt");
        HttpClientUtils.FilePost("http://localhost:8080/ars_rest_war_exploded/uploadFileForBj.do",file);
    }


	public static String getContentFromUrl(String url) {
		CloseableHttpClient httpClient = HttpClients.createDefault();
		try {
			HttpGet request = new HttpGet(url);
			request.setHeader(HttpHeaders.USER_AGENT,
					"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36");
			request.setHeader(HttpHeaders.ACCEPT, "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
			request.setHeader(HttpHeaders.ACCEPT_ENCODING, "gzip, deflate, sdch");
			request.setHeader(HttpHeaders.CONNECTION, "keep-alive");
			CloseableHttpResponse httpResponse = null;
			httpResponse = httpClient.execute(request);
			try {
				HttpEntity entity = httpResponse.getEntity();
				if (null != entity) {
					return EntityUtils.toString(entity);
				}
			} finally {
				httpResponse.close();
			}

		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (httpClient != null) {
					httpClient.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return null;
	}

	public static InputStream getStreamFromUrl(String url) {
		CloseableHttpClient httpClient = HttpClients.createDefault();
		HttpGet request = new HttpGet(url);

		request.setHeader(HttpHeaders.USER_AGENT,
				"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36");
		request.setHeader(HttpHeaders.ACCEPT,
				"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8");
		request.setHeader(HttpHeaders.ACCEPT_ENCODING, "gzip, deflate, sdch");
		request.setHeader(HttpHeaders.CONNECTION, "keep-alive");
		CloseableHttpResponse httpResponse = null;
		try {
			httpResponse = httpClient.execute(request);
			HttpEntity entity = httpResponse.getEntity();
			if (null != entity) {
				return entity.getContent();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public static String doPost(String url, Map<String, String> map, String charset) {
		CloseableHttpClient httpClient = HttpClients.createDefault();
		HttpPost httpPost = new HttpPost(url);
		String result = null;
		if (StringUtil.isEmpty(charset)) {
			charset = "utf-8";
		}
		try {
			// 设置参数
			List<NameValuePair> list = new ArrayList<NameValuePair>();
			// 遍历map集合
			for (Map.Entry<String, String> entry : map.entrySet()) {
				list.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
			}
			if (list.size() > 0) {
				// charset=utf-8或者gbk2312
				UrlEncodedFormEntity entity = new UrlEncodedFormEntity(list, charset);
				httpPost.setEntity(entity);
			}
			HttpResponse response = httpClient.execute(httpPost);
			if (response != null) {
				HttpEntity resEntity = response.getEntity();
				if (resEntity != null) {
					result = EntityUtils.toString(resEntity, charset);
				}
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		} finally {
			if (httpClient != null) {
				try {
					httpClient.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		return result;
	}
	/***
	 * 发送post请求，采用HttpURL方式
	 * @param urlString  网址
	 * @param params post表单数据
	 * @return 返回数据
	 * @since jdk1.1
	 */
	public static String doPostHttpURL(String urlString,Map<String,Object> params){
		//返回对接
		StringBuilder result = new StringBuilder();
		HttpURLConnection connection = null;
		BufferedReader reader = null;
		String line = null;
		try {
			//url带参数完整地址
			StringBuffer URLParams =  new StringBuffer(urlString);
			//加入?
			URLParams.append("?1=1");

			// 遍历params 参数集合
			for (Map.Entry<String, Object> entry : params.entrySet()) {
				URLParams.append("&").append(entry.getKey()).append("=").append(entry.getValue());
			}
			//URL
			URL url = new URL(URLParams.toString());
			//建立连接
			connection = (HttpURLConnection) url.openConnection();
			// 设置连接请求方式
			connection.setRequestMethod("POST");
			// 设置连接主机服务器超时时间：15000毫秒
			connection.setConnectTimeout(15000);
			// 设置读取主机服务器返回数据超时时间：60000毫秒
			connection.setReadTimeout(60000);
			// 默认值为：false，当向远程服务器传送数据/写数据时，需要设置为true
			connection.setDoOutput(true);
			// 默认值为：true，当前向远程服务读取数据时，设置为true，该参数可有可无
			connection.setDoInput(true);
			// 设置传入参数的格式:请求参数应该是 name1=value1&name2=value2 的形式。
			connection.setRequestProperty("Content-Type", "application/json");
			//connection.setRequestProperty("Content-type", "textml");
			connection.setRequestProperty("Accept-Charset", "utf-8");
			connection.setRequestProperty("contentType", "utf-8");
			//connection.setRequestProperty("Charsert", "UTF-8"); // 设置请求编码
			// 通过连接对象获取一个输出流
			connection.getOutputStream();
			if (connection.getResponseCode() == HttpURLConnection.HTTP_OK) {
				reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));// 发送http请求
				// 循环读取流
				while ((line = reader.readLine()) != null) {
					result.append(line).append(System.getProperty("line.separator"));// "\n"
				}
			}
		} catch (IOException e) {
		    e.printStackTrace();
			logger.error(e.getMessage(),e);
		} finally {
		    if(reader!=null) {
                try {
                    reader.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
			connection.disconnect();
		}
		return result.toString();
	}



	/***
	 * 发送post请求，采用HttpURL方式
	 * @param urlString  网址
	 * @param token  tonken
	 * @param xmlStr  xmlStr
	 * @return 返回数据
	 * @since jdk1.1
	 */
	public static String doPostHttpURL(String urlString,String token,String xmlStr){
		StringBuilder result = new StringBuilder();
		HttpURLConnection connection = null;
		OutputStreamWriter osw = null;
		BufferedReader reader = null;
		String line = null;
		try {
			URL url = new URL(urlString);
			connection = (HttpURLConnection) url.openConnection();
			// 设置连接请求方式
			connection.setRequestMethod("POST");
			// 设置连接主机服务器超时时间：15000毫秒
			connection.setConnectTimeout(15000);
			// 设置读取主机服务器返回数据超时时间：60000毫秒
			connection.setReadTimeout(60000);
			// 默认值为：false，当向远程服务器传送数据/写数据时，需要设置为true
			connection.setDoOutput(true);   //需要输出
			// 默认值为：true，当前向远程服务读取数据时，设置为true，该参数可有可无
			connection.setDoInput(true);
			//不允许缓存
			connection.setUseCaches(false);
			// 设置传入参数的格式:请求参数应该是 name1=value1&name2=value2 的形式。
			connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
			connection.setRequestProperty("Charset", "UTF-8");

			osw = new OutputStreamWriter(connection.getOutputStream());
			osw.write("token="+token+"&xmlStr="+ URLEncoder.encode(xmlStr,"UTF-8"));
			osw.flush();
			if (connection.getResponseCode() == HttpURLConnection.HTTP_OK) {
				reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));// 发送http请求
				// 循环读取流
				while ((line = reader.readLine()) != null) {
					result.append(line).append(System.getProperty("line.separator"));// "\n"
				}
			}
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			try {
				if(reader != null){
					reader.close();
				}
				if(osw !=null){
					osw.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
			connection.disconnect();
		}
		return result.toString();
	}
    /***
     * 用josn格式的body参数发送post请求
     * @param methodUrl 地址
     * @param json 参数对象
     */
    public static String doPostByBody(String methodUrl,Object json) {
        //返回结果字符串
        StringBuilder result = new StringBuilder();
        HttpURLConnection connection = null;
        OutputStream dataout = null;
        BufferedReader reader = null;
        String line = null;
        try {
            URL url = new URL(methodUrl);
            connection = (HttpURLConnection) url.openConnection();// 根据URL生成HttpURLConnection
            connection.setDoOutput(true);// 设置是否向connection输出，因为这个是post请求，参数要放在http正文内，因此需要设为true,默认情况下是false
            connection.setDoInput(true); // 设置是否从connection读入，默认情况下是true;
            connection.setRequestMethod("POST");// 设置请求方式为post,默认GET请求
            connection.setUseCaches(false);// post请求不能使用缓存设为false
            connection.setConnectTimeout(3000);// 连接主机的超时时间
            connection.setReadTimeout(3000);// 从主机读取数据的超时时间
            connection.setInstanceFollowRedirects(true);// 设置该HttpURLConnection实例是否自动执行重定向
            connection.setRequestProperty("connection", "Keep-Alive");// 连接复用
            connection.setRequestProperty("charset", "utf-8");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Authorization", "Bearer 66cb225f1c3ff0ddfdae31rae2b57488aadfb8b5e7");
            connection.connect();// 建立TCP连接,getOutputStream会隐含的进行connect,所以此处可以不要
            dataout = new DataOutputStream(connection.getOutputStream());// 创建输入输出流,用于往连接里面输出携带的参数
            //判断对象是否为空
            if(json!=null) {
                dataout.write(JSON.toJSONString(json).getBytes());
            }
            dataout.flush();
            dataout.close();
            if (connection.getResponseCode() == HttpURLConnection.HTTP_OK) {
                reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));// 发送http请求
                // 循环读取流
                while ((line = reader.readLine()) != null) {
                    result.append(line).append(System.getProperty("line.separator"));//
                }
            }
        } catch (IOException e) {
            logger.error(e.getMessage(),e);
        } finally {
            //判断是否为空
            if(reader!=null) {
                try {
                    reader.close();
                } catch (IOException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            connection.disconnect();
        }
        return  result.toString();
    }
}