/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.util;

import com.bcxin.ars.util.Digests;
import com.bcxin.ars.util.Encodes;

public class Sha1Util {
    public static final String HASH_ALGORITHM = "SHA-1";
    public static final int HASH_INTERATIONS = 1024;
    public static final int SALT_SIZE = 8;

    public static String entryptPassword(String plainPassword) {
        String plain = Encodes.unescapeHtml(plainPassword);
        byte[] salt = Digests.generateSalt(8);
        byte[] hashPassword = Digests.sha1(plain.getBytes(), salt, 1024);
        return Encodes.encodeHex(salt) + Encodes.encodeHex(hashPassword);
    }

    public static boolean validatePassword(String plainPassword, String password) {
        String plain = Encodes.unescapeHtml(plainPassword);
        byte[] salt = Encodes.decodeHex(password.substring(0, 16));
        byte[] hashPassword = Digests.sha1(plain.getBytes(), salt, 1024);
        return password.equals(Encodes.encodeHex(salt) + Encodes.encodeHex(hashPassword));
    }

    public static void main(String[] args) {
        String password = "Baoan#12345678";
        System.out.println(Sha1Util.entryptPassword(password));
        String code = "8E95D87C585C581532455DACAA0539C381ACE21258584839AA0FE815602AC1D7EFC72EA830FBD874997A298ED85C49C2B5F6E420EE706071590F40969FAFB839";
        System.out.println("\u503c\u662f\u5426\u76f8\u540c" + Sha1Util.validatePassword(password, code) + "--" + code.substring(0, 16));
    }
}

