/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.util;

import com.bcxin.ars.util.StringUtil;
import java.util.Calendar;

public class IdNumUtil {
    public final int CHINA_ID_MIN_LENGTH = 15;
    public final int CHINA_ID_MAX_LENGTH = 18;

    public static String getNativeCodeByIdNum(String idNum, int type) {
        String nativeCode = idNum.substring(0, type);
        return IdNumUtil.deDuplication(nativeCode);
    }

    private static String deDuplication(String nativeCode) {
        if (nativeCode.substring(nativeCode.length() - 2, nativeCode.length()).equals("00")) {
            nativeCode = IdNumUtil.deDuplication(nativeCode.substring(0, nativeCode.length() - 2));
        }
        return nativeCode;
    }

    public static int getAgeByIdCard(String idCard) {
        int iAge = 0;
        Calendar cal = Calendar.getInstance();
        String year = idCard.substring(6, 10);
        int iCurrYear = cal.get(1);
        iAge = iCurrYear - Integer.valueOf(year);
        return iAge;
    }

    public static String getBirthByIdCard(String idCard) {
        return idCard.substring(6, 14);
    }

    public static String getBirthdayByIdCard(String idCard) {
        if (StringUtil.isEmpty(idCard)) {
            return "";
        }
        String idCardNumber = idCard.trim();
        int idCardLength = idCardNumber.length();
        String birthday = null;
        if (idCardNumber == null || "".equals(idCardNumber)) {
            return null;
        }
        if (idCardLength == 18) {
            birthday = idCardNumber.substring(6, 10) + "-" + idCardNumber.substring(10, 12) + "-" + idCardNumber.substring(12, 14);
        }
        if (idCardLength == 15) {
            birthday = "19" + idCardNumber.substring(6, 8) + "-" + idCardNumber.substring(8, 10) + "-" + idCardNumber.substring(10, 12);
        }
        return birthday;
    }

    public static Short getYearByIdCard(String idCard) {
        return Short.valueOf(idCard.substring(6, 10));
    }

    public static Short getMonthByIdCard(String idCard) {
        return Short.valueOf(idCard.substring(10, 12));
    }

    public static Short getDateByIdCard(String idCard) {
        return Short.valueOf(idCard.substring(12, 14));
    }

    public static String getGenderByIdCard(String idCard) {
        String sCardNum;
        String sGender = "\u672a\u77e5";
        String idCardNumber = idCard.trim();
        int idCardLength = idCardNumber.length();
        if (idCardLength == 18) {
            sCardNum = idCard.substring(16, 17);
            sGender = Integer.parseInt(sCardNum) % 2 != 0 ? "\u7537" : "\u5973";
        }
        if (idCardLength == 15) {
            sCardNum = idCard.substring(14, 15);
            sGender = Integer.parseInt(sCardNum) % 2 != 0 ? "\u7537" : "\u5973";
        }
        return sGender;
    }

    public static String getSexByIdCard(String idCard) {
        String sCardNum;
        String sex = "N";
        String idCardNumber = idCard.trim();
        int idCardLength = idCardNumber.length();
        if (idCardLength == 18) {
            sCardNum = idCardNumber.substring(16, 17);
            sex = Integer.parseInt(sCardNum) % 2 != 0 ? "1" : "2";
        }
        if (idCardLength == 15) {
            sCardNum = idCardNumber.substring(14, 15);
            sex = Integer.parseInt(sCardNum) % 2 != 0 ? "1" : "2";
        }
        return sex;
    }

    public static boolean isRealName(String realName) {
        return realName.matches("^[a-z.A-Z\u4e00-\u9fa5]+$");
    }

    public static void main(String[] args) {
        System.out.println(IdNumUtil.isRealName("\u533a.\u5927"));
    }
}

