package com.bcxin.ars.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import cn.jiguang.common.ClientConfig;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.utils.StringUtils;
import cn.jpush.api.JPushClient;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.Message;
import cn.jpush.api.push.model.Options;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.notification.IosAlert;
import cn.jpush.api.push.model.notification.IosNotification;
import cn.jpush.api.push.model.notification.Notification;

import java.util.HashMap;
import java.util.Map;

/**
 * 
 * <b>Function </b>极光推送（app)
 * 
 * @author LinQingLin
 * @date 2017年2月27日 下午2:12:48
 * @注意事项 </b> <b>
 */
public class JPushUtil {

	private static final String MASTER_SECRET = "377df7750d2498f4bc045677";
	private static final String APP_KEY = "c00bd896b986a4b8d9becf6f";

	private static JPushClient jpushClient = new JPushClient(MASTER_SECRET, APP_KEY, null, ClientConfig.getInstance());

	protected static final Logger LOG = LoggerFactory.getLogger(JPushUtil.class);







	/**
	 * <b>Function </b> 广播推送
	 * 
	 * @param alert 推送内容
	 * @author LinQingLin 
	 * @date 2017年2月28日 上午9:07:07
	 * @注意事项 </b>
	 * <b>
	 */
	public static void sendMessage(String alert) {
		try {
			PushPayload pushPayload = PushPayload.newBuilder()
					.setPlatform(Platform.all())// 设置接受的平台
					.setAudience(Audience.all())// Audience设置为all，说明采用广播方式推送，所有用户都可以接收到
					.setNotification(Notification.alert(alert)).build();
			PushResult result = jpushClient.sendPush(pushPayload);
			if(result.isResultOK()){
				System.out.println("推送成功");
			}else{
				System.out.println("推送失败");
			}
		} catch (APIConnectionException e) {
			LOG.error("Connection error. Should retry later. ", e);

		} catch (APIRequestException e) {
			LOG.error("Error response from JPush server. Should review and fix it. ", e);
		}
	}

	/**
	 * <b>Function </b> 带标题的推送（广播）
	 * 
	 * @param title 标题
	 * @param alert 推送内容
	 * @author LinQingLin 
	 * @date 2017年2月28日 上午9:07:07
	 * @注意事项 </b>
	 * <b>
	 */
	public static void sendMessage(String title, String alert) {
		if (StringUtils.isEmpty(title)) {
			sendMessage(title);
		} else {
			sendMessageForAndroid(title, alert);
			sendMessageForIOS(title, alert);
		}
	}

	/**
	 * <b>Function </b> 定向推送 
	 *  
	 * @param title 标题
	 * @param alert 推送内容
	 * @param alias 别名
	 * @author LinQingLin 
	 * @date 2017年2月28日 上午9:07:07
	 * @注意事项 别名用userId</b>
	 * <b>
	 */
	public static void sendMessage(String title, String alert, String alias) {
		if (StringUtils.isEmpty(alert)) {
			LOG.error("alert is empty.");
			return;
		}
		if (!StringUtils.isEmpty(alias)) {
			/*if (StringUtils.isEmpty(title)) {
				sendMessage(title);
			} else {
				sendMessage(title, alert);
			}
		} else {*/
			sendMessageForAndroid(title, alert, alias);
			sendMessageForIOS(title, alert, alias);
		}
	}
	/**
	 * <b>Function </b> 定向推送
	 * @param title 标题
	 * @param alert 推送内容
	 * @param alias 别名
	 * @param extras 附加属性
	 * @注意事项 别名用userId</b>
	 * <b>
	 */
	public static void sendMessage(String title, String alert, String alias,Map<String, String> extras) {
		if (StringUtils.isEmpty(alert)) {
			LOG.error("alert is empty.");
			return;
		}
		if (StringUtils.isEmpty(alias)) {
			/*if (StringUtils.isEmpty(title)) {
				sendMessage(title);
			} else {
				sendMessage(title, alert);
			}*/
		} else {
			sendMessageForAndroid(title, alert, alias,extras);
			sendMessageForIOS(title, alert, alias,extras);
		}

	}
	/**
	 * <b>Function </b> 
	 * 
	 * @param title 标题
	 * @param alert 推送内容
	 * @author LinQingLin 
	 * @date 2017年2月28日 上午9:07:07
	 * @注意事项 </b>
	 * <b>
	 */
	private static void sendMessageForAndroid(String title, String alert) {
		try {
			PushPayload pushPayload = PushPayload.newBuilder()
				.setPlatform(Platform.android())
				.setAudience(Audience.all())
				.setNotification(Notification.android(alert, title, null))
				.build();
			PushResult result = jpushClient.sendPush(pushPayload);
			if(result.isResultOK()){
				System.out.println("推送成功");
			}else{
				System.out.println("推送失败");
			}
		} catch (APIConnectionException e) {
			LOG.error("Connection error. Should retry later. ", e);

		} catch (APIRequestException e) {
			LOG.error("Error response from JPush server. Should review and fix it. ",e);
		}
	}


	/**
	 * <b>Function </b> 
	 * 
	 * @param title 标题
	 * @param alert 推送内容
	 * @param alias 别名
	 * @author LinQingLin 
	 * @date 2017年2月28日 上午9:07:07
	 * @注意事项 </b>
	 * <b>
	 */
	private static void sendMessageForAndroid(String title, String alert, String alias) {
		try {
//			PushResult result = jpushClient.sendAndroidNotificationWithAlias(title, alert, null, alias);
			PushPayload pushPayload = PushPayload.newBuilder()
				.setPlatform(Platform.android())
				.setAudience(Audience.alias(alias))
				.setNotification(Notification.android(alert, title, null))
				.build();
			PushResult result = jpushClient.sendPush(pushPayload);
			if(result.isResultOK()){
				System.out.println("推送成功");
			}else{
				System.out.println("推送失败");
			}
		} catch (APIConnectionException e) {
			LOG.error("Connection error. Should retry later. ", e);

		} catch (APIRequestException e) {
			LOG.error("Error response from JPush server. Should review and fix it. ",e);
		}
	}



	/**
	 * <b>Function 定向推送</b>
	 * @param title 标题
	 * @param alert 推送内容
	 * @param alias 别名
	 * @param extras 附加属性
	 * @注意事项 </b>
	 * <b>
	 */
	private static void sendMessageForAndroid(String title, String alert, String alias,Map<String, String> extras) {
		try {
		//	PushResult result = jpushClient.sendAndroidNotificationWithAlias(AndroidAlert.newBuilder().setTitleAndBody(title, null, alert).build(), null, alias);
			PushResult result = jpushClient.sendAndroidNotificationWithAlias(title, alert, extras, alias);
			/*PushPayload pushPayload = PushPayload.newBuilder()
					.setPlatform(Platform.android())
					.setAudience(Audience.registrationId(alias))
					.setNotification(Notification.android(alert, title, extras))
					.build();
			PushResult result = jpushClient.sendPush(pushPayload);*/
			if(result.isResultOK()){
				System.out.println("推送成功");
			}else{
				System.out.println("推送失败");
			}
		} catch (APIConnectionException e) {
			LOG.error("Connection error. Should retry later. ", e);

		} catch (APIRequestException e) {
			LOG.error("Error response from JPush server. Should review and fix it. ",e);
		}
	}

	/**
	 * <b>Function </b> 
	 * 
	 * @param title 标题
	 * @param alert 推送内容
	 * @author LinQingLin 
	 * @date 2017年2月28日 上午9:08:12
	 * @注意事项 </b>
	 * <b>
	 */
	private static void sendMessageForIOS(String title, String alert) {
		try {
			//TODO IOS功能待完善测试
			PushPayload pushPayload = PushPayload.newBuilder()
				.setPlatform(Platform.ios())
				.setAudience(Audience.all())
				.setNotification(Notification.newBuilder()
				.addPlatformNotification(IosNotification.newBuilder()
				.setAlert(title)
				.autoBadge()								
				.setSound("happy").build())
				.build())
				.setMessage(Message.content(alert))
				.setOptions(Options.newBuilder().setApnsProduction(true).build())
				.build();
			PushResult result = jpushClient.sendPush(pushPayload);
			if(result.isResultOK()){
				System.out.println("推送成功");
			}else{
				System.out.println("推送失败");
			}
		} catch (APIConnectionException e) {
			LOG.error("Connection error. Should retry later. ", e);

		} catch (APIRequestException e) {
			LOG.error("Error response from JPush server. Should review and fix it. ", e);
		}
	}





	/**
	 * <b>Function </b> 
	 * 
	 * @param title 标题
	 * @param alert 推送内容
	 * @param alias 别名
	 * @author LinQingLin 
	 * @date 2017年2月28日 上午9:07:07
	 * @注意事项 </b>
	 * <b>
	 */
	private static void sendMessageForIOS(String title, String alert, String alias) {
		try {
			PushResult result = jpushClient.sendIosNotificationWithAlias(IosAlert.newBuilder().setTitleAndBody(title, null, alert).build(), null, alias);
			if(result.isResultOK()){
				System.out.println("推送成功");
			}else{
				System.out.println("推送失败");
			}
		} catch (APIConnectionException e) {
			LOG.error("Connection error. Should retry later. ", e);

		} catch (APIRequestException e) {
			LOG.error("Error response from JPush server. Should review and fix it. ", e);
		}
	}

	/**
	 * <b>Function </b>
	 *
	 * @param title 标题
	 * @param alert 推送内容
	 * @param alias 别名
	 * @param extras 附加属性
	 * @注意事项 </b>
	 * <b>
	 */
	private static void sendMessageForIOS(String title, String alert, String alias,Map<String, String> extras) {
		try {

	/*		PushPayload payload = PushPayload.newBuilder()
					.setPlatform(Platform.ios())
					.setAudience(Audience.alias(alias))
					.setNotification(Notification.ios(alert, extras))
					.addPlatformNotification(IosNotification.newBuilder()
							.setAlert(title)
							.autoBadge()
							.setSound("")
							.setContentAvailable(true)
							.build())
					.setMessage(Message.content(alert))
					.setOptions(Options.newBuilder().setApnsProduction(true).build())
					.build();*/
			PushPayload payload =PushPayload.newBuilder()
					.setPlatform(Platform.ios())
					.setAudience(Audience.alias(alias))
					.setNotification(Notification.newBuilder()
							.addPlatformNotification(IosNotification.newBuilder().setAlert(title).addExtras(extras)
									.setContentAvailable(true)
									.autoBadge()
									.build())
							.build())
					.setMessage(Message.content(title))
					.setOptions(Options.newBuilder()
							.setApnsProduction(false)//true-推送生产环境 false-推送开发环境（测试使用参数）
							.setTimeToLive(90)//消息在JPush服务器的失效时间（测试使用参数）
							.build())
					.build();
			PushResult result = jpushClient.sendPush(payload);
			//PushResult result = jpushClient.sendPush(pushPayload);
			//PushResult result = jpushClient.sendIosNotificationWithAlias(IosAlert.newBuilder().setTitleAndBody(title, null, alert).build(), extras, alias);
			/*PushPayload payload = PushPayload.newBuilder()
					.setPlatform(Platform.ios())
					.setAudience(Audience.alias(alias))
					.setNotification(Notification.ios(alert, extras))
					.build();*/
			/*PushPayload pushPayload = PushPayload.newBuilder()
					.setPlatform(Platform.ios())
					.setAudience(Audience.alias(alias))
					.setNotification(Notification.android(alert, title, extras))
					.build();
			PushResult result = jpushClient.sendPush(pushPayload);*/
			if(result.isResultOK()){
				System.out.println("推送成功");
			}else{
				System.out.println("推送失败");
			}
		} catch (APIConnectionException e) {
			LOG.error("Connection error. Should retry later. ", e);

		} catch (APIRequestException e) {
			LOG.error("Error response from JPush server. Should review and fix it. ", e);
		}
	}
	public static void main(String[] args) {
		String TITLE = "百保盾111222";
		String ALERT = "你有新的任务11111221112";
//		String REGISTRATION_ID = "1507bfd3f7f54fce5c2";
		String REGISTRATION_ID = "13165ffa4e3e5dc130d541";
//		sendMessage(null, ALERT, null);
//		sendMessage(TITLE, ALERT, null);
		Map<String,String> map = new HashMap<String,String>();
		map.put("typeid","1");
		sendMessageForIOS(TITLE, ALERT, REGISTRATION_ID,map);
		
	}
	
	    
}
