/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.util;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAUtil {
    private static final Logger logger = LoggerFactory.getLogger(RSAUtil.class);
    private static final KeyPair KEY_PAIR = RSAUtil.initKey();
    private static final String KEY = "8B0045B8A02C85E3B6B979C7F1276476";

    private static KeyPair initKey() {
        try {
            BouncyCastleProvider provider = new BouncyCastleProvider();
            Security.addProvider((Provider)provider);
            SecureRandom random = new SecureRandom(KEY.getBytes());
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", (Provider)provider);
            generator.initialize(1024, random);
            return generator.generateKeyPair();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String generateBase64PublicKey() {
        RSAPublicKey key = (RSAPublicKey)KEY_PAIR.getPublic();
        return new String(Base64.encodeBase64((byte[])key.getEncoded()));
    }

    private static String generateBase64PrivateKey() {
        RSAPrivateKey key = (RSAPrivateKey)KEY_PAIR.getPrivate();
        return new String(Base64.encodeBase64((byte[])key.getEncoded()));
    }

    public static String decryptBase64(String string) {
        return new String(RSAUtil.decrypt(Base64.decodeBase64((String)string)));
    }

    private static byte[] decrypt(byte[] string) {
        try {
            BouncyCastleProvider provider = new BouncyCastleProvider();
            Security.addProvider((Provider)provider);
            Cipher cipher = Cipher.getInstance("RSA/None/PKCS1Padding", (Provider)provider);
            RSAPrivateKey pbk = (RSAPrivateKey)KEY_PAIR.getPrivate();
            cipher.init(2, pbk);
            byte[] plainText = cipher.doFinal(string);
            return plainText;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        System.out.println(RSAUtil.generateBase64PublicKey());
        System.out.println(RSAUtil.generateBase64PrivateKey());
    }
}

