/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.util;

import com.xiaoleilu.hutool.codec.Base64Encoder;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(AESUtil.class);
    public static final String ENCODING = "UTF-8";
    public static final String AES_KEY = "2E9316AAB412DFAED10EFF5E03A1EF72";
    private static final String KEY_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";
    private static final Integer SECRET_KEY_LENGTH = 128;

    public static String encode(String text) throws Exception {
        try {
            String base64Key = AES_KEY;
            byte[] key = AESUtil.parseHexStr2Byte(base64Key);
            SecretKeySpec sKeySpec = new SecretKeySpec(key, KEY_ALGORITHM);
            Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
            cipher.init(1, sKeySpec);
            byte[] bjiamihou = cipher.doFinal(text.getBytes(ENCODING));
            String result = AESUtil.parseByte2HexStr(bjiamihou);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decrypt(String content, String password, int aesLength) {
        try {
            byte[] contentByte = AESUtil.parseHexStr2Byte(content);
            KeyGenerator kgen = KeyGenerator.getInstance(KEY_ALGORITHM);
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(password.getBytes());
            kgen.init(aesLength, random);
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, KEY_ALGORITHM);
            Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
            cipher.init(2, key);
            byte[] result = cipher.doFinal(contentByte);
            return new String(result, ENCODING);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decode(String text) throws Exception {
        String base64Key = AES_KEY;
        byte[] key = AESUtil.parseHexStr2Byte(base64Key);
        SecretKeySpec sKeySpec = new SecretKeySpec(key, KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(2, sKeySpec);
        byte[] bjiemihou = cipher.doFinal(AESUtil.parseHexStr2Byte(text));
        String result = new String(bjiemihou, ENCODING);
        return result;
    }

    public static String getAESKey() throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance(KEY_ALGORITHM);
        kg.init(128);
        SecretKey sk = kg.generateKey();
        byte[] b = sk.getEncoded();
        return AESUtil.parseByte2HexStr(b);
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }

    public static String parseByte2HexStr(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] AES_CBC_Decrypt(byte[] data, byte[] key, byte[] iv) throws Exception {
        Cipher cipher = AESUtil.getCipher(2, key, iv);
        return cipher.doFinal(data);
    }

    private static Cipher getCipher(int mode, byte[] key, byte[] iv) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, KEY_ALGORITHM);
        cipher.init(mode, (Key)secretKeySpec, new IvParameterSpec(iv));
        return cipher;
    }

    public static String encrypt(String content, String password) {
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{content, password})) {
            LOGGER.error("AES encryption params is null");
            return null;
        }
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            byte[] byteContent = content.getBytes(ENCODING);
            cipher.init(1, AESUtil.getSecretKey(password));
            byte[] encryptByte = cipher.doFinal(byteContent);
            return Base64Encoder.encode((byte[])encryptByte);
        }
        catch (Exception e) {
            LOGGER.error("AES encryption operation has exception,content:{},password:{}", new Object[]{content, password, e});
            return null;
        }
    }

    public static String decrypt(String encryptContent, String password) {
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{encryptContent, password})) {
            LOGGER.error("AES decryption params is null");
            return null;
        }
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(2, AESUtil.getSecretKey(password));
            byte[] result = cipher.doFinal(Base64.decodeBase64((String)encryptContent));
            return new String(result, ENCODING);
        }
        catch (Exception e) {
            LOGGER.error("AES decryption operation has exception,content:{},password:{}", new Object[]{encryptContent, password, e});
            return null;
        }
    }

    private static SecretKeySpec getSecretKey(String password) throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(KEY_ALGORITHM);
        keyGenerator.init(SECRET_KEY_LENGTH, new SecureRandom(password.getBytes()));
        SecretKey secretKey = keyGenerator.generateKey();
        return new SecretKeySpec(secretKey.getEncoded(), KEY_ALGORITHM);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(AESUtil.decode("2CE4CFADF5F1FC1483FCDF042F02B9BE47B251A5C5F363AB8981E0397210B774"));
        System.out.println(AESUtil.encrypt("000087", "fjtctchsoft"));
        System.out.println(AESUtil.decrypt("ZnKAnP4dzE9gGWV09ET34A==", "fjtctchsoft"));
        System.out.println(AESUtil.encode("850319399854645249"));
    }
}

