package com.bcxin.ars.timer.person;

import cn.hutool.core.thread.ThreadUtil;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.PersonBaseImg;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.PersonBaseInfoService;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.GetPersonImgUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;

@Service
public class AutoPersonBaseInfoBlob extends BaseService {
    private Logger logger = LoggerFactory.getLogger(AutoPersonBaseInfoBlob.class);
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private PersonBaseInfoService personBaseInfoService;
    @Autowired
    private JobRunLogService jobRunLogService;
    @Value("${timeFlag}")
    private String timeFlag = "";

    public void run()  {
        Config config = configUtils.getConfigByKey("police");
        if (config.getValue().equals("0") && timeFlag.equals("true")) {
            JobRunLog log = new JobRunLog();
            log.setCreateTime(new Date());
            log.setActive(true);
            log.setUpdateBy("jobSystem");
            //开始时间
            long startTime = System.currentTimeMillis();

            String fzrq = DateUtil.getCurrentDate(DateUtil.FORMAT9)+"-26";
            List<PersonBaseImg> list = personBaseInfoService.createData(fzrq);

            if (list.size() > 0) {
                //使用线程池
                CountDownLatch workCount = ThreadUtil.newCountDownLatch(list.size());
                ThreadPoolExecutor threadPoolExecutor = ThreadUtil.newExecutor(15, 15);
                for (PersonBaseImg img: list) {
                    threadPoolExecutor.execute(new Runnable(){
                        @Override
                        public void run() {
                            try {
                                PersonBaseInfo info = personBaseInfoService.findByIdNum(img.getCYRSFZJHM());
                                if(info != null){
                                    img.setZP(GetPersonImgUtil.getStringImage(GetPersonImgUtil.GetImageStr(getResourcePath(info.getImgPath()))));
                                    personBaseInfoService.updateImgBlob(img);
                                }
                            } catch (Exception e) {
                                logger.error(e.getMessage(),e);
                                e.printStackTrace();
                            } finally {
                                workCount.countDown();
                            }
                        }
                    });
                }
                try {
                    //线程等待全部数据文件生成完成
                    workCount.await();
                } catch (InterruptedException e) {
                    logger.error(e.getMessage(),e);
                    Thread.currentThread().interrupt();
                }finally {
                    threadPoolExecutor.shutdown();
                }
            }

            //日志信息
            long endTime = System.currentTimeMillis();
            log.setUpdateTime(new Date());
            log.setJobName(AutoPersonBaseInfoBlob.class.getName());
            log.setRunTime(new Date());
            log.setRunTimeLength((endTime - startTime) + "ms");
            jobRunLogService.insert(log);
        }


    }
}
