package com.bcxin.ars.timer.background;

import com.bcxin.ars.dao.ThirdTrainBackgroundDao;
import com.bcxin.ars.dao.sb.PersonGradeDao;
import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.model.ThirdTrainBackground;
import com.bcxin.ars.model.sb.PersonGrade;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.beust.jcommander.internal.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 第三方培训机构背景筛查
 *
 * @author zhangyutong
 */
@Service
public class ThirdPeopleBackgroundScreeningService {

    private final Logger logger = LoggerFactory.getLogger(ThirdPeopleBackgroundScreeningService.class);

    @Resource
    private ConfigUtils configUtils;

    @Value("${timeFlag}")
    private String timeFlag;

    @Resource
    private JobRunLogService jobRunLogService;

    @Resource
    private ThirdTrainBackgroundDao thirdTrainBackgroundDao;

    @Resource
    private PersoncertificateDao personcertificateDao;

    @Resource
    private PersonGradeDao personGradeDao;


    public void run() {
        if (!Constants.BEIJING.equals(configUtils.getCurrentNative()) ||
                configUtils.isIntranet() ||
                !"true".equals(timeFlag)) {
            return;
        }
        JobRunLog jobRunLog = new JobRunLog();
        long start = System.currentTimeMillis();
        // 获取需要背景筛查的人
        List<ThirdTrainBackground> thirdTrainBackgrounds = thirdTrainBackgroundDao.listPeopleForScreening();
        List<String> gradeIdNumberList = Lists.newArrayList();
        List<String> certificateIdNumberList = Lists.newArrayList();
        // 拿到两个查询集合
        for (ThirdTrainBackground thirdTrainBackground : thirdTrainBackgrounds) {
            String businessType = thirdTrainBackground.getBusinessType();

            String idNumber = thirdTrainBackground.getIdNumber();

            if (StringUtil.isBlank(idNumber)) {
                continue;
            }

            if (Constants.BUSINESS_TYPE_GRADE.equals(businessType)) {
                // 等级证
                gradeIdNumberList.add(idNumber);

            }

            if (Constants.BUSINESS_TYPE_CERTIFICATE.equals(businessType)) {
                // 资格证
                certificateIdNumberList.add(idNumber);
            }
        }
        // 查询资格证筛查状态 生成map
        List<Personcertificate> personCertificateList = personcertificateDao.findCensorStatusByIdNumbers(certificateIdNumberList);
        Map<String, String> personCertificateMap = personCertificateList.stream().collect(HashMap::new,
                (m, v) -> m.put(v.getCardnumber(), v.getCensorStatus()), HashMap::putAll);

        logger.info("{}", personCertificateMap);
        // 查询等级证筛查状态 生成map
        List<PersonGrade> gradeCertificateList = personGradeDao.findCensorStatusByIdNumbers(gradeIdNumberList);
        Map<String, String> gradeCertificateMap = gradeCertificateList.stream().collect(HashMap::new,
                (m, v) -> m.put(v.getIdNum(), v.getCensorStatus()), HashMap::putAll);

        logger.info("{}", gradeCertificateMap);

        // 循环将筛查状态存入
        for (ThirdTrainBackground thirdTrainBackground : thirdTrainBackgrounds) {
            String businessType = thirdTrainBackground.getBusinessType();
            String idNumber = thirdTrainBackground.getIdNumber();
            if (Constants.BUSINESS_TYPE_GRADE.equals(businessType)) {
                // 等级证
                thirdTrainBackground.setScreeningResults(gradeCertificateMap.get(idNumber));
                continue;
            }

            if (Constants.BUSINESS_TYPE_CERTIFICATE.equals(businessType)) {
                // 资格证
                thirdTrainBackground.setScreeningResults(personCertificateMap.get(idNumber));
            }
        }

        // 批量保存
        thirdTrainBackgroundDao.saveBatch(thirdTrainBackgrounds);

        long end = System.currentTimeMillis();
        Date startDate = new Date(start);
        jobRunLog.setJobName(this.getClass().getName());
        jobRunLog.setActive(true);
        jobRunLog.setCreateTime(startDate);
        jobRunLog.setUpdateTime(startDate);
        jobRunLog.setUpdateBy(Constants.SYSTEM);
        jobRunLog.setRunTime(startDate);
        jobRunLog.setRunTimeLength(new Date(end - start) + "ms");
        jobRunLogService.insert(jobRunLog);

    }

}
