/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer;

import com.alibaba.fastjson.JSONArray;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.GradeCertificateToSAASDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.certificate.GradeCertificate;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.certificate.GradeCertificateService;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.SAASInterfaceUtil;
import com.bcxin.ars.util.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class GradeCertificateToSAASService {
    private Logger logger = LoggerFactory.getLogger(GradeCertificateToSAASService.class);
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private GradeCertificateService gradeCertificateService;
    @Value(value="${timeFlag}")
    private String timeFlag = "";
    @Autowired
    private SAASInterfaceUtil saasInterfaceUtil;
    @Autowired
    private JobRunLogService jobRunLogService;
    private boolean lock = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToSAAS() {
        if (!this.configUtils.isIntranet() && this.timeFlag.equals("true")) {
            if (this.lock) {
                return;
            }
            this.lock = true;
            JobRunLog log = new JobRunLog();
            log.setCreateTime(new Date());
            log.setActive(Boolean.valueOf(true));
            log.setUpdateBy("jobSystem");
            long startTime = System.currentTimeMillis();
            try {
                List certificateList = this.gradeCertificateService.findUnPushToSAAS();
                if (certificateList != null && certificateList.size() > 0) {
                    ArrayList<GradeCertificateToSAASDto> dtoList = new ArrayList<GradeCertificateToSAASDto>();
                    for (GradeCertificate gradeCertificate : certificateList) {
                        GradeCertificateToSAASDto certificateDto = new GradeCertificateToSAASDto();
                        certificateDto.setPerId(gradeCertificate.getPersonId());
                        certificateDto.setCerNo(gradeCertificate.getCertificateNo());
                        certificateDto.setPerCerLevel("0100010" + gradeCertificate.getAppraisalGrade());
                        certificateDto.setLicenceDate(gradeCertificate.getAppraisalTime() == null ? "" : DateUtil.convertDateToString((Date)gradeCertificate.getAppraisalTime(), (String)"yyyy-MM-dd"));
                        certificateDto.setTrainOrganName(gradeCertificate.getTrainOrgName());
                        dtoList.add(certificateDto);
                    }
                    HashMap<String, String> paramMap = new HashMap<String, String>();
                    paramMap.put("bayDJZListStr", JSONArray.toJSONString(dtoList));
                    AjaxResult result = this.saasInterfaceUtil.callInterface("/system/per-cer-baseinfo/complete-baydjz-approve", paramMap);
                    if (!result.isSuccessful()) {
                        throw new ArsException("\u4fdd\u5b89\u5458\u7b49\u7ea7\u8bc1\u63a8\u9001saas\u5931\u8d25" + result.getMsg());
                    }
                    Map<Object, Object> failMap = new HashMap();
                    if (result.getData() != null) {
                        List failList = JSONArray.parseArray((String)JSONArray.toJSONString((Object)result.getData()), GradeCertificateToSAASDto.class);
                        failMap = failList.stream().collect(Collectors.toMap(GradeCertificateToSAASDto::getPerId, Function.identity()));
                    }
                    ArrayList<GradeCertificate> successList = new ArrayList<GradeCertificate>();
                    for (GradeCertificate gradeCertificate : certificateList) {
                        if (failMap.get(gradeCertificate.getPersonId()) != null) continue;
                        successList.add(gradeCertificate);
                    }
                    if (successList.size() > 0) {
                        this.gradeCertificateService.batchUpdatePushState(successList);
                        this.gradeCertificateService.batchUpdatePersonGradeCertificate(successList);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                log.setExceptionMsg(e.getMessage());
            }
            finally {
                this.lock = false;
            }
            long endTime = System.currentTimeMillis();
            log.setUpdateTime(new Date());
            log.setJobName(GradeCertificateToSAASService.class.getName());
            log.setRunTime(new Date());
            log.setRunTimeLength(endTime - startTime + "ms");
            this.jobRunLogService.insert(log);
        }
    }
}

