/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.log.LogMessageDao;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.log.LogMessage;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.HttpClientUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BktUserSynchronizationService {
    private Logger logger = LoggerFactory.getLogger(BktUserSynchronizationService.class);
    @Autowired
    private ConfigDao configDao;
    @Autowired
    private LogMessageDao logMessageDao;
    @Autowired
    private UserService userService;
    public static String IS_SUCCESS = "0";
    public static String IS_FAIL = "-1";

    public void run() {
        Config config = this.configDao.findByKey("police");
        String message = "";
        if (config != null && config.getValue() != null && !"1".equals(config.getValue())) {
            try {
                Config lastDateConfig = this.configDao.findByKey("bkt_lastTime");
                Boolean isflag = true;
                if (lastDateConfig != null) {
                    String lastDate = lastDateConfig.getValue();
                    String now = DateUtil.getCurrentDate((String)"yyyy-MM-dd");
                    List listMap = this.userService.searchAllCompanyUser(lastDate, now);
                    message = "\u66f4\u65b0\u7684listSize:" + listMap.size();
                    if (listMap.size() > 0) {
                        isflag = false;
                        HashMap<String, String> dataMap = new HashMap<String, String>(listMap.size());
                        dataMap.put("data", JSON.toJSONString((Object)listMap));
                        Config configURL = this.configDao.findByKey("bkt_data_url");
                        if (configURL != null && configURL.getValue() != null) {
                            String url = configURL.getValue() + "/train/bbd/learn/batch-regist";
                            String btkRtn = HttpClientUtils.doPost((String)url, dataMap, (String)"utf-8");
                            if (btkRtn != null) {
                                message = "\u8fd4\u56debtkRtn:" + btkRtn;
                                JSONObject jsonObject = JSONObject.parseObject((String)btkRtn);
                                String retType = jsonObject.get((Object)"retType").toString();
                                String data = jsonObject.get((Object)"data").toString();
                                if (!StringUtils.isEmpty((Object)retType) && IS_SUCCESS.equals(retType)) {
                                    isflag = true;
                                    this.logger.info("\u767e\u8bfe\u5802\u7528\u6237\u540c\u6b65\u6210\u529f");
                                } else {
                                    this.logger.info("\u767e\u8bfe\u5802\u7528\u6237\u540c\u6b65\u5931\u8d25");
                                }
                                if (!StringUtils.isEmpty((Object)data)) {
                                    this.saveLogMessage(message);
                                }
                            } else {
                                message = "\u8bbf\u95ee\u767e\u8bfe\u5802\u8fd4\u56de\u4e3a\u7a7a:" + btkRtn;
                                this.saveLogMessage(message);
                            }
                        }
                    }
                    if (isflag.booleanValue()) {
                        Config updateConfig = new Config();
                        updateConfig.setKey("bkt_lastTime");
                        updateConfig.setValue(DateUtil.convertDateToString((Date)new Date(), (String)"yyyy-MM-dd"));
                        this.configDao.update(updateConfig);
                        this.saveLogMessage(message);
                    }
                }
            }
            catch (Exception e) {
                this.saveLogMessage("\u629b\u51fa\u9519\u8bef\uff1a" + message);
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private LogMessage saveLogMessage(String message) {
        LogMessage logMessage = new LogMessage();
        logMessage.setLogger_title("\u767e\u8bfe\u5802\u8d26\u53f7\u540c\u6b65");
        logMessage.setCreateTime(new Date());
        logMessage.setLogger_context(message);
        this.logMessageDao.save(logMessage);
        return logMessage;
    }
}

