package com.bcxin.ars.service.util.excel;

import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.CellRangeAddress;

import java.io.File;
import java.io.FileOutputStream;
import java.sql.*;

/*
 * ExcelUtil工具类实现功能:
 * 导出时传入list<T>,即可实现导出为一个excel,其中每个对象Ｔ为Excel中的一条记录.
 * 导入时读取excel,得到的结果是一个list<T>.T是自己定义的对象.
 * 需要导出的实体对象只需简单配置注解就能实现灵活导出,通过注解您可以方便实现下面功能:
 * 1.实体属性配置了注解就能导出到excel中,每个属性都对应一列.
 * 2.列名称可以通过注解配置.
 * 3.导出到哪一列可以通过注解配置.
 * 4.鼠标移动到该列时提示信息可以通过注解配置.
 * 5.用注解设置只能下拉选择不能随意填写功能.
 * 6.用注解设置是否只导出标题而不导出内容,这在导出内容作为模板以供用户填写时比较实用.
 */
public class DataBaseExcelUtil {

    public static void main(String[] args) {
        try{
            getInfo();
        }catch (Exception e){
            e.printStackTrace();
        }
    }


    /**
     * 生成数据库文档
     * @throws SQLException
     */
    private static void  getInfo() throws SQLException {
        Connection connection = null;
        //String connectionURL = "jdbc:mysql://183.250.166.207:3345/information_schema";
        String connectionURL = "jdbc:mysql://localhost:3306/information_schema";
        ResultSet rs = null;
        PreparedStatement psmnt = null;
        try {
            String sql = "select TABLE_NAME,ORDINAL_POSITION,Column_Name,DATA_TYPE,IFNULL(NUMERIC_PRECISION,''),IFNULL(CHARACTER_MAXIMUM_LENGTH,''),IFNULL(COLUMN_COMMENT,''),IS_NULLABLE " +
                    "from columns t2 WHERE table_schema = 'bd_ars' " +
                    "AND t2.table_name NOT LIKE 'act%' " +
                    "AND t2.table_name NOT LIKE 'job%' " +
                    "AND t2.table_name NOT LIKE 'approve%' " +
                    "AND t2.table_name NOT LIKE '%temp' " +
                    "AND t2.table_name NOT LIKE '%copy%' " +
                    "AND t2.table_name NOT LIKE 'cy%' " +
                    "AND t2.table_name NOT LIKE '%20%' " +
                    "AND t2.table_name NOT LIKE '%officebulletin%' " +
                    "AND t2.table_name NOT LIKE '%help_topic%' " +
                    "ORDER BY table_name ASC";
            Class.forName("com.mysql.jdbc.Driver").newInstance();
            connection = DriverManager.getConnection(connectionURL, "root", "gogofis");
            psmnt = connection.prepareStatement(sql);
            rs=psmnt.executeQuery();

            Integer rowIndex = 0;

            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet1 = wb.createSheet("填写范例说明");
            CellStyle stringStyle = getStringStyle(wb);

            String tableName ="";
            while(rs.next()){
                if(!tableName.equals(rs.getString(1))){
                    rowIndex = setTableInfo(wb,sheet1,rowIndex,rs.getString(1));
                }
                tableName = rs.getString(1);

                HSSFRow rowData1 = sheet1.createRow(rowIndex);
                HSSFCell cellData0 = rowData1.createCell(0); //获取第一行的每个单元格
                cellData0.setCellStyle(stringStyle);
                cellData0.setCellValue(rs.getString(2));
                HSSFCell cellData1 = rowData1.createCell(1); //获取第一行的每个单元格
                cellData1.setCellStyle(stringStyle);
                cellData1.setCellValue(rs.getString(3));
                HSSFCell cellData2 = rowData1.createCell(2); //获取第一行的每个单元格
                cellData2.setCellStyle(stringStyle);
                String dataType = rs.getString(4);
                if(dataType.equals("bit")
                        || dataType.equals("datetime")
                        || dataType.equals("timestamp")
                        || dataType.equals("date")
                        || dataType.equals("blob")
                        || dataType.equals("longblob")
                        || dataType.equals("longtext")){

                }else{
                    dataType = dataType + "/"+rs.getString(5)+rs.getString(6);
                }
                cellData2.setCellValue(dataType);
                HSSFCell cellData3 = rowData1.createCell(3); //获取第一行的每个单元格
                cellData3.setCellStyle(stringStyle);
                cellData3.setCellValue(rs.getString(7));
                HSSFCell cellData4 = rowData1.createCell(4); //获取第一行的每个单元格
                cellData4.setCellStyle(stringStyle);
                cellData4.setCellValue(rs.getString(8));
                HSSFCell cellData5 = rowData1.createCell(5); //获取第一行的每个单元格
                cellData5.setCellStyle(stringStyle);
                cellData5.setCellValue("");
                HSSFCell cellData6 = rowData1.createCell(6); //获取第一行的每个单元格
                cellData6.setCellStyle(stringStyle);
                cellData6.setCellValue("");
                HSSFCell cellData7 = rowData1.createCell(7); //获取第一行的每个单元格
                cellData7.setCellStyle(stringStyle);
                cellData7.setCellValue("");
                rowIndex++;
            }
            File file = new File("f:/aaa1.xls");
            //输出模板
            FileOutputStream fileOut = new FileOutputStream(file);
            wb.write(fileOut);
            fileOut.close();
            wb.close();
        } catch (Exception ex) {
            System.out.println("Found some error : " + ex);
        } finally {
            // close all the connections.
            System.out.println("Found success!");
            connection.close();
            psmnt.close();
        }
    }

    private static Integer setTableInfo(HSSFWorkbook wb,HSSFSheet sheet1,Integer rowIndex,String tableName){
        CellStyle style1 = getTableTitleStyle(wb);
        CellStyle style2 = getTableHeadStyle(wb);
        CellStyle style3 = getStringStyle(wb);

        HSSFRow row1 = sheet1.createRow(rowIndex);
        CellRangeAddress cra1 =new CellRangeAddress(rowIndex, rowIndex, 0, 7);
        sheet1.addMergedRegion(cra1);
        for(int i=0;i<=7;i++){
            HSSFCell cellStyle = row1.createCell(i); //获取第一行的每个单元格
            cellStyle.setCellStyle(style1);
        }
        HSSFCell cell = row1.createCell(0); //获取第一行的每个单元格
        cell.setCellValue("表信息");
        cell.setCellStyle(style1);
        rowIndex++;

        HSSFRow row2 = sheet1.createRow(rowIndex);
        CellRangeAddress cra2 =new CellRangeAddress(rowIndex, rowIndex, 0, 1);
        sheet1.addMergedRegion(cra2);
        for(int i=0;i<=1;i++){
            HSSFCell cellStyle = row2.createCell(i); //获取第一行的每个单元格
            cellStyle.setCellStyle(style2);
        }
        HSSFCell cell0 = row2.createCell(0); //获取第一行的每个单元格
        cell0.setCellStyle(style2);
        cell0.setCellValue("物理表名");

        CellRangeAddress cra3 =new CellRangeAddress(rowIndex, rowIndex, 2, 5);
        sheet1.addMergedRegion(cra3);
        for(int i=2;i<=5;i++){
            HSSFCell cellStyle = row2.createCell(i); //获取第一行的每个单元格
            cellStyle.setCellStyle(style2);
        }
        HSSFCell cell1 = row2.createCell(2); //获取第一行的每个单元格
        cell1.setCellStyle(style3);
        cell1.setCellValue(tableName);

        HSSFCell cell2 = row2.createCell(6); //获取第一行的每个单元格
        cell2.setCellStyle(style2);
        cell2.setCellValue("字典表");
        HSSFCell cell3 = row2.createCell(7); //获取第一行的每个单元格
        cell3.setCellStyle(style3);
        cell3.setCellValue("");

        rowIndex++;

        HSSFRow row12 = sheet1.createRow(rowIndex);
        CellRangeAddress cra12 =new CellRangeAddress(rowIndex, rowIndex, 0, 1);
        sheet1.addMergedRegion(cra12);
        for(int i=0;i<=1;i++){
            HSSFCell cellStyle = row12.createCell(i); //获取第一行的每个单元格
            cellStyle.setCellStyle(style2);
        }
        HSSFCell cell10 = row12.createCell(0); //获取第一行的每个单元格
        cell10.setCellStyle(style2);
        cell10.setCellValue("表中文说明");

        CellRangeAddress cra13 =new CellRangeAddress(rowIndex, rowIndex, 2, 5);
        sheet1.addMergedRegion(cra13);
        for(int i=2;i<=5;i++){
            HSSFCell cellStyle = row12.createCell(i); //获取第一行的每个单元格
            cellStyle.setCellStyle(style3);
        }
        HSSFCell cell11 = row12.createCell(2); //获取第一行的每个单元格
        cell11.setCellStyle(style3);
        cell11.setCellValue("");
        HSSFCell cell12 = row12.createCell(6); //获取第一行的每个单元格
        cell12.setCellStyle(style2);
        cell12.setCellValue("开放类型");

        HSSFCell cell13 = row12.createCell(7); //获取第一行的每个单元格
        cell13.setCellStyle(style3);
        cell13.setCellValue("");

        rowIndex++;

        HSSFRow rowHead1 = sheet1.createRow(rowIndex);
        HSSFCell cellHead0 = rowHead1.createCell(0); //获取第一行的每个单元格
        cellHead0.setCellStyle(style2);
        cellHead0.setCellValue("序号");
        HSSFCell cellHead1 = rowHead1.createCell(1); //获取第一行的每个单元格
        cellHead1.setCellStyle(style2);
        cellHead1.setCellValue("字段名");
        HSSFCell cellHead2 = rowHead1.createCell(2); //获取第一行的每个单元格
        cellHead2.setCellStyle(style2);
        cellHead2.setCellValue("字段类型/长度");
        HSSFCell cellHead3 = rowHead1.createCell(3); //获取第一行的每个单元格
        cellHead3.setCellStyle(style2);
        cellHead3.setCellValue("注释");
        HSSFCell cellHead4 = rowHead1.createCell(4); //获取第一行的每个单元格
        cellHead4.setCellStyle(style2);
        cellHead4.setCellValue("允许NULL");
        HSSFCell cellHead5 = rowHead1.createCell(5); //获取第一行的每个单元格
        cellHead5.setCellStyle(style2);
        cellHead5.setCellValue("是否引用字典");
        HSSFCell cellHead6 = rowHead1.createCell(6); //获取第一行的每个单元格
        cellHead6.setCellStyle(style2);
        cellHead6.setCellValue("字典代码");
        HSSFCell cellHead7 = rowHead1.createCell(7); //获取第一行的每个单元格
        cellHead7.setCellStyle(style2);
        cellHead7.setCellValue("备注");
        return ++rowIndex;
    }

    private static CellStyle getTableTitleStyle(HSSFWorkbook wb) {
        CellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setFontName("微软雅黑");
        font.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);//粗体显示
        font.setFontHeightInPoints((short)12);
        style.setFont(font);
        style.setAlignment(HSSFCellStyle.ALIGN_CENTER);
        style.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
        style.setFillForegroundColor(HSSFColor.LIGHT_ORANGE.index);
        style.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);

        style.setWrapText(true);
        style.setBorderBottom(HSSFCellStyle.BORDER_THIN); //下边框
        style.setBorderLeft(HSSFCellStyle.BORDER_THIN);//左边框
        style.setBorderTop(HSSFCellStyle.BORDER_THIN);//上边框
        style.setBorderRight(HSSFCellStyle.BORDER_THIN);//右边框
        return style;
    }
    private static CellStyle getTableHeadStyle(HSSFWorkbook wb) {
        CellStyle style = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setFontName("微软雅黑");
        //font.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);//粗体显示
        font.setFontHeightInPoints((short)12);
        style.setFont(font);
        style.setAlignment(HSSFCellStyle.ALIGN_CENTER);
        style.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
        style.setFillForegroundColor(HSSFColor.LIGHT_ORANGE.index);
        style.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
        style.setWrapText(true);
        style.setBorderBottom(HSSFCellStyle.BORDER_THIN); //下边框
        style.setBorderLeft(HSSFCellStyle.BORDER_THIN);//左边框
        style.setBorderTop(HSSFCellStyle.BORDER_THIN);//上边框
        style.setBorderRight(HSSFCellStyle.BORDER_THIN);//右边框
        return style;
    }

    private static CellStyle getStringStyle(HSSFWorkbook wb) {
        CellStyle style = wb.createCellStyle();
        HSSFDataFormat format = wb.createDataFormat();
        style.setDataFormat(format.getFormat("@"));
        style.setBorderBottom(HSSFCellStyle.BORDER_THIN); //下边框
        style.setBorderLeft(HSSFCellStyle.BORDER_THIN);//左边框
        style.setBorderTop(HSSFCellStyle.BORDER_THIN);//上边框
        style.setBorderRight(HSSFCellStyle.BORDER_THIN);//右边框
        return style;
    }
}