package com.bcxin.ars.service.util;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.model.sys.Sysdict;
import com.bcxin.ars.util.RSAUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.spring.util.SpringUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author linqinglin
 * @date 2019/01/24 0024 13:09
 */
public class SysBaseUtil {

    private static SysDictUtils sysDictUtil = SpringUtils.getBean(SysDictUtils.class);

    public static List<Sysdict> getDictTypeList(String dictType){
        return sysDictUtil.getDictType(dictType);
    }

    public static String getDictTypeStrMap(String dictType){
        List<Sysdict> list = sysDictUtil.getDictType(dictType);
        Map<String,String> result = new HashMap();
        list.forEach((sysdict)->{
            result.put(sysdict.getCodeValue(),sysdict.getLabel());
        });

        return JSON.toJSONString(result);
    }

    public static Map getDictTypeMap(String dictType){
        List<Sysdict> list = sysDictUtil.getDictType(dictType);
        Map<String,String> result = new HashMap();
        list.forEach((sysdict)->{
            result.put(sysdict.getCodeValue(),sysdict.getLabel());
        });

        return result;
    }

    public static String getDictLabel(String dictType,String value){
        Map<String,String> result = getDictTypeMap(dictType);
        return result.get(value);
    }

    public static String getMultiDictLabel(String dictType,String value){
        if(StringUtil.isEmpty(value)){
            return "";
        }
        Map<String,String> result = getDictTypeMap(dictType);
        String ret = "";
        for (String codeValue : value.split(",")) {
            ret = ret + result.get(codeValue)+",";
        }
        return ret.substring(0, ret.length() - 1);
    }
    public static String getRSAPublicKey(){
        String s = RSAUtil.generateBase64PublicKey();
        return s;
    }
}
