package com.bcxin.ars.service.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.bcxin.ars.dao.sys.SysareaDAO;
import com.bcxin.ars.dto.TreeView;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.redis.RedisUtil;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * 城市地区工具类
 */
@Service
@Transactional
public class SysAreaUtil {

    private Logger log = LoggerFactory.getLogger(SysAreaUtil.class);

    public final static String REDIS_PREFIX_KEY = "ARS:";

    @Autowired
    private SysareaDAO regionDao ;

    @Autowired
    private RedisUtil redisUtil;

    /**
     * 所有区域的map
     * @return
     */
    public Map<String,TreeView> regionMap(){
        String value = "";
        try {
            value = redisUtil.get( REDIS_PREFIX_KEY + "systemRegion");
        } catch (RuntimeException ex){
            log.error("redis缓存获取异常[{}]","systemRegion");
        }
        if (StringUtil.isNotEmpty(value)) {
            return JSON.parseObject(value, new TypeReference<HashMap<String,TreeView>>(){});
        }
        log.debug("从数据库中重新获取系统配置[{}]","systemRegion");
        List<TreeView> rList = regionDao.selectAll();
        Map<String,TreeView> regionMap = Maps.newLinkedHashMap();
        for( TreeView region:rList){
            regionMap.put(region.getNodeid(),region);
        }
        String configJson= JSON.toJSONString(regionMap);
        log.debug("设置进入redis缓存[{}]","systemRegion");
        redisUtil.set(REDIS_PREFIX_KEY + "systemRegion", configJson);

        return regionMap;
    }

    /**
     * 所有区域的map
     * @return
     */
    public Map<String,TreeView> regionCodeMap(){
        String value = "";
        try {
            value = redisUtil.get( REDIS_PREFIX_KEY + "systemRegionCode");
        } catch (RuntimeException ex){
            log.error("redis缓存获取异常[{}]","systemRegionCode");
        }
        if (StringUtil.isNotEmpty(value)) {
            return JSON.parseObject(value, new TypeReference<HashMap<String,TreeView>>(){});
        }
        log.debug("从数据库中重新获取系统配置[{}]","systemRegionCode");
        List<TreeView> rList = regionDao.selectAll();
        Map<String,TreeView> regionMap = Maps.newLinkedHashMap();
        for( TreeView region:rList){
            regionMap.put(region.getCode(),region);
        }
        String configJson= JSON.toJSONString(regionMap);
        log.debug("设置进入redis缓存[{}]","systemRegionCode");
        redisUtil.set(REDIS_PREFIX_KEY + "systemRegionCode", configJson);

        return regionMap;
    }


    /**
     * 省份
     * @return
     */
    public Collection<TreeView> provinceMap(){
        String value = "";
        try {
            value = redisUtil.get(REDIS_PREFIX_KEY + "systemRegion" + ":" + "province");
        } catch (RuntimeException ex){
            log.error("redis缓存获取异常[{}]","systemRegion_province");
        }
        if (StringUtil.isNotEmpty(value)) {
            return JSON.parseObject(value, new TypeReference<Collection<TreeView>>(){});
        }
        log.debug("从数据库中重新获取系统配置[{}]","systemRegion_province");
        Collection<TreeView> regions = Lists.newArrayList();
        Map<String,TreeView> regionMap = regionMap();
        Set keySet = regionMap.keySet();
        for(Iterator it = keySet.iterator();it.hasNext();){
            Object key = it.next();
            TreeView region = regionMap.get(key);
            if ( StringUtil.isEmpty(region.getParentid()) ) {
                regions.add(region);
            }
        }
        String configJson= JSON.toJSONString(regions);
        log.debug("设置进入redis缓存[{}]","systemRegion_province");
        redisUtil.set(REDIS_PREFIX_KEY + "systemRegion" + ":" + "province", configJson);
        return regions;
    }

    /**
     * 市的map
     * @return
     */
    public Map<String,Collection<TreeView>> cityMap(){
        String value = "";
        try {
            value = redisUtil.get(REDIS_PREFIX_KEY + "systemRegion" + ":" + "city" );
        } catch (RuntimeException ex){
            log.error("redis缓存获取异常[{}]","systemRegion_city");
        }
        if (StringUtil.isNotEmpty(value)) {
            return JSON.parseObject(value, new TypeReference<Map<String,Collection<TreeView>>>(){});
        }
        log.debug("从数据库中重新获取系统配置[{}]","systemRegion_city");
        Multimap<String, TreeView> cMap = ArrayListMultimap.create();
        Map<String,TreeView> regionMap = regionMap();
        Set keySet = regionMap.keySet();
        for(Iterator it = keySet.iterator();it.hasNext();){
            Object key = it.next();
            TreeView region = regionMap.get(key);
            if ( Objects.equals(region.getLevel(),"2") ) {
                cMap.put(region.getParentid(),region);
            }
        }
        String configJson= JSON.toJSONString(cMap.asMap());
        log.debug("设置进入redis缓存[{}]","systemRegion_city");
        redisUtil.set(REDIS_PREFIX_KEY + "systemRegion" + ":" + "city", configJson);
        return cMap.asMap();
    }


    /**
     * 市的map
     * @return
     */
    public Collection<TreeView> cityMap(String parentId){
        String value = "";
        try {
            value = redisUtil.get(REDIS_PREFIX_KEY + "systemRegion" + ":" + "city" + ":" + parentId);
        } catch (RuntimeException ex){
            log.error("redis缓存获取异常[{}]","systemRegion_city");
        }
        if (StringUtil.isNotEmpty(value)) {
            return JSON.parseObject(value, new TypeReference<Collection<TreeView>>(){});
        }
        log.debug("从数据库中重新获取系统配置[{}]","systemRegion_city");
        List<TreeView> rList = regionDao.selectByParentId(Long.parseLong(parentId));
        String configJson= JSON.toJSONString(rList);
        log.debug("设置进入redis缓存[{}]","systemRegion_city");
        redisUtil.set(REDIS_PREFIX_KEY + "systemRegion" + ":" + "city" + ":" + parentId, configJson);
        return rList;
    }


    public Map<String,Collection<TreeView>> areaMap(){
        String value = "";
        try {
            value = redisUtil.get(REDIS_PREFIX_KEY + "systemRegion" + ":" + "area" );
        } catch (RuntimeException ex){
            log.error("redis缓存获取异常[{}]","systemRegion_area");
        }
        if (StringUtil.isNotEmpty(value)) {
            return JSON.parseObject(value, new TypeReference<Map<String,Collection<TreeView>>>(){});
        }
        log.debug("从数据库中重新获取系统配置[{}]","systemRegion_area");
        Multimap<String, TreeView> cMap = ArrayListMultimap.create();
        Map<String,TreeView> regionMap = regionMap();
        Set keySet = regionMap.keySet();
        for (Iterator it = keySet.iterator();it.hasNext();){
            Object key = it.next();
            TreeView region = regionMap.get(key);
            if ( Objects.equals("3",region.getLevel())) {
                cMap.put(region.getParentid(),region);
            }
        }
        String configJson= JSON.toJSONString(cMap.asMap());
        log.debug("设置进入redis缓存[{}]","systemRegion_area");
        redisUtil.set(REDIS_PREFIX_KEY + "systemRegion" + ":" + "area", configJson);
        return cMap.asMap();
    }


    /**
     * 区的map
     * @return
     */
    public Collection<TreeView> areaMap(String parentId){
        String value = "";
        try {
            value = redisUtil.get(REDIS_PREFIX_KEY + "systemRegion" + ":" + "area" + ":" + parentId);
        } catch (RuntimeException ex){
            log.error("redis缓存获取异常[{}]","systemRegion_area");
        }
        if (StringUtil.isNotEmpty(value)) {
            return JSON.parseObject(value, new TypeReference<Collection<TreeView>>(){});
        }
        log.debug("从数据库中重新获取系统配置[{}]","systemRegion_area");
        List<TreeView> rList = regionDao.selectByParentId(Long.parseLong(parentId));
        String configJson = JSON.toJSONString(rList);
        log.debug("设置进入redis缓存[{}]","systemRegion_area");
        redisUtil.set(REDIS_PREFIX_KEY + "systemRegion" + ":" + "area" + ":" + parentId, configJson);
        return rList;
    }

    /**
     * 通过ID返回地区
     * @param id
     * @return
     */
    public TreeView getRegionById(String id){
        return regionMap().get(id);
    }

    /**
     * 通过CODE返回地区
     * @return
     */
    public TreeView getRegionByCode(String code){
        return regionCodeMap().get(code);
    }

}
