package com.bcxin.ars.service.util;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.redis.RedisUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * 处理签配置工具类
 */
@Service
@Transactional
public class ConfigSignUtils {

    private Logger log = LoggerFactory.getLogger(ConfigSignUtils.class);

    public final static String REDIS_PREFIX_KEY = "ARS:";

    @Autowired
    private ConfigDao configDao;

    @Autowired
    private RedisUtil redisUtil;

    /**
     * @return void
     * @Decription:获取处理签配置表全部值
     * @author：zhongjianhui
     * @method getAllConfigSign
     * @date：2018/12/17 14:09
     * @params： * @param
     */
    public void getAllConfigSign() {

        log.debug("从数据库中重新获取系统配置[{}]", "configSign");
        List<Map> configSignList = configDao.findAllConfigSign();
        if (configSignList.size() > 0) {
            for (Map map : configSignList) {
                String type = map.get("type").toString();
                String provinceType = map.get("provinceType").toString();
                log.debug("设置进入redis缓存[{}]", "configSign" + "_" + type + "_" + provinceType);
                String configJson = JSON.toJSONString(map);
                redisUtil.set(REDIS_PREFIX_KEY + "configSign" + "_" + type + "_" + provinceType, configJson);
            }
        } else {
            log.error("redis缓存获取异常[{}]", "configSign:处理签配置表为空");
        }

    }

    /**
     * @param type         业务类型
     * @param provinceType 省类型
     * @return java.lang.String
     * @Decription:获取处理签配置表缓存中的值
     * @author：zhongjianhui
     * @method getConfigSign
     * @date：2018/12/17 14:09
     * @params：
     */
    public String getConfigSign(String type, String provinceType) {
        String value = "";
        try {
            value = redisUtil.get(REDIS_PREFIX_KEY + "configSign" + "_" + type + "_" + provinceType);
        } catch (RuntimeException ex) {
            log.error("redis缓存获取异常[{}]", "configSign");
        }
        if (StringUtil.isNotEmpty(value)) {
            return value;
        }
        log.debug("从数据库中重新获取系统配置[{}]", "configSign");
        this.getAllConfigSign();
        value = redisUtil.get(REDIS_PREFIX_KEY + "configSign" + "_" + type + "_" + provinceType);
        if (StringUtil.isNotEmpty(value)) {
            return value;
        } else {
            log.error("取出redis缓存错误:configSign");
            return null;
        }
    }


}
