package com.bcxin.ars.service.util;


import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.BjMatterInfoDao;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.approve.ApproveTempDao;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.AppraiseDto;
import com.bcxin.ars.dto.AppraiseResultDto;
import com.bcxin.ars.dto.ShareApprInfo;
import com.bcxin.ars.dto.approve.ApproveTempOrgDto;
import com.bcxin.ars.enums.MatterType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.approve.ApproveTemp;
import com.bcxin.ars.model.sb.Legalchange;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.model.sb.Sponsorlicense;
import com.bcxin.ars.model.sb.Yearreportdata;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.approve.ApproveAreaProcessService;
import com.bcxin.ars.service.sb.*;
import com.bcxin.ars.util.*;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.util.approval.BusinessType;
import com.bcxin.ars.util.redis.RedisUtil;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import sviolet.smcrypto.SmCryptoUtil;

import javax.annotation.Resource;
import java.net.URLEncoder;
import java.util.*;

/**
 * Created by SUBH on 2017/4/30.
 */
@Service
public class ApprovalUtil {

    private Logger logger = LoggerFactory.getLogger(ApprovalUtil.class);

    /***
     * 审批
     */
    @Autowired
    private ApprovalDAO approvalDAO;
    /***
     * 审批配置
     */
    /*@Autowired
    private ApprovalConfigDAO approvalConfigDAO;*/
    /***
     * 保安服务公司
     */
    @Autowired
    private SponsorlicenseService sponsorlicenseService;
    /***
     * 保安服务子公司
     */
    @Autowired
    private SubsidiaryService subsidiaryService;
    /***
     * 保安员证
     */
    @Autowired
    private PersoncertificateService personcertificateService;
    /***
     *跨区域经营保安公司
     */
    @Autowired
    private CrosscompanyService crosscompanyService;
    /**
     * 培训服务
     */
    @Autowired
    private TraincompanyapplyService traincompanyapplyService;
    /***
     * 自行招用保安员单位
     */
    @Autowired
    private ConfesscompanyService confesscompanyService;
    /***
     * 自招备案撤销
     */
    @Autowired
    private ConfesscompanyundoService confesscompanyundoService;
    
    @Autowired
    private LegalchangeService legalchangeService;
    
//    @Autowired
//    private YearreportService yearreportService;
    
    @Autowired
    private YearreportdataService yearreportdataService;
    @Autowired
    
    private SecurityPersonService securityPersonService;
    
    @Autowired
    private SecurityCompanyService securityCompanyService;

    @Autowired
    private IdGeneratorUtil idGeneratorUtil;
    /**
     * 枪支机构
     */
    @Autowired
    private ArmtrainorgService armtrainorgService;
    @Autowired
    private ArsUtil arsUtil;
    @Resource
    private RuntimeService runtimeService;
    @Resource
    private TaskService taskService;

    @Resource
    private HistoryService historyService;

    @Autowired
    private ApproveAreaProcessService approveAreaProcessService;

    /**
     * 配置
     */
    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private UserDao userDao;

    @Autowired
    private ApproveTempDao approveTempDao;

    @Autowired
    private PoliceDao policeDao;

    @Autowired
    private BusinessService businessService;

    @Autowired
    private BjMatterInfoDao bjMatterInfoDao;

    @Autowired
    private IdWorker idWorker;

    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private AppraiseInterfaceUtil appraiseInterfaceUtil;

    public void updateContent(Approval approval,String name){
        String context = null;
        switch (approval.getBusinesstype()){
            case BusinessType.BAFWGS:
                context = "【" + name + "】保安服务公司申报审批";
                break;
            case BusinessType.BAGSZGS:
                context = "【" + name + "】保安服务公司子公司申报审批";
                break;
            case BusinessType.BAYZ:
                context = "【" + name + "】保安员证报名审批";
                break;
            case BusinessType.KQYBAGS:
                context = "【" + name + "】跨区域经营保安公司申报审批";
                break;
            case BusinessType.PXDW:
                context = "【" + name + "】培训单位申报审批";
                break;
            case BusinessType.ZXZY:
                context = "【" + name + "】自行招用保安员单位申报审批";
                break;
            case BusinessType.FRBG:
                String title = "】保安服务（培训）许可证项目变更审批";
                if(Constants.GUANGXI.equals(configUtils.getCurrentNative())){
                    title = "】保安服务许可证项目变更审批";
                }
                context = "【" + name + title;
                break;
            case BusinessType.NDBG:
                context = "【" + name + "】年度报告审批";
                break;
            case BusinessType.QZPX:
                context = "【" + name + "】武装守护押运服务的保安员的枪支培训机构审批";
                break;
            case BusinessType.ZZBACX:
                context = "【" + name + "】自行招用保安员单位撤销备案审批";
                break;
            case BusinessType.PXDWXMBG:
                context = "【" + name + "】保安培训备案项目变更审批";
                break;
        }
        approval.setContext(context);
        approval.setUpdateTime(new Date());
        approvalDAO.update(approval);
    }


    /***
     * 保存审核信息 新审批业务
     * @param businesstype 业务类型
     * @param businessid 业务ID
     */
    public void saveApprovalForIntegrate(String businesstype,Long businessid,String processKey,User user){
        Long userId  =  0L;
        Long policeId = 0L;
        //公司或自然人
        userId = user.getId();
        Approval approval = null ;
        if (!businesstype.equals(BusinessType.NDBG)) {
            /****
             *  非年度报表，根据业务类型和业务ID获取approval记录表
             */
            approval  = approvalDAO.findBybusinessidAndType(businessid,businesstype);
        }


        Map<String,Object> variables=new HashMap<String,Object>();
        String newGroupid = "";
        //业务ID
        variables.put("businessid", businessid);
        // 启动流程ID
        String processInstanceId = "";
        BusinessCommon businessCommon = businessService.findByBusinessTypeAndId(businesstype,businessid);

        //审批内容
        String context = businessCommon.getApprovalContent();
        //区域编码
        String areaCode = businessCommon.getDistrict();
        ApproveTemp approveTemp = approveTempDao.findByTempCode(processKey + "-" + areaCode);
        if(approveTemp == null){
            //区域编码
            areaCode = businessCommon.getCity();
        }
        //区县编码
        String district = businessCommon.getDistrict();
        //所在地省市县（区）
        String szss = businessCommon.getSzss();
        //机构ID
        Long orgId = businessCommon.getOrgid();
        userId = businessCommon.getUserid();
        //民警ID
        if (businessCommon.getPoliceid() != null) {
            policeId = businessCommon.getPoliceid();
        }

        if(approval == null) {
            //初始化参数
            approval = new Approval();
            approval.setCreateTime(new Date());
            approval.setActive(true);
            approval.setBusinessid(businessid);
            approval.setBusinesstype(businesstype);
            approval.setUserid(userId);
        }else {
            approval.setUserid(userId);
            approval.setApprovaldate(null);
            approval.setApprovalreason(null);
            approval.setReplyreason("");
            approval.setReplyRar("");
            approval.setReplystate("");
            approval.setInfoRar("");
            //指派民警字段
            if(policeId == 0L || policeId == null ){
                if(approval.getPoliceid()!=null) {
                    policeId = approval.getPoliceid();
                }
            }
        }


        //配置 是否需要流程
        Config isNeedActivity = configUtils.getConfigByKey(Constants.IS_NEED_ACTIVITY);

        if(BusinessType.BAYZ.equals(businesstype) && isNeedActivity != null && Constants.IS_NEED_ACTIVITY_NO.equals(isNeedActivity.getValue())){
            //保安员证 且配置不需要流程的
        }else{

            processKey = processKey +"-"+ areaCode;

            //获取审批机构id
            try{
                orgId = getApprovalOrgId(processKey,businessCommon);
            }catch (Exception e){
                // 报错说明 根据审批机构类型取不到审批机构id，即为 审批流程未配置
                logger.error(e.getMessage(),e);
                throw  new ArsException("办事机构审批流程未配置！");
            }

            if(orgId == null) {
                throw  new ArsException(szss + " 暂无办事机构，不能提交审批！");
            }

            ApproveTempOrgDto approveTempOrgDto = new ApproveTempOrgDto();
            approveTempOrgDto.setPoliceId(orgId.toString());
            if(processKey!=null){
                approveTempOrgDto.setTempCode(processKey);
            }
            Long count = approveAreaProcessService.getCountByTempCodeAndPoliceId(approveTempOrgDto);
            if(count <1) {
                throw  new ArsException("办事机构审批流程未配置！");
            }else {

                approveTempOrgDto.setApproveSetStatus("0");
                count = approveAreaProcessService.getCountByTempCodeAndPoliceId(approveTempOrgDto);
                if(count > 0) {
                    throw  new ArsException("办事机构审批流程未配置！");
                }
            }
        }
        try {
            ////保安员证不需要走流程或非保安员证业务
            if(  (  null==isNeedActivity||(null!=isNeedActivity&&Constants.IS_NEED_ACTIVITY_YES.equals(isNeedActivity.getValue())) ) || !businesstype.equals(BusinessType.BAYZ) ){
                Config config =  configUtils.getConfigByKey(Constants.POLICE);
                if(config!=null && config.getValue().equals(Constants.POLICE_IN)) {
                    if(StringUtil.isNotEmpty(approval.getProcessInstanceId())) {
                        processInstanceId = approval.getProcessInstanceId();
                    }else {
                        //生成流程，唯一标识：业务名称+机构ID
                        ProcessInstance pi = runtimeService.startProcessInstanceByKey(processKey +"-"+ orgId, variables);
                        processInstanceId = pi.getProcessInstanceId();
                    }
                    // 根据流程实例Id查询任务
                    Task task = taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult();
                    // 完成 任务提交
                    variables.put("areaCode", areaCode);//区域编码
                    variables.put("policeid", policeId);//民警ID
                    variables.put("testState", "");//考试状态
                    taskService.complete(task.getId(), variables);

                    //查询历史
                    Task newTask = null;
                    List<HistoricActivityInstance> list = historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list();
                    if(list != null && list.size()>0){
                        for(HistoricActivityInstance hai : list){
                            logger.info(hai.getId()+"  "+hai.getActivityName()+"  "+hai.getCalledProcessInstanceId());
                            //判断是否为子流程
                            if(hai.getCalledProcessInstanceId()!=null && hai.getEndTime()==null ){
                                // 根据流程实例Id查询任务
                                newTask = taskService.createTaskQuery().processInstanceId(hai.getCalledProcessInstanceId()).singleResult();
                            }
                        }
                    }

                    if(newTask != null) {
                        //审批对象
                        approval.setNextPerson(newTask.getName());//下一个审批人
                        approval.setProcessInstanceId(processInstanceId);//子流程ID
                        approval.setInProcessInstanceId(processInstanceId);//内网流程ID
                        approval.setOutProcessInstanceId(processInstanceId);//外网流程ID

                        List<IdentityLink> newTaskEntitys = taskService.getIdentityLinksForTask(newTask.getId());
                        if (newTaskEntitys != null && newTaskEntitys.size() > 0) {
                            IdentityLink identityLink = newTaskEntitys.get(0);
                            newGroupid = identityLink.getGroupId();
                        }
                    }
                }else {
                    approval.setProcessInstanceId(null);//子流程ID
                }
            }
            approval.setGroupid(newGroupid);
            approval.setUpdateBy(user.getUsername());//更新者
            approval.setUpdateTime(new Date());//更新时间
            approval.setOrgid(orgId);//机构ID
            //审批内容
            approval.setContext(context);
            //区域编码
            if(StringUtil.isEmpty(district)){
                district = areaCode;
            }
            approval.setAreaCode(district);
            //审批状态：待审批
            approval.setApprovalstate(ApprovalState.DSH);
            //保存信息
            if (approval.getId() == null) {
                approval.setOldRev(false);
                approval.setId(idGeneratorUtil.createID());
                approvalDAO.save(approval);
            } else {
                approvalDAO.update(approval);
            }
            if(Constants.BEIJING.equals(configUtils.getCurrentNative())) {
                String APPRAISE_SWITCH = configUtils.getValueByKey(Constants.APPRAISE_SWITCH);
                if(Constants.YES.equals(APPRAISE_SWITCH)) {
                    Approval finalApproval = approval;
                    new Thread(() -> {
                        pushToAppraise(businessCommon, finalApproval,user);
                    }).start();
                }
            }
        }catch(Exception e){
            logger.error(e.getMessage(),e);
            throw  new ArsException("未配置审批流程，不能提交审批！");
        }
    }
    /***
     * 保存审核信息 新审批业务
     * @param businesstype 业务类型
     * @param businessid 业务ID
     */
    public void saveApproval(String businesstype,Long businessid,String processKey){
        User user = arsUtil.getCurrentUser();
        Long userId  =  0L;
        Long policeId = 0L;
        //公司或自然人
        userId = user.getId();
        Approval approval = null ;
        if (!businesstype.equals(BusinessType.NDBG)) {
            /****
             *  非年度报表，根据业务类型和业务ID获取approval记录表
             */
            approval  = approvalDAO.findBybusinessidAndType(businessid,businesstype);
        }


        Map<String,Object> variables=new HashMap<String,Object>();
        String newGroupid = "";
        //业务ID
        variables.put("businessid", businessid);
        // 启动流程ID
        String processInstanceId = "";
        BusinessCommon businessCommon = businessService.findByBusinessTypeAndId(businesstype,businessid);

        //审批内容
        String context = businessCommon.getApprovalContent();
        //区域编码
        String areaCode = businessCommon.getDistrict();


        ApproveTemp approveTemp = approveTempDao.findByTempCode(processKey + "-" + areaCode);
        if (approveTemp == null) {
            //区域编码
            areaCode = businessCommon.getCity();
            approveTemp = approveTempDao.findByTempCode(processKey + "-" + areaCode);
            if (approveTemp == null){
                approveTemp = approveTempDao.findByTempCode(processKey);
            }
        }
        if (approveTemp == null){
            throw new ArsException("审批流程未配置");
        }
        //区县编码
        String district = businessCommon.getDistrict();
        //所在地省市县（区）
        String szss = businessCommon.getSzss();
        //机构ID
        Long orgId = businessCommon.getOrgid();
        userId = businessCommon.getUserid();
        //民警ID
        if (businessCommon.getPoliceid() != null) {
            policeId = businessCommon.getPoliceid();
        }

        if (approval == null) {
            //初始化参数
            approval = new Approval();
            approval.setCreateTime(new Date());
            approval.setActive(true);
            approval.setBusinessid(businessid);
            approval.setBusinesstype(businesstype);
            approval.setUserid(userId);
        } else {
            approval.setUserid(userId);
            approval.setApprovaldate(null);
            approval.setApprovalreason(null);
            approval.setReplyreason("");
            approval.setReplyRar("");
            approval.setReplystate("");
            approval.setInfoRar("");
            //指派民警字段
            if (policeId == 0L || policeId == null) {
                if (approval.getPoliceid() != null) {
                    policeId = approval.getPoliceid();
                }
            }
        }


        //配置 是否需要流程
        String isNeedActivity = configUtils.getValueByKey(Constants.IS_NEED_ACTIVITY);
        if(!businessCommon.getNeedApprove()){
            isNeedActivity = Constants.IS_NEED_ACTIVITY_NO;
        }

        if (BusinessType.BAYZ.equals(businesstype) && isNeedActivity != null && Constants.IS_NEED_ACTIVITY_NO.equals(isNeedActivity)) {
            //保安员证 且配置不需要流程的
        } else {

            processKey = approveTemp.getTempCode();

            //获取审批机构id
            try {
                orgId = getApprovalOrgId(processKey, businessCommon);
            } catch (Exception e) {
                // 报错说明 根据审批机构类型取不到审批机构id，即为 审批流程未配置
                logger.error(e.getMessage(), e);
                throw new ArsException("办事机构审批流程未配置！");
            }

            if (orgId == null) {
                throw new ArsException(szss + " 暂无办事机构，不能提交审批！");
            }

            ApproveTempOrgDto approveTempOrgDto = new ApproveTempOrgDto();
            approveTempOrgDto.setPoliceId(orgId.toString());
            if (processKey != null) {
                approveTempOrgDto.setTempCode(processKey);
            }
            Long count = approveAreaProcessService.getCountByTempCodeAndPoliceId(approveTempOrgDto);
            if (count < 1) {
                throw new ArsException("办事机构审批流程未配置！");
            } else {

                approveTempOrgDto.setApproveSetStatus("0");
                count = approveAreaProcessService.getCountByTempCodeAndPoliceId(approveTempOrgDto);
                if (count > 0) {
                    throw new ArsException("办事机构审批流程未配置！");
                }
            }
        }
        try {
            ////保安员证不需要走流程或非保安员证业务
            if ((null == isNeedActivity || (null != isNeedActivity && Constants.IS_NEED_ACTIVITY_YES.equals(isNeedActivity))) || !businesstype.equals(BusinessType.BAYZ)) {
                Config config = configUtils.getConfigByKey(Constants.POLICE);
                if (config != null && config.getValue().equals(Constants.POLICE_IN)) {
                    if (StringUtil.isNotEmpty(approval.getProcessInstanceId())) {
                        processInstanceId = approval.getProcessInstanceId();
                    } else {
                        //生成流程，唯一标识：业务名称+机构ID
                        ProcessInstance pi = runtimeService.startProcessInstanceByKey(processKey + "-" + orgId, variables);
                        processInstanceId = pi.getProcessInstanceId();
                    }
                    // 根据流程实例Id查询任务
                    Task task = taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult();
                    // 完成 任务提交
                    variables.put("areaCode", areaCode);//区域编码
                    variables.put("policeid", policeId);//民警ID
                    variables.put("testState", "");//考试状态
                    taskService.complete(task.getId(), variables);

                    //查询历史
                    Task newTask = null;
                    List<HistoricActivityInstance> list = historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list();
                    if (list != null && list.size() > 0) {
                        for (HistoricActivityInstance hai : list) {
                            logger.info(hai.getId() + "  " + hai.getActivityName() + "  " + hai.getCalledProcessInstanceId());
                            //判断是否为子流程
                            if (hai.getCalledProcessInstanceId() != null && hai.getEndTime() == null) {
                                // 根据流程实例Id查询任务
                                newTask = taskService.createTaskQuery().processInstanceId(hai.getCalledProcessInstanceId()).singleResult();
                            }
                        }
                    }

                    if (newTask != null) {
                        //审批对象
                        approval.setNextPerson(newTask.getName());//下一个审批人
                        approval.setProcessInstanceId(processInstanceId);//子流程ID
                        approval.setInProcessInstanceId(processInstanceId);//内网流程ID
                        approval.setOutProcessInstanceId(processInstanceId);//外网流程ID

                        List<IdentityLink> newTaskEntitys = taskService.getIdentityLinksForTask(newTask.getId());
                        if (newTaskEntitys != null && newTaskEntitys.size() > 0) {
                            IdentityLink identityLink = newTaskEntitys.get(0);
                            newGroupid = identityLink.getGroupId();
                        }
                    }
                } else {
                    approval.setProcessInstanceId(null);//子流程ID
                }
            }
            approval.setGroupid(newGroupid);
            approval.setUpdateBy(user.getUsername());//更新者
            approval.setUpdateTime(new Date());//更新时间
            approval.setOrgid(orgId);//机构ID
            //审批内容
            approval.setContext(context);
            //区域编码
            if (StringUtil.isEmpty(district)) {
                district = areaCode;
            }
            approval.setAreaCode(district);
            //审批状态：待审批
            approval.setApprovalstate(ApprovalState.DSH);
            //保存信息
            if (approval.getId() == null) {
                approval.setOldRev(false);
                approval.setId(idWorker.nextId());
                try {
                    approvalDAO.save(approval);
                } catch (Exception e) {
                    try {
                        //主键冲突重试一下
                        logger.error(approval.getId() + ":approval表主键冲突");
                        approval.setId(idWorker.nextId());
                        approvalDAO.save(approval);
                    } catch (Exception ex) {
                        throw new ArsException("主键冲突！");
                    }

                }
            } else {
                approvalDAO.update(approval);
            }
            if (Constants.BEIJING.equals(configUtils.getCurrentNative())) {
                String APPRAISE_SWITCH = configUtils.getValueByKey(Constants.APPRAISE_SWITCH);
                if (Constants.YES.equals(APPRAISE_SWITCH)) {
                    Approval finalApproval = approval;
                    new Thread(() -> {
                        pushToAppraise(businessCommon, finalApproval, user);
                    }).start();
                }
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new ArsException("未配置审批流程，不能提交审批！");
        }
    }

    /**
     * 第三方培训平台
     *
     * @param businesstype
     * @param businessid
     * @param processKey
     * @param areaCode
     */
    public void saveApprovalForThirdPartyTrain(String businesstype, Long businessid, String processKey, String areaCode) {
        User user = arsUtil.getCurrentUser();
        Long userId = 0L;
        Long policeId = 0L;
        //公司或自然人
        userId = user.getId();
        Approval approval = null;
        if (!businesstype.equals(BusinessType.NDBG)) {
            /****
             *  非年度报表，根据业务类型和业务ID获取approval记录表
             */
            approval = approvalDAO.findBybusinessidAndType(businessid, businesstype);
        }


        Map<String, Object> variables = new HashMap<String, Object>();
        String newGroupid = "";
        //业务ID
        variables.put("businessid", businessid);
        // 启动流程ID
        String processInstanceId = "";
        BusinessCommon businessCommon = businessService.findByBusinessTypeAndId(businesstype, businessid);

        //审批内容
        String context = businessCommon.getApprovalContent();
        ApproveTemp approveTemp = approveTempDao.findByTempCode(processKey + "-" + areaCode);
        if (approveTemp == null) {
            //区域编码
            areaCode = businessCommon.getCity();
        }
        //区县编码
        String district = businessCommon.getDistrict();
        //所在地省市县（区）
        String szss = businessCommon.getSzss();
        //机构ID
        Long orgId = businessCommon.getOrgid();
        userId = businessCommon.getUserid();
        //民警ID
        if (businessCommon.getPoliceid() != null) {
            policeId = businessCommon.getPoliceid();
        }

        if(approval == null) {
            //初始化参数
            approval = new Approval();
            approval.setCreateTime(new Date());
            approval.setActive(true);
            approval.setBusinessid(businessid);
            approval.setBusinesstype(businesstype);
            approval.setUserid(userId);
        }else {
            approval.setUserid(userId);
            approval.setApprovaldate(null);
            approval.setApprovalreason(null);
            approval.setReplyreason("");
            approval.setReplyRar("");
            approval.setReplystate("");
            approval.setInfoRar("");
            //指派民警字段
            if(policeId == 0L || policeId == null ){
                if(approval.getPoliceid()!=null) {
                    policeId = approval.getPoliceid();
                }
            }
        }


        //配置 是否需要流程
        Config isNeedActivity = configUtils.getConfigByKey(Constants.IS_NEED_ACTIVITY);

        if(BusinessType.BAYZ.equals(businesstype) && isNeedActivity != null && Constants.IS_NEED_ACTIVITY_NO.equals(isNeedActivity.getValue())){
            //保安员证 且配置不需要流程的
        }else{

            processKey = processKey +"-"+ areaCode;

            //获取审批机构id
            try{
                orgId = getApprovalOrgId(processKey,businessCommon);
            }catch (Exception e){
                // 报错说明 根据审批机构类型取不到审批机构id，即为 审批流程未配置
                logger.error(e.getMessage(),e);
                throw  new ArsException("办事机构审批流程未配置！");
            }

            if(orgId == null) {
                throw  new ArsException(szss + " 暂无办事机构，不能提交审批！");
            }

            ApproveTempOrgDto approveTempOrgDto = new ApproveTempOrgDto();
            approveTempOrgDto.setPoliceId(orgId.toString());
            if(processKey!=null){
                approveTempOrgDto.setTempCode(processKey);
            }
            Long count = approveAreaProcessService.getCountByTempCodeAndPoliceId(approveTempOrgDto);
            if(count <1) {
                throw  new ArsException("办事机构审批流程未配置！");
            }else {

                approveTempOrgDto.setApproveSetStatus("0");
                count = approveAreaProcessService.getCountByTempCodeAndPoliceId(approveTempOrgDto);
                if(count > 0) {
                    throw  new ArsException("办事机构审批流程未配置！");
                }
            }
        }
        try {
            ////保安员证不需要走流程或非保安员证业务
            if(  (  null==isNeedActivity||(null!=isNeedActivity&&Constants.IS_NEED_ACTIVITY_YES.equals(isNeedActivity.getValue())) ) || !businesstype.equals(BusinessType.BAYZ) ){
                Config config =  configUtils.getConfigByKey(Constants.POLICE);
                if(config!=null && config.getValue().equals(Constants.POLICE_IN)) {
                    if(StringUtil.isNotEmpty(approval.getProcessInstanceId())) {
                        processInstanceId = approval.getProcessInstanceId();
                    }else {
                        //生成流程，唯一标识：业务名称+机构ID
                        ProcessInstance pi = runtimeService.startProcessInstanceByKey(processKey +"-"+ orgId, variables);
                        processInstanceId = pi.getProcessInstanceId();
                    }
                    // 根据流程实例Id查询任务
                    Task task = taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult();
                    // 完成 任务提交
                    variables.put("areaCode", areaCode);//区域编码
                    variables.put("policeid", policeId);//民警ID
                    variables.put("testState", "");//考试状态
                    taskService.complete(task.getId(), variables);

                    //查询历史
                    Task newTask = null;
                    List<HistoricActivityInstance> list = historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list();
                    if(list != null && list.size()>0){
                        for(HistoricActivityInstance hai : list){
                            logger.info(hai.getId()+"  "+hai.getActivityName()+"  "+hai.getCalledProcessInstanceId());
                            //判断是否为子流程
                            if(hai.getCalledProcessInstanceId()!=null && hai.getEndTime()==null ){
                                // 根据流程实例Id查询任务
                                newTask = taskService.createTaskQuery().processInstanceId(hai.getCalledProcessInstanceId()).singleResult();
                            }
                        }
                    }

                    if(newTask != null) {
                        //审批对象
                        approval.setNextPerson(newTask.getName());//下一个审批人
                        approval.setProcessInstanceId(processInstanceId);//子流程ID
                        approval.setInProcessInstanceId(processInstanceId);//内网流程ID
                        approval.setOutProcessInstanceId(processInstanceId);//外网流程ID

                        List<IdentityLink> newTaskEntitys = taskService.getIdentityLinksForTask(newTask.getId());
                        if (newTaskEntitys != null && newTaskEntitys.size() > 0) {
                            IdentityLink identityLink = newTaskEntitys.get(0);
                            newGroupid = identityLink.getGroupId();
                        }
                    }
                }else {
                    approval.setProcessInstanceId(null);//子流程ID
                }
            }
            approval.setGroupid(newGroupid);
            approval.setUpdateBy(user.getUsername());//更新者
            approval.setUpdateTime(new Date());//更新时间
            approval.setOrgid(orgId);//机构ID
            //审批内容
            approval.setContext(context);
            //区域编码
            if(StringUtil.isEmpty(district)){
                district = areaCode;
            }
            approval.setAreaCode(district);
            //审批状态：待审批
            approval.setApprovalstate(ApprovalState.DSH);
            //保存信息
            if (approval.getId() == null) {
                approval.setOldRev(false);
                approval.setId(idWorker.nextId());
                try {
                    approvalDAO.save(approval);
                }catch (Exception e){
                    try {
                        //主键冲突重试一下
                        logger.error(approval.getId()+":approval表主键冲突");
                        approval.setId(idWorker.nextId());
                        approvalDAO.save(approval);
                    }catch (Exception ex){
                        throw new ArsException("主键冲突！");
                    }

                }
            } else {
                approvalDAO.update(approval);
            }
            if(Constants.BEIJING.equals(configUtils.getCurrentNative())) {
                String APPRAISE_SWITCH = configUtils.getValueByKey(Constants.APPRAISE_SWITCH);
                if(Constants.YES.equals(APPRAISE_SWITCH)) {
                    Approval finalApproval = approval;
                    new Thread(() -> {
                        pushToAppraise(businessCommon, finalApproval,user);
                    }).start();
                }
            }
        }catch(Exception e){
            logger.error(e.getMessage(),e);
            throw  new ArsException("未配置审批流程，不能提交审批！");
        }
    }

    public void pushToAppraise(BusinessCommon businessCommon,Approval approval,User user){
        try {
            MatterType matterType = MatterType.getByBusinessCode(approval.getBusinesstype());

            if(matterType == null){
                return;
            }

            String areaCode = businessCommon.getDistrict();

            if(matterType.getOrgType().equals(Constants.ORGTYPE_CITY)){
                areaCode = businessCommon.getCity();
            }
            BjMatterInfo matterInfo = bjMatterInfoDao.findByCode(matterType.getCode(), areaCode);
            if(matterInfo == null){
                return;
            }

            approval.setNeedAppraise(Constants.YES);

            String time = DateUtil.getCurrentDate(DateUtil.FORMAT8);
            String key = "ProjectNo"+DateUtil.getCurrentDate(DateUtil.FORMAT11);

            String sign = SmCryptoUtil.sm2Encode(time+ AppraiseConstants.appMark + AppraiseConstants.appWord, AppraiseConstants.publicKey);

            AppraiseDto appraiseDto = new AppraiseDto();
            appraiseDto.setAppMark(AppraiseConstants.appMark);
            appraiseDto.setTime(time);
            appraiseDto.setSign(sign);

            ShareApprInfo shareApprInfo = new ShareApprInfo();
            shareApprInfo.setTaskCode(matterInfo.getTaskCode());
            shareApprInfo.setTaskName(matterType.getName());
            shareApprInfo.setProjectNo(matterInfo.getTaskCode()+DateUtil.getCurrentDate(DateUtil.FORMAT11)+redisUtil.createAutoID(key,4,1));
            shareApprInfo.setProStatus("1");
            shareApprInfo.setOrgcode(matterInfo.getOrgCode());
            shareApprInfo.setOrgName(matterInfo.getOrgName());
            shareApprInfo.setAdministrative_div(matterInfo.getAreaCode().trim().substring(4));

            shareApprInfo.setTaskguid(matterInfo.getEventMatterCode());

            String statusUrl = DES3.encode(approval.getId().toString());
            statusUrl = URLEncoder.encode(statusUrl,"UTF-8");
            shareApprInfo.setStatusUrl(configUtils.getWebHost()+"/approval/businessDetail.do?approvalId="+statusUrl);


            //TODO 如果是企业 需要另外处理
            //自然人=1
            if(user.getPlatform() == Constants.PLATFORM_NATURAL_PERSON){
                shareApprInfo.setUserProp("1");
                shareApprInfo.setUserName(user.getRealname());
                shareApprInfo.setCertKey(user.getIdNumber());
                shareApprInfo.setTelPhone(user.getPhone());
                //TODO 姓名不符合规则不传
                if(!IdNumUtil.isRealName(user.getRealname())){
                    return ;
                }
            }
            //企业法人
            if(user.getPlatform() == Constants.PLATFORM_COMPANY){
                shareApprInfo.setUserProp("2");
                SecurityCompany company = securityCompanyService.findByUserid(user.getId());
                if(company == null || StringUtil.isEmpty(company.getLegalPerson()) || StringUtil.isEmpty(company.getLegalPersonNo())){
                    return ;
                }

                //TODO 姓名不符合规则不传
                if(!IdNumUtil.isRealName(company.getLegalPerson())){
                    return ;
                }
                shareApprInfo.setUserName(company.getLegalPerson());
                shareApprInfo.setCertKey(company.getLegalPersonNo());
                shareApprInfo.setTelPhone(user.getPhone());

            }

            //111 居民身份证
            shareApprInfo.setUserPageType("111");

            shareApprInfo.setServiceName("申报");
            shareApprInfo.setIsService("1");
            shareApprInfo.setServiceTime(DateUtil.getCurrentDate(DateUtil.FORMAT1));
            shareApprInfo.setServiceDate(DateUtil.getCurrentDate());
            shareApprInfo.setDataSource("111");
            shareApprInfo.setProjectType("1");
            shareApprInfo.setApplydate(DateUtil.getCurrentDate(DateUtil.FORMAT1));
            shareApprInfo.setBj_zt("12");
            shareApprInfo.setSource(AppraiseConstants.source);
            shareApprInfo.setSourceTJ(AppraiseConstants.source);

            Map<String,Object> projectServiceMap = new HashMap<>();
            projectServiceMap.put("projectService",shareApprInfo);
            List params = new ArrayList<>();
            params.add(projectServiceMap);
            Map<String,String> dataMap = new HashMap<>();
            dataMap.put("data",SmCryptoUtil.sm2Encode(JSON.toJSONString(params), AppraiseConstants.publicKey));
            appraiseDto.setParams(JSON.toJSONString(dataMap));

            AjaxResult result = appraiseInterfaceUtil.callInterface(AppraiseConstants.URL_RESHAREAPPRINFO, appraiseDto);
            if(result.isSuccessful()){
                try {
                    AppraiseResultDto resultDto = (AppraiseResultDto) result.getData();
                    if(StringUtil.isNotEmpty(resultDto.getServiceCode())){
                        approval.setServiceCode(resultDto.getServiceCode());
                        approval.setPushDate(new Date());
                        approvalDAO.updateServiceCode(approval);
                    }
                }catch (Exception e){
                    e.printStackTrace();
                    approvalDAO.updateServiceCode(approval);
                }
            }
        }catch (Exception e){
            e.printStackTrace();
            approvalDAO.updateServiceCode(approval);
        }
    }

    /***
     * 保存保安员审核信息 新审批业务
     * @param businesstype 业务类型
     * @param businessid 业务ID
     */
    public void savePersonApproval(String businesstype,Long businessid,String processKey){
        String newGroupid = "";
        String taskDefinitionKey = "";
        Approval approval = approvalDAO.findBybusinessidAndType(businessid,businesstype);
        if(approval == null){
            return;
        }
        Map<String,Object> variables=new HashMap<String,Object>();
        Personcertificate personcertificate = personcertificateService.findById(businessid);
        Long userId  =  personcertificate.getUserid();
        User user = userDao.findById(userId);
        //审批内容
        String context = "【" + personcertificate.getName() + "】保安员证报名审批";
        //区域编码
        String areaCode = personcertificate.getDistrict();
        ApproveTemp approveTemp = approveTempDao.findByTempCode(processKey + "-" + areaCode);
        if(approveTemp == null){
            //区域编码
            areaCode = areaCode.substring(0,4)+"00";
        }

        //考试状态
        String testState = personcertificate.getTestState();
        //区级编码
        String district= personcertificate.getDistrict();
        //所在地省市县（区）
        String szss = personcertificate.getSzss();
        //机构ID
        Long orgId = approval.getOrgid();
        //业务ID
        variables.put("businessid", businessid);
        // 启动流程ID
        String processInstanceId = "";

        approval.setApprovalperson(null);
        approval.setUserid(userId);
        approval.setApprovaldate(null);
        approval.setApprovalreason(null);
        approval.setReplyreason("");
        approval.setReplyRar("");
        approval.setReplystate("");
        approval.setInfoRar("");
        approval.setGroupid("");
        approval.setTaskDefinitionKey("");
        approval.setOutreason("");


        //配置 是否需要流程
        Config isNeedActivity = configUtils.getConfigByKey(Constants.IS_NEED_ACTIVITY);
        if( ( null==isNeedActivity||(null!=isNeedActivity&&Constants.IS_NEED_ACTIVITY_YES.equals(isNeedActivity.getValue()))  ) || !businesstype.equals(BusinessType.BAYZ)){
            if(orgId == null) {
                throw  new ArsException(szss + " 暂无办事机构，不能提交审批！");
            }
            processKey = processKey +"-"+ areaCode;
            ApproveTempOrgDto approveTempOrgDto = new ApproveTempOrgDto();
            approveTempOrgDto.setPoliceId(orgId.toString());
            if(processKey!=null){
                approveTempOrgDto.setTempCode(processKey);
            }
            Long count = approveAreaProcessService.getCountByTempCodeAndPoliceId(approveTempOrgDto);
            if(count <1) {
                throw  new ArsException("办事机构审批流程未配置！");
            }else {
                approveTempOrgDto.setApproveSetStatus("0");
                count = approveAreaProcessService.getCountByTempCodeAndPoliceId(approveTempOrgDto);
                if(count > 0) {
                    throw  new ArsException("办事机构审批流程未配置！");
                }
            }
        }
        try {
            Config config =  configUtils.getConfigByKey(Constants.POLICE);
            if( ( null==isNeedActivity||(null!=isNeedActivity&&Constants.IS_NEED_ACTIVITY_YES.equals(isNeedActivity.getValue()))  ) || !businesstype.equals(BusinessType.BAYZ)){
              if(config!=null && config.getValue().equals(Constants.POLICE_IN)) {
                    //生成流程，唯一标识：业务名称+机构ID
                    ProcessInstance pi = runtimeService.startProcessInstanceByKey(processKey + "-" + orgId, variables);
                    processInstanceId = pi.getProcessInstanceId();
                    // 根据流程实例Id查询任务
                    Task task = taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult();
                    // 完成 任务提交
                    variables.put("areaCode", areaCode);//区域编码
                    variables.put("testState", testState);//考试状态
                    taskService.complete(task.getId(), variables);

                    //查询历史
                    Task newTask = null;
                    List<HistoricActivityInstance> list = historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list();
                    if (list != null && list.size() > 0) {
                        for (HistoricActivityInstance hai : list) {
                            logger.info(hai.getId() + "  " + hai.getActivityName() + "  " + hai.getCalledProcessInstanceId());
                            //判断是否为子流程
                            if (hai.getCalledProcessInstanceId() != null && hai.getEndTime() == null) {
                                // 根据流程实例Id查询任务
                                newTask = taskService.createTaskQuery().processInstanceId(hai.getCalledProcessInstanceId()).singleResult();
                            }
                        }
                    }

                    if (newTask != null) {
                        taskDefinitionKey = newTask.getTaskDefinitionKey();
                        List<IdentityLink> newTaskEntitys = taskService.getIdentityLinksForTask(newTask.getId());
                        if (newTaskEntitys != null && newTaskEntitys.size() > 0) {
                            IdentityLink identityLink = newTaskEntitys.get(0);
                            newGroupid = identityLink.getGroupId();
                        }

                        //审批对象
                        approval.setNextPerson(newTask.getName());//下一个审批人
                        approval.setProcessInstanceId(processInstanceId);//子流程ID
                        approval.setInProcessInstanceId(processInstanceId);//内网流程ID
                    }
                } else {
                    approval.setProcessInstanceId(null);//子流程ID
                }
            }


            approval.setTaskDefinitionKey(taskDefinitionKey);
            approval.setGroupid(newGroupid);
            if(user != null) {
                approval.setUpdateBy(user.getUsername());//更新者
            }else {
                logger.error(userId +"userid不存在，请排查!");
            }
            approval.setUpdateTime(new Date());//更新时间
            approval.setOrgid(orgId);//机构ID
            //审批内容
            approval.setContext(context);
            //区域编码
            if(StringUtil.isEmpty(district)){
                district = areaCode;
            }
            approval.setAreaCode(district);
            //审批状态：待审批
            if(StringUtil.isNotEmpty(testState) && Constants.TEST_STATE_TG.equals(testState)){
                approval.setApprovalstate(ApprovalState.SPZ);
            }else {
                approval.setApprovalstate(ApprovalState.DSH);
            }
            approval.setUpdateflag(true);
            approval.setOldRev(false);
            //保存信息
            approvalDAO.update(approval);
        }catch(Exception e){
            throw  new ArsException("未配置审批流程，不能提交审批！");
        }
    }

    /**
     * add subh 2019-02-26
     * 根据业务类型获取流程Key
     * @param approval 审批记录信息
     * @return 返回流程的Key
     */
    public String getBusinessTypeForActKey(Approval approval){
        //业务类型
        String tempCode = approval.getBusinesstype();
        //返回流程的Key变量
        String result = "";
        switch (tempCode) {
            //自行招用
            case BusinessType.ZXZY:
                result = Constants.ACTIVITI_PROCESS_CONFESSCOMPANY;
                break;
            //分公司
            case BusinessType.BAGSZGS:
                result = Constants.ACTIVITI_PROCESS_SUBSIDIARY;
                break;
            //跨区
            case BusinessType.KQYBAGS:
                result = Constants.ACTIVITI_PROCESS_CROSSCOMPANY;
                break;
            //项目变更
            case BusinessType.FRBG:
                //获取项目变更信息
                Legalchange legalchange = legalchangeService.findById(approval.getBusinessid());
                //判断项目变更不为空，防止异常
                if(legalchange!=null) {
                    //根据项目变更信息companyid获取公司信息
                    SecurityCompany company = securityCompanyService.findById(legalchange.getCompanyid());
                    //武装项目变更
                    if(Constants.SPONSORLICENSE_WZ.equals(company.getSponsorlicenseType())){
                        result = Constants.ACTIVITI_PROCESS_LEGALCHANGEARM;
                        //合资项目变更
                    }else if(Constants.SPONSORLICENSE_HZ.equals(company.getSponsorlicenseType())){
                        result = Constants.ACTIVITI_PROCESS_LEGALCHANGEJOINT;
                    }else {//保安公司项目变更
                        result = Constants.ACTIVITI_PROCESS_LEGALCHANGE;
                    }
                }else{
                    result = Constants.ACTIVITI_PROCESS_LEGALCHANGE;
                }
                break;
            //保安人员
            case BusinessType.BAYZ:
                result = Constants.ACTIVITI_PROCESS_PERSONCERTIFICATE;
                break;
            //保安公司
            case BusinessType.BAFWGS:
                //获取保安服务公司信息，更新审批信息
                Sponsorlicense sponsorlicense = sponsorlicenseService.findById(approval.getBusinessid());
                if(sponsorlicense!=null) {
                    //武装
                    if (Constants.SPONSORLICENSE_WZ.equals(sponsorlicense.getSponsorlicenseType())) {
                        result = Constants.ACTIVITI_PROCESS_SPONSORLICENSEARM;
                        //合资
                    } else if (Constants.SPONSORLICENSE_HZ.equals(sponsorlicense.getSponsorlicenseType())) {
                        result = Constants.ACTIVITI_PROCESS_SPONSORLICENSEJOINT;
                    } else {
                        result = Constants.ACTIVITI_PROCESS_SPONSORLICENSE;
                    }
                }else{
                    result = Constants.ACTIVITI_PROCESS_SPONSORLICENSE;
                }
                break;
            //培训单位
            case BusinessType.PXDW:
                result = Constants.ACTIVITI_PROCESS_TRAINCOMPANYAPPLY;
                break;
            //年度报表
            case BusinessType.NDBG:
                //获取年度报告信息
                Yearreportdata yearreportdata = yearreportdataService.findById(approval.getBusinessid());
                //判断年度报告不为空，防止异常
                if(yearreportdata!=null) {
                    //根据年度报告信息companyid获取公司信息
                    SecurityCompany company = securityCompanyService.findByUserid(yearreportdata.getUserid());
                    //武装年度报告
                    if(Constants.SPONSORLICENSE_WZ.equals(company.getSponsorlicenseType())){
                        result = Constants.ACTIVITI_PROCESS_YEARREPORT_ARMED;
                        //合资年度报告
                    }else if(Constants.SPONSORLICENSE_HZ.equals(company.getSponsorlicenseType())){
                        result = Constants.ACTIVITI_PROCESS_YEARREPORT;
                    }else {//保安公司年度报告
                        result = Constants.ACTIVITI_PROCESS_YEARREPORT;
                    }
                }else{
                    result = Constants.ACTIVITI_PROCESS_YEARREPORT;
                }
                break;
            //枪支备案
            case BusinessType.QZPX:
                result = Constants.ACTIVITI_PROCESS_ARMTRAINORG;
                break;
            //自行招用保安员单位撤销备案
            case BusinessType.ZZBACX:
                result = Constants.ACTIVITI_PROCESS_CONFESSCOMPANYUNDO;
                break;
            case BusinessType.DJZBT:
                result = Constants.ACTIVITI_PROCESS_GRADESUBSIDY;
                break;
            case BusinessType.ZGZBT:
                result = Constants.ACTIVITI_PROCESS_QUALIFICATIONSUBSIDY;
                break;
            case BusinessType.PXDWXMBG:
                result = Constants.ACTIVITI_PROCESS_TRAINCHANGE;
                break;
            case BusinessType.BAPXDWBA:
                result = Constants.ACTIVITI_PROCESS_TRAINCOMPANYAPPLY;
                break;
            case BusinessType.BAYZHF:
                result = Constants.ACTIVITI_PROCESS_PERCERGRANT;
                break;
            default:
                break;
        }

        return result;
    }

    /**
     * 获取审批的机构id
     * @param processKey
     * @param businessCommon
     * @return
     * @throws Exception
     */
    public Long getApprovalOrgId(String processKey,BusinessCommon businessCommon) throws Exception{
        List<String> orgIds = new ArrayList<>();
        if(StringUtil.isNotEmpty(businessCommon.getCityOrgId())){
            orgIds.add(businessCommon.getCityOrgId());
            Police cityPolice = policeDao.findById(Long.parseLong(businessCommon.getCityOrgId()));
            if(cityPolice != null && cityPolice.getParentorg() != null) {
                orgIds.add(cityPolice.getParentorg().toString());
            }
        }
        if(StringUtil.isNotEmpty(businessCommon.getDistrictOrgId())){
            orgIds.add(businessCommon.getDistrictOrgId());
        }
        if(businessCommon.getOrgid() != null){
            orgIds.add(businessCommon.getOrgid().toString());
        }

        if(orgIds.size() > 0){
            return approveTempDao.getApprovalOrgId(processKey,orgIds);
        }
        return null;
    }

    public Police getApprovalOrg(BusinessCommon businessCommon,String businessType){
        //区域编码
        String areaCode = businessCommon.getDistrict();

        StringBuffer tempCode =  new StringBuffer();
        String sponsorlicenseType = null;
        if(BusinessType.BAFWGS.equals(businessType)){
            Sponsorlicense sponsorlicense = (Sponsorlicense)businessCommon;
            sponsorlicenseType = sponsorlicense.getSponsorlicenseType();
        }
        tempCode.append( BusinessType.getBusinessTypeName(businessType,sponsorlicenseType));

        ApproveTemp approveTemp = approveTempDao.findByTempCode(tempCode.toString() + "-" + areaCode);
        if(approveTemp == null){
            //区域编码
            areaCode = businessCommon.getCity();
        }

        //获取审批机构id
        try{
            Long orgId = getApprovalOrgId(tempCode.toString() + "-" + areaCode,businessCommon);
            return policeDao.findById(orgId);
        }catch (Exception e){
            // 报错说明 根据审批机构类型取不到审批机构id，即为 审批流程未配置
            logger.error(e.getMessage(),e);
            throw  new ArsException("办事机构审批流程未配置！");
        }

    }


    public static void main(String[] args) {
        String result = SmCryptoUtil.sm2Decode("04db7b16616c9f6bb707caf693585a60fcd50b49205e143c47846465e6163e81ad00bd73061ce7879566bf4acc238b699d7a05247397f27dc587d9ac8dae8280fbf36cb9f976c5c8d6e69f4049c24dae3f0b3e257773347c4af4237ac8f93885cdf5ac7a576e52d8d91c2ffae7f630a25fcf51b0772503a7197c7e6d5b8990ab957af47fe08a9d3014ed3c45db307ccc2c006316fc4dd95e11b2709ced43f18a56b77fdd4003d24dc75b0ad6b11410994ea2ace17662b6b7bf0a4c60029acb27d0186e5cc992d0f2b2e4fae9d92c562a00c26552865a995164e1c5a1da4c0a70ecf13e4fb185a2b12502d8465c95d5978c9b7361b89dd75b4d95de840036191aa70e8ef0628dc49fee0e04a46490c1249c8637db797a5791e65f219b9e550f539e7ae7a190f79d4450ae2d84d1522c223daa9737383a9f668cdbb48c728c7aa4f4035b829a273913861943969acf9aa87d5b9596c3ce485ff947d71a5c1fad4ff5169ad04981e444a86e23a2d9fa9845f000580d97fc2ae8ecdc88f37f7e8d065083bca572d190096fbdbbba1d23aaf1f3b4a576416ea1b2af296a70d21a142116e59d39aa960881c575ff98f2ea9633f8a23b4734a5c8d9c33b64deb700251467cb7b549562155a4e7549068431c9a7d8c7a6de84377c311081368d8866e947b802613a1e15e2e68c1cf31f987983c854b5af8fdad785a843e8939a0698008627c9f09631fe6c737b2be334db9c0fd12e35037ecd3f576f7d785bf48d4f57615fa32d87b32e300429ea920ef13ad1faebd2b0f3a9ae748a5620b6eac2f1b341a80e3287cde1fbf63ebc1ab65a6f6135812b8b9ca1c2826dab8ab8f493adb02cfb1590daa5e3234030a0e78439f29683c1680b4e280dbd2dec0ffe377e731af744ddf7977214828fec13d511168e5204f9c7347df638eaf1190502d9d9e7e29c1bfba61a5fd1452b736543889e865ec213eeb816d33f313efc1ce4055e32df78bac2d51cdf7a314ba277a580b229865ca155c25f1447f11987f8a21ead1cef474e22969ced4c9296b3a44e40177f5f149576bb4027",AppraiseConstants.privateKey);
        System.out.println( result.replace("http://114.116.191.105:8010/ars-web/","http://localhost:8080/ars-web/"));
        result = SmCryptoUtil.sm2Decode("049a28e644b6f37079e97e5c37d80c710f2cddde695ec0fd17f085954adb620a468af6802aecbda2d1885a44743569507e4314ae2e553c9e31b74e07b8deb149eae7472c7151a14e86a4ff1de3ee79f741daac7389709f74a71ff03d0e02999ee488febdda1b210051027d3896fb914ec9f0db42d960573538fac18619fa14fc89b37dd18c9fbbd2dee7ae48b66ecb49e4daf039e401396e1f49b40ccc2cfe503862d768d564bde8fd029406eabc4c15bb7e9ad252cd3c8c76fa85d947b544bd50eb149524a4fab8963dd9e7a0ee029c07fe1ac822b540613d2af7fc8ab10cda7bc0fca7566d1aa63c855da6adff2dfd174c1ba31f6bd77fbc1eb49032863d62c66e83f79abe40ab8a21b1b307166c072a2651208e09dbbed2dff8048884a0864555fa8407e1b7a53414c87146d5bde90630be63802bf344b3aa545d03b0860370d75c8361140a43f4d00b4fa76ae0143594b1cc6c5cc9d232a3c2796e2c8bc766d03fc9cd163c70decc5fadf9f62432b09081ca58daa4ef01765e9f5bc843f6e947cf5cc30776a8d43e425564d90a16b40eb457e3e371b16e1b0d338ee8a4f96b017167885c199e49f7e5bec388e47c9b0091b3a974791ea79f0f2bd00a5bacdd49cf44fe73353c7a9eb270eb55ffc6f1daacc545a1c7dc4cb5b9644c583373863e21e92759f30fc363251a252c863071a103fe182ef254af9a338355fc918f813cb3d17746636222f2b4ddcee1048eca0bc448a3d61a43dc60fcba6f26758c0e248fc2796f4fab4aeaa23b2568a2cc47c8f681447011975cdc5c10af22054c14d93453022d67491d956a044b0445c8c4e0b9b45a296c7047fda380c45d0847dca6b29c963c85cb1ce69b41f96f1190c5228c2cb95eb969ce93eb096457bb43c98944e96666b9f29bd62959ee5a973964981eb3bfec89350e532b6a610f60303f78f6983a38380235899e09a9451b8d51e09abef5fe276a0862041d5bb1ce1f3a13d1bb4c356de89f16791466a5c0dc89cdff64ceeb2536425cff703f28923a01a8283b3b81feff2b2352446463d0df66252b3bbf4339655804db55b5a0342de96d6cf0549441788ff7b502e924b8e26d074412d05c4098f157c5de831c7e8fd6e2b94e64428d850708128659492431a09f86f8eb481cb647d813e9c4ab43005ff972fbd9ba8be187671122c30e758399e786c3bfe2f51716013aa4d27b2650501e69ad2816",AppraiseConstants.privateKey);
        System.out.println( result.replace("http://114.116.191.105:8010/ars-web/","http://localhost:8080/ars-web/"));
        result = SmCryptoUtil.sm2Decode("0431f0fb1b9749289d21242cc3cdc49a620b4c727426f6c2faea3036a3172fc29171153b143f1e24ba4f3ec180c7398339d023a5b4b5da6e8138a9aa8a541cb9615405b77405cffb69cc52e511ccd57282085b4510928e2db79927cb283d61d1563e7e7cfd8f90b83ce4469a7bc883ecb446cd4b7b4fb63ac7dbb147cc02bc00935de56845eba76312814e79a46afc1f1471d5ed418cb5e189c4da9f1fbb1a424027cdd1142f602937e799a311572e94cc1dd74100f901a8a9d8dde1a180776dcc8452d9cbe9c49361048f8bcb283d6790c1c4059775d308bdd288726d2441a8a50bd6e7982785e4a8458bbda32f53a84415c49cc06b59a3e3588b46aa5170132b03cceaa21d078ecea5e2264663d945596a69a606d38f9ef9e283c23acafcd0a27c210a38f553613c047e6924482d866b500bc4f0cfe9e02a82da35649caaea444d7db598dd3db11ab6c615b7d16431d0469b8af5d252da011f725042368c678dd9f242b793f1efb442f6543c3efa1f1ad156224a4ff4f5ef7186a758ad1ffce570ca257eb517449fa298749ebb2df6c47f1741e896d8fd786ad590453c563147b76fc8abed42031839a03190e5abcce3403e9e2f44cb4d261e9dd41cf2e55dbd0e18ad7f8186868e2161fafa11d2453950eb496ec3861144bae6d80f9a6c0f158505a346c4a09532678ddb485a145a128391cda15fa1e55a598db030694ad644c1a7eab01ac877a55279ae594497874c232e5e4ac951ae3047ab0843b1e132c3951070b8f6f5a02fb7c6e0f661d4513a56a2c16f00092df2110d000ee6bafdd2fee034016db039903e49a1f9fbe7260b97066232c934729a32e1baec57136b0379d14a725c7e1493ad46575943b527f2443223ddec47abbca95bf30fd6cbbe3d1695bbb193509aa4aabb2282ce395397a82acb48fe7f54f245e44474e967c52c6a0374385606e6a18152f4dbd2edec948bc9908b2094ac2f41d758ad7bbe48522e8688cb2335ecb13320b942e3d2acccd09d6b9991e96c73ccb7651d759eb107228a8f19cff0ccd1bbbfaa8fda8af67b1477c952fd064ee66d360ba2c20720f50e6827218e77864e8021c0da7dfc993e58902c2d731a62bc91e7b7876da3d6554dc485c491415a73f361b9993a54f962d496f19f1764d3d90a6123c8e1e4834e95e7e7f30b4d27c939cfa883493fb2e55f140b4ecbc45f9b79f9eff73a7488b9e6279ff2f9a1feb676e9134f0c56b15c4cc9c4",AppraiseConstants.privateKey);
        System.out.println( result.replace("http://114.116.191.105:8010/ars-web/","http://localhost:8080/ars-web/"));
        result = SmCryptoUtil.sm2Decode("049f69bb9bbb6e2d45f4d4c3cbcb3675c5ce758195d8044b518f684d0ba2bea81d7a4c29a43af0f44ebd165e1551630e10a1e4842f4bdfb720c997a146f8802829be5c6d69b28ac2a4680178c865c6db04ea46472592ca862f1ae5a11aeea5d144b61e31ef1bc525267a9f4dfa49ae3dad6e2f47a7f7181d9d9295ecb8bdd038f3cdbe311efe504696e3a437bba8ea915561b4bbef54af1be35cbfb9805953ce80ee6595da4c67bfd0d708683fad84617c10aee9400861843f6ce050dba86f9ec68877fc34c6bc3a9d20825a1e693305c1c86faeb234a40aecfa6dc60d60cd48e8c429fd38f5de0d8313f173ea6c36e9aa1f68234a9b936e1d989077f161de59204e15f1d474879a72e5906d8b323df9d2ae3a3ff6e42e90404ef40cdd1b0f8ff4a553c53692fca9eeeec2cedf196e630f943eabe57fabee3e35d628a566286b3b6f3058774f5af106af88fa4e82ec6ce387895906297d7ba442c9a269b79f9905c4e82c2952167f6e324cec9a03545906290db97be2ecbd8339e51ba4f5795a5a819d359757cb80207bf0d12cb03c2f6e3f0ecdec6fe606334fb271109ef1e29b3e724e7ccf56ca9a4db1e161eb0b81cccbc1cedaf0183238410a6d2310ed81d6c9e270ae2b8fc72fc7709f4c70011ac1e121325e1c034c11b345bebac758c6ab2b0fd04d9d5f8a391a3f7d276347010139888e31fcbc3a46562a09528525e3e20c9887ac44f1f9d3cf8f41fc8ce693a104d46da326fc5c9b1d9b906f6ae0ddb52277e31869f043dd7c5c415b2694d5e99360f96f244e9b67c623695a8b597712992b909875e7e1594a0db28b8788d080e4c0a9cdeebcb7cb08d509efb9669d63cd277b89b598988d6f56d567a98cbe5fa487768724ff36d4d7fdb4bed7e6e64b908dce234fd66617248a8b367b48995a0d529c0535725bc9aebac9d075f92457db7dd2a5cfa0a9a8544549026256b4aa1e466c4102efffa900c2a9d2aa029e40d0a706220c43ee8c0197f3cce97942910063e6cfbaf5755bd239ea232de1852e899710478289730a67207a5b3cb9ebcd8e40141c751979ebf057981649a5fea14450956a85cf7b687326323741437744194126c5334f9bbac8fc13faf60165730eaf530359439ebd93a91db250c01405d9c732217722d93c8cbc81e5314601d77c83a67d91b91874b7c4859331e93029d37fe2537cde2cdd3e32bb3f94fbe0a2d471486c5f825b81a3",AppraiseConstants.privateKey);
        System.out.println( result.replace("http://114.116.191.105:8010/ars-web/","http://localhost:8080/ars-web/"));
    }
}
