package com.bcxin.ars.service.thirdtrain;


import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.IdcardUtil;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bcxin.ars.dao.ThirdTrainBackgroundDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.ThirdTrainBackgroundPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.ThirdTrainBackground;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.ThirdTrainBackgroundService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.JwtUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 第三方背景筛查Service业务层处理
 *
 * @author lin
 * @date 2021-04-26
 */
@Service
@Transactional(rollbackFor = Exception.class)
//@DataSyncAnnotation(getClazz = ThirdTrainBackground.class, getImportType = ImportType.BATCH, getMethodName = "importBatch")
//@DataSyncOutAnnotation(getClazz = ThirdTrainBackground.class)
public class ThirdTrainBackgroundServiceImpl implements ThirdTrainBackgroundService {

    Logger logger = LoggerFactory.getLogger(ThirdTrainBackgroundServiceImpl.class);

    @Autowired
    private ThirdTrainBackgroundDao thirdTrainBackgroundDao;

    @Autowired
    private IdWorker idWorker;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;

    @Override
    public int delete(ThirdTrainBackground thirdTrainBackground) {
        User currentUser = arsUtil.getCurrentUser();
        thirdTrainBackground.setUpdateTime(new Date());
        thirdTrainBackground.setUpdateBy(currentUser.getUsername());
        return thirdTrainBackgroundDao.delete(thirdTrainBackground);
    }

    @Override
    public int save(ThirdTrainBackground thirdTrainBackground) {
        User currentUser = arsUtil.getCurrentUser();
        if (thirdTrainBackground.getId() == null) {
            thirdTrainBackground.setCreateTime(new Date());
        } else {
            ThirdTrainBackground dbThirdTrainBackground = thirdTrainBackgroundDao.findById(thirdTrainBackground.getId());
            BeanUtils.copyPropertiesIgnore(thirdTrainBackground, dbThirdTrainBackground, true);
            BeanUtils.copyPropertiesIgnore(dbThirdTrainBackground, thirdTrainBackground, false);
        }

        thirdTrainBackground.setActive(true);
        thirdTrainBackground.setUpdateBy(currentUser.getUsername());
        thirdTrainBackground.setUpdateTime(new Date());
        thirdTrainBackground.setUpdateflag(true);
        thirdTrainBackground.setUserid(currentUser.getId());
        thirdTrainBackground.setAreaCode(currentUser.getPolice().getAreacode());
        return thirdTrainBackgroundDao.save(thirdTrainBackground);
    }

    @Override
    public ThirdTrainBackground findById(Long id) {
        return thirdTrainBackgroundDao.findById(id);
    }

    @Override
    public void searchForPage(ThirdTrainBackgroundPageSearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
        thirdTrainBackgroundDao.searchForPage(dto, page);
    }

    @Override
    public void importBatch(List<ThirdTrainBackground> list) {
        List<ThirdTrainBackground> dbList = thirdTrainBackgroundDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updateTime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (ThirdTrainBackground thirdTrainBackground : list) {
                thirdTrainBackground.setUpdateflag(false);
                try {
                    if (!configUtils.isIntranet()) {
                        thirdTrainBackground.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, thirdTrainBackground.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            thirdTrainBackgroundDao.saveBatch(list);
        }
    }

    @Override
    public List<ThirdTrainBackground> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return thirdTrainBackgroundDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<ThirdTrainBackground> findDSOutList(String startDate) {
        return thirdTrainBackgroundDao.findDSOutList(startDate);
    }

    @Override
    public List<ThirdTrainBackground> findByBatchId(List<ThirdTrainBackground> list) {
        return thirdTrainBackgroundDao.findByBatchId(list);
    }

    @Override
    public void updateSelective(ThirdTrainBackground thirdTrainBackground) {
        User currentUser = arsUtil.getCurrentUser();
        thirdTrainBackground.setUpdateTime(new Date());
        thirdTrainBackground.setUpdateBy(currentUser.getUsername());
        thirdTrainBackgroundDao.updateSelective(thirdTrainBackground);
    }

    @Override
    public AjaxResult commitPeopleBackgroundScreening(String thirdTrainBackgrounds) {
        AjaxResult ajaxResult = new AjaxResult();
        String subject = JwtUtil.parseJWT(thirdTrainBackgrounds).getSubject();
        List<ThirdTrainBackground> thirdTrainBackgroundList = JSON.parseArray(subject, ThirdTrainBackground.class);

        Map<String, Object> resultData = Maps.newHashMap();
        User currentUser = arsUtil.getCurrentUser();
        Long userid = currentUser.getId();

        List<ThirdTrainBackground> validParamSuccess = Lists.newArrayList();
        Date now = new Date();
        // 校验参数
        for (ThirdTrainBackground thirdTrainBackground : thirdTrainBackgroundList) {
            // 参数校验不通过 || 数据库唯一性不通过
            if (!validParams(thirdTrainBackground) || thirdTrainBackgroundDao.selectCount(thirdTrainBackground) > 0) {
                resultData.put(thirdTrainBackground.getIdNumber(), false);
            } else {
                // 设置userId
                thirdTrainBackground.setUserid(userid);
                thirdTrainBackground.setUpdateBy(currentUser.getUsername());
                thirdTrainBackground.setActive(true);
                thirdTrainBackground.setCreateTime(now);
                thirdTrainBackground.setUpdateTime(now);
                thirdTrainBackground.setId(idWorker.nextId());
                validParamSuccess.add(thirdTrainBackground);
            }
        }
        if (CollectionUtil.isEmpty(validParamSuccess)) {
            ajaxResult.setData(JwtUtil.createJWT(JSON.toJSONString(resultData)));
            ajaxResult.setSuccessful(true);
            return ajaxResult;
        }
        // 保存操作
        thirdTrainBackgroundDao.saveBatch(validParamSuccess);
        validParamSuccess.forEach(item -> resultData.put(item.getIdNumber(), true));
        ajaxResult.setData(JwtUtil.createJWT(JSON.toJSONString(resultData)));
        ajaxResult.setSuccessful(true);
        return ajaxResult;
    }

    @Override
    public AjaxResult listPeopleBackgroundScreening(String thirdTrainBackground) {
        AjaxResult ajaxResult = new AjaxResult();
        String subject = JwtUtil.parseJWT(thirdTrainBackground).getSubject();
        ThirdTrainBackground thirdTrainBackgroundSearch = JSON.parseObject(subject, ThirdTrainBackground.class);

        User currentUser = arsUtil.getCurrentUser();

        thirdTrainBackgroundSearch.setUserid(currentUser.getId());
        // 查询
        List<ThirdTrainBackground> result = thirdTrainBackgroundDao.listPeopleBackgroundScreening(thirdTrainBackgroundSearch);
        Map<String, Object> resultData = Maps.newHashMap();
        result.forEach(item -> resultData.put(item.getIdNumber(), item.getScreeningResults()));
        ajaxResult.setSuccessful(true);
        // fastjson默认不转map的null值, 需要参数
        ajaxResult.setData(JwtUtil.createJWT(JSON.toJSONString(resultData, SerializerFeature.WriteMapNullValue)));
        return ajaxResult;
    }

    private boolean validParams(ThirdTrainBackground thirdTrainBackground) {
        String businessId = thirdTrainBackground.getBusinessId();
        String businessType = thirdTrainBackground.getBusinessType();
        String idNumber = thirdTrainBackground.getIdNumber();
        String realName = thirdTrainBackground.getRealName();
        if (StringUtil.isBlank(businessId)) {
            return false;
        }
        if (StringUtil.isBlank(businessType)) {
            return false;
        }
        if (StringUtil.isBlank(idNumber)) {
            return false;
        }
        if (!IdcardUtil.isValidCard(idNumber)) {
            return false;
        }
        if (StringUtil.isBlank(realName)) {
            return false;
        }
        return true;
    }
}
