package com.bcxin.ars.service.task.impl;


import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.task.ComTempTaskPerDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.ComTempTaskPerPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.task.ComTempTask;
import com.bcxin.ars.model.task.ComTempTaskPer;
import com.bcxin.ars.service.task.ComTempTaskPerService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

import java.util.List;

/**
 * 临保任务人员Service业务层处理
 * 
 * @author lin
 * @date 2021-02-01
 */
@Service
@Transactional
@DataSyncAnnotation(getClazz = ComTempTaskPer.class, getImportType = ImportType.BATCH, getMethodName = "importBatch")
public class ComTempTaskPerServiceImpl implements ComTempTaskPerService {
    
    Logger logger = LoggerFactory.getLogger(ComTempTaskPerServiceImpl.class);
    
    @Autowired
    private ComTempTaskPerDao comTempTaskPerDao;


    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;

    @Override
    public int delete(ComTempTaskPer comTempTaskPer) {
        User currentUser = arsUtil.getCurrentUser();
        comTempTaskPer.setUpdateTime(new Date());
        comTempTaskPer.setUpdateBy(currentUser.getUsername());
        return comTempTaskPerDao.delete(comTempTaskPer);
    }

    @Override
    public int save(ComTempTaskPer comTempTaskPer) {
        User currentUser = arsUtil.getCurrentUser();
        if(comTempTaskPer.getId() == null){
            comTempTaskPer.setCreateTime(new Date());
        }else{
            ComTempTaskPer dbComTempTaskPer = comTempTaskPerDao.findById(comTempTaskPer.getId());
            BeanUtils.copyPropertiesIgnore(comTempTaskPer,dbComTempTaskPer,true);
            BeanUtils.copyPropertiesIgnore(dbComTempTaskPer,comTempTaskPer,false);
        }

        comTempTaskPer.setActive(true);
        comTempTaskPer.setUpdateBy(currentUser.getUsername());
        comTempTaskPer.setUpdateTime(new Date());
        comTempTaskPer.setUpdateflag(true);
        comTempTaskPer.setUserId(currentUser.getId());
        comTempTaskPer.setAreaCode(currentUser.getPolice().getAreacode());
        return comTempTaskPerDao.save(comTempTaskPer);
    }

    @Override
    public ComTempTaskPer findById(Long id) {
        return comTempTaskPerDao.findById(id);
    }

    @Override
    public void searchForPage(ComTempTaskPerPageSearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
        comTempTaskPerDao.searchForPage(dto,page);
    }

    @Override
    public void importBatch(List<ComTempTaskPer> list) {
        List<ComTempTaskPer> dbList = comTempTaskPerDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (ComTempTaskPer comTempTaskPer : list) {
                comTempTaskPer.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        comTempTaskPer.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, comTempTaskPer.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            comTempTaskPerDao.saveBatch(list);
        }
    }

    @Override
    public List<ComTempTaskPer> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return comTempTaskPerDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<ComTempTaskPer> findDSOutList(String startDate) {
        return comTempTaskPerDao.findDSOutList(startDate);
    }

    @Override
    public List<ComTempTaskPer> findByBatchId(List<ComTempTaskPer> list) {
        return comTempTaskPerDao.findByBatchId(list);
    }

    @Override
    public void updateSelective(ComTempTaskPer comTempTaskPer) {
        User currentUser = arsUtil.getCurrentUser();
        comTempTaskPer.setUpdateTime(new Date());
        comTempTaskPer.setUpdateBy(currentUser.getUsername());
        comTempTaskPerDao.updateSelective(comTempTaskPer);
    }
}
