/*
 * Copyright (c) 2015 xuerdongcom@126.com All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 */
package com.bcxin.ars.service.sys.impl;

import com.bcxin.ars.dao.sys.SyscodeDAO;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sys.SyscodeSearchDTO;
import com.bcxin.ars.model.sys.Syscode;
import com.bcxin.ars.service.sys.SyscodeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author xuerdong
 * @since 1.1
 */
@Service
public class SyscodeServiceImpl implements SyscodeService {
	@Autowired
	private SyscodeDAO syscodeDAO;
	@Override
	public Map findAll() {
		//返回的数据对象
		Map<String,Map<String,String>> data = new HashMap<>();
		//获取所有编码列表
		List<Syscode> codelist  = syscodeDAO.findAll();
		String codetype = "";
		Map<String,String> codemap = new HashMap<String,String>();
		for (Syscode code :
				codelist) {
			//判断与上一次编码是否一致，如果一致则加入map，不一致则把map放在data并新建一个
			if(!codetype.equals(code.getCodetype()) && !"".equals(codetype)){
				data.put(codetype,codemap);
				codemap = new HashMap<String,String>();
				codemap.put(code.getCodevalue(),code.getCodemean());
				codetype = code.getCodetype();
			}else{
				codemap.put(code.getCodevalue(),code.getCodemean());
				codetype =  code.getCodetype();
			}
		}
		//最后一个编码对象
		data.put(codetype,codemap);
		return data;
	}

	@Override
	public void save(Syscode code) {
		syscodeDAO.insert(code);
	}

	@Override
	public void update(Syscode code) {
		syscodeDAO.updateByPrimaryKey(code);
	}

	@Override
	public void delete(Syscode code) {
		syscodeDAO.deleteByPrimaryKey(code);
	}

	@Override
	public Syscode selectByPrimaryKey(String codetype, String codevalue) {
		return syscodeDAO.selectByPrimaryKey(codetype,codevalue);
	}

}