package com.bcxin.ars.service.sys.impl;

import com.bcxin.ars.dao.sys.SysdictDAO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sys.SysDictDto;
import com.bcxin.ars.model.sys.Sysdict;
import com.bcxin.ars.service.sys.SysDictService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
@Service
@Transactional
//@DataSyncAnnotation(getClazz = Sysdict.class,getMethodName = "importBatch",getImportType = ImportType.BATCH)
//@DataSyncOutAnnotation(getClazz = Sysdict.class,getImportType = ImportType.BATCH)
public class SysDictServiceImpl implements SysDictService {
    @Autowired
    private SysdictDAO dictDao;
    @Autowired
    private ConfigUtils configUtils;
    @Override
    public List findAll() {
        return dictDao.findAll();
    }

    /**
     * 查询所有的码表
     * @param sysDictDto
     * @param page
     */
    @Override
    public void search(SysDictDto sysDictDto, AjaxPageResponse page) {
        dictDao.search(sysDictDto,page);
    }

    @Override
    public Sysdict findById(Long id) {
        return dictDao.findById(id);
    }

    @Override
    public void save(Sysdict sysdict) {
        //更新标志设置
        sysdict.setUpdateflag(true);
        sysdict.setUpdateTime(new Date());
        dictDao.save(sysdict);
    }
    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    public List<Sysdict> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return dictDao.searchForDataSynchronization(searchDto);
    }
    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    public List<Sysdict> findDSOutList(String startDate) {
        return dictDao.findDSOutList(startDate);
    }

    /**
     * 内网数据同步到外网
     * @param list
     */
    public void importBatch(List<Sysdict> list) {
        List<Sysdict> dbList = dictDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (Sysdict sysdict : list) {
                sysdict.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        sysdict.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, sysdict.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            dictDao.saveBatch(list);
        }
    }
}
