package com.bcxin.ars.service.sys.impl;

import com.bcxin.ars.dao.subsidy.ImportConfigDaoAop;
import com.bcxin.ars.dao.sys.SubsidyComparisonDao;
import com.bcxin.ars.dto.sys.SubsidyComparisonDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.SubsidyComparison;
import com.bcxin.ars.service.sys.SubsidyComparisonService;
import com.bcxin.ars.service.util.ArsUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.Date;

/**
 * @author  yyx
 * @date 2020-05-18
 * @desc 人社比对结果流向配置实现层层
 */
@Service
@Transactional
public class SubsidyComparisonServiceImpl implements SubsidyComparisonService {

    @Autowired
    private SubsidyComparisonDao subsidyComparisonDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ImportConfigDaoAop importConfigDaoAop;

    @Override
    public SubsidyComparison findById(Long id) {
        return subsidyComparisonDao.findById(id);
    }

    @Override
    public void search(SubsidyComparisonDto subsidyComparisonDto, AjaxPageResponse<SubsidyComparison> page) {
        subsidyComparisonDao.search(subsidyComparisonDto,page);
    }

    @Override
    public void save(SubsidyComparison subsidyComparison) {

        User currentUser = arsUtil.getCurrentUser();
        if(subsidyComparison.getId() == null){
            subsidyComparison.setCreateTime(new Date());
        }
        subsidyComparison.setActive(true);
        subsidyComparison.setUpdateBy(currentUser.getUsername());
        subsidyComparison.setUpdateTime(new Date());
        importConfigDaoAop.saveComparison(subsidyComparison);
    }
}
