package com.bcxin.ars.service.sx.impl;

import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sx.AuthLoginUser;
import com.bcxin.ars.model.sx.AuthUserInfo;
import com.bcxin.ars.service.LoginLogService;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.service.gxhlwWeb.impl.gxhlwWebServiceImpl;
import com.bcxin.ars.service.sx.AuthorizeService;
import com.bcxin.ars.service.sys.RegisterpersonService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.*;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;

@Service
@Transactional
public class AuthorizeServiceImpl implements AuthorizeService {

    /***
     * 日志
     */
    private static final  Logger logger = LoggerFactory.getLogger(gxhlwWebServiceImpl.class);
    @Autowired
    private RegisterpersonService registerpersonService;
    @Autowired
    private UserService userService;
    @Autowired
    private ArsUtil arsUtil;
    @Value("${login-timeout}")
    private int loginTimeout = 10;
    @Autowired
    private LoginLogService loginLogService;
    @Autowired
    private UserDao userDao;
    @Override
    public AjaxResult login(AuthLoginUser loginUser,HttpServletRequest request) {
        AjaxResult ajaxResult = new AjaxResult();
        //查询是否存在sql中 不存在添加
        User user = new User();
        user.setIdNumber(loginUser.getCredentials_number());
        user.setPhone(loginUser.getMobile_telephone());
        user.setPassword(loginUser.getMobile_telephone().substring(loginUser.getMobile_telephone().length()-6,loginUser.getMobile_telephone().length()));
        user.setRealname(loginUser.getUserName());
        user.setUsername(loginUser.getMobile_telephone());
        List<User> data = userDao.searchByDto(user);
        //如果不存在该用户 帮其注册
        if (data.size()==0){
            //注册
            AjaxResult userAjaxResult = registerpersonService.SXNWregister(user);
            //注册失败
            if (!userAjaxResult.isSuccessful()){
                ajaxResult.setState(Constants.STATUS_ERROR);
                ajaxResult.setMsg("注册失败");
                throw new ArsException("注册失败！");
            }
            //如果自动注册则设置手机号码后六位
            user.setPassword(loginUser.getMobile_telephone().substring(loginUser.getMobile_telephone().length()-6,loginUser.getMobile_telephone().length()));
        }else{
            //获取已经存在的用户信息
            user = data.get(0);
        }
        //登录
        AjaxResult loginAjaxResult = new AjaxResult();
        try {
            loginAjaxResult = webLogin(user.getUsername(),user.getPassword(),Constants.PLATFORM_NATURAL_PERSON,request);
        } catch (Exception e) {
            //登录失败
            logger.error(e.getMessage(), e);
            ajaxResult.setState(Constants.STATUS_ERROR);
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("登录失败");
        }
        if (!loginAjaxResult.isSuccessful()){
            ajaxResult.setState(Constants.STATUS_ERROR);
            ajaxResult.setMsg("登录失败");
            ajaxResult.setSuccessful(false);
            throw new ArsException("登录失败！");
        }
        //验证成功，登录成功
        ajaxResult.setState(Constants.STATUS_SUCCESS);
        ajaxResult.setSuccessful(true);
        return ajaxResult;
    }

    /**
     * 登陆
     * @param username 用户名
     * @param password 密码
     * @param platform 角色
     * @return
     * @throws Exception
     */
    public AjaxResult webLogin(String username, String password,Integer platform,HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            UsernamePasswordToken token = new UsernamePasswordToken(username, password,Constants.SXNWCode);
            Subject currentUser = SecurityUtils.getSubject();
            token.setRememberMe(false);
            try {
                currentUser.login(token);
            } catch (AuthenticationException e) {
                logger.error(e.getMessage(), e);
                result.setSuccessful(false);
                result.setMsg("用户名/密码错误");
            }
            //判断是否登录成功！
            if(currentUser.isAuthenticated()) {
                Session session = currentUser.getSession();
                User user = userService.findByUsername(username,platform.toString());
                System.out.println("当前登录用户是：" + user.getUsername());
                //更新一下登陆状态
                user.setLoginstate(1);
                //登录次数+1
                if (user.getLoginNum() != null) {
                    user.setLoginNum(user.getLoginNum() + 1);
                } else {
                    user.setLoginNum(1);
                }
                //登录时间为当前时间
                user.setLoginDate(new Date());
                userService.updateLoginState(user);
                //sessionID
                user.setSessionId(session.getId().toString());
                //设置超时时间
                arsUtil.setCurrentUser(user, 1000 * 120 * loginTimeout);
                result.setData(user);
                result.setSuccessful(true);
                loginLogService.logIn(request);
            }
        } catch (UnknownAccountException e) {
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg("用户名/密码错误");
        } catch (IncorrectCredentialsException e) {
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg("用户名/密码错误");
        } catch (ExcessiveAttemptsException e) {
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg("登录失败多次，账户锁定10分钟");
        } catch (AuthenticationException e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
}
