package com.bcxin.ars.service.statistics;

import cn.hutool.core.collection.CollUtil;
import com.bcxin.ars.dao.statistics.SecurityStatisticsDao;
import com.bcxin.ars.dto.TreeView;
import com.bcxin.ars.dto.statistics.EchartMapData;
import com.bcxin.ars.dto.statistics.PageResultDTO;
import com.bcxin.ars.dto.statistics.ParamDTO;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.service.util.SysAreaUtil;
import com.bcxin.ars.util.StringUtil;
import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;


/**
 * <p>
 * 业务情况统计（保安员，保安公司）
 * </p>
 *
 * @author 罗鹏
 * @date 2018/4/16
 */
@Service
public class SecurityStatisticsServiceImpl implements SecurityStatisticsService {
	
	@Autowired
	private SecurityStatisticsDao securityStatisticsDao;

	@Autowired
	private SysAreaUtil sysAreaUtil;

	//保安公司分析，汇总数据
	@Override
	public Map securityCompanySummary(ParamDTO paramDTO){
		if (StringUtil.isEmpty(paramDTO.getAreaCode())) {
			return Maps.newHashMap();
		}
		paramDTO.setAreaCode(subAreaCode(paramDTO.getAreaCode()));
		return securityStatisticsDao.getCompanyGeneral(paramDTO);
	}

	//保安公司分析，详细数据
	@Override
	public PageResultDTO securityCompanyDetail(ParamDTO paramDTO){
		PageResultDTO resultDTO = new PageResultDTO();
		paramAreaCode(paramDTO);
		List<Map> list = securityStatisticsDao.getCompanyNew(paramDTO);
		resultDTO.setAllData(list);
		List<List<Map>> pageList = CollUtil.split(list, paramDTO.getNumPerPage());
		resultDTO.setPageData(pageList.get(paramDTO.getPageNum()));
		resultDTO.setTotalCount(list.size());
		return resultDTO;
	}

	//保安公司区域分析
	@Override
	public List<Map> securityCompanyArea(ParamDTO paramDTO){
		if (StringUtil.isEmpty(paramDTO.getAreaCode())) {
			return Lists.newArrayList();
		}
		paramDTO.setAreaCode(subAreaCode(paramDTO.getAreaCode()));
		List<Map> mapList = securityStatisticsDao.getCompanyArea(paramDTO);
		return mapList;
	}

	/****************************************** 保安员页面 **************************/
	/* 保安员汇总 */
	@Override
	public Map securityPersonSummary(ParamDTO paramDTO){
		if (StringUtil.isEmpty(paramDTO.getAreaCode())) {
			return Maps.newHashMap();
		}
		paramDTO.setAreaCode(subAreaCode(paramDTO.getAreaCode()));
		return securityStatisticsDao.getPersonDetail(paramDTO);
	}

	/*新增及离职分析*/
	@Override
	public PageResultDTO securityPersonDetail(ParamDTO paramDTO){
		PageResultDTO resultDTO = new PageResultDTO();
		paramAreaCode(paramDTO);
		List<Map> list = securityStatisticsDao.getPersonZjAnalyse(paramDTO);
		resultDTO.setAllData(list);
		List<List<Map>> pageList = CollUtil.split(list, paramDTO.getNumPerPage());
		resultDTO.setPageData(pageList.get(paramDTO.getPageNum()));
		resultDTO.setTotalCount(list.size());
		return resultDTO;
	}


	/*持证人员分析*/
	@Override
	public List<EchartMapData> holdCerAnalyse(ParamDTO paramDTO){
		paramAreaCode(paramDTO);
		List<EchartMapData> list = Lists.newArrayList();
		Map resultMap = securityStatisticsDao.getHoldCerAnalyse(paramDTO);
		for (Object key : resultMap.keySet()){
			EchartMapData data = new EchartMapData();
			if ("bayzgzs".equals(key)) {
				data.setName("保安员资格证");
			} else if ("cjbays".equals(key)) {
				data.setName("初级保安员");
			} else if ("zjbays".equals(key)) {
				data.setName("中级保安员");
			} else if ("gjbays".equals(key)) {
				data.setName("高级保安员");
			} else if ("bass".equals(key)) {
				data.setName("保安师");
			} else if ("gjbass".equals(key)) {
				data.setName("高级保安师");
			} else if ("wzrys".equals(key)) {
				data.setName("无证人员");
			}
			data.setValue(Integer.parseInt(resultMap.get(key).toString()));
			list.add(data);
		}
		return list;
	}


	/*实名认证分析*/
	@Override
	public PageResultDTO authAnalyse(ParamDTO paramDTO){
		PageResultDTO resultDTO = new PageResultDTO();
		paramAreaCode(paramDTO);
		List<Map> list = securityStatisticsDao.getAuthAnalyse(paramDTO);
		resultDTO.setAllData(list);
		List<List<Map>> pageList = CollUtil.split(list, paramDTO.getNumPerPage());
		resultDTO.setPageData(pageList.get(paramDTO.getPageNum()));
		resultDTO.setTotalCount(list.size());
		return resultDTO;
	}


	/* 保安服务公司汇总 */
	@Override
	public Map companySummary(ParamDTO paramDTO){
		if (StringUtil.isEmpty(paramDTO.getAreaCode())) {
			return Maps.newHashMap();
		}
		paramDTO.setAreaCode(subAreaCode(paramDTO.getAreaCode()));
		return securityStatisticsDao.getCompanyStatistics(paramDTO);
	}


	/* 保安服务公司汇总 */
	@Override
	public PageResult companyDetail(ParamDTO paramDTO){
		paramDTO.setAreaCode(subAreaCode(paramDTO.getAreaCode()));
		List<Map> list = securityStatisticsDao.getCompanyList(paramDTO);
		List<List<Map>> pageList = CollUtil.split(list, paramDTO.getLimit());
		return new PageResult(list.size(),pageList.get(paramDTO.getOffset()/paramDTO.getLimit()));
	}

	/**
	 * 处理参数中的areaCode
	 * @return
	 */
	private void paramAreaCode(ParamDTO paramDTO){
		if (StringUtil.isNotEmpty(paramDTO.getArea())){
			paramDTO.setAreaCode(paramDTO.getArea());
			return;
		}
		if (StringUtil.isNotEmpty(paramDTO.getCity())) {
			paramDTO.setAreaCode(paramDTO.getCity().substring(0,4));
			return;
		}
		if (StringUtil.isNotEmpty(paramDTO.getProvince())) {
			paramDTO.setAreaCode(paramDTO.getProvince().substring(0,2));
			return;
		}
	}


	/**
	 * 截取areaCode
	 * @param areaCode
	 * @return
	 */
	private String subAreaCode(String areaCode){
		TreeView treeView = sysAreaUtil.getRegionByCode(areaCode);
		/* 省 */
		if ("1".equals(treeView.getLevel())) {
			return areaCode.substring(0,2);
		}
		/* 市 */
		else if ("2".equals(treeView.getLevel())) {
			return areaCode.substring(0,4);
		}
		return areaCode;
	}
}
