package com.bcxin.ars.service.statistics;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.ProblemPersonDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.appeal.AppealDao;
import com.bcxin.ars.dao.msg.NewsnoticeCompanyDao;
import com.bcxin.ars.dao.sb.*;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dto.ProblemPersonSearchDto;
import com.bcxin.ars.dto.appeal.AppealSearchDto;
import com.bcxin.ars.dto.page.ApprovalPageSearchDto;
import com.bcxin.ars.dto.page.PersonPageSearchDto;
import com.bcxin.ars.dto.sb.PersoncertificateSearchDto;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.PoliceRole;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.service.sxzw.impl.SxZwServiceImpl;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * @author linqinglin
 * @date 2018/08/28 0028 14:14
 */
@Service
@Transactional
public class PoliceNoticeStatisticsServiceImpl implements PoliceNoticeStatisticsService {

    /***
     * 日志
     */
    private static final Logger logger = LoggerFactory.getLogger(SxZwServiceImpl.class);
    @Autowired
    private ApprovalDAO approvalDAO;

    @Autowired
    private PoliceDao policeDao;

    @Autowired
    private SecurityPersonDao securityPersonDao;

    @Autowired
    private GradePersonDao gradePersonDao;

    @Autowired
    private ProblemPersonDao problemPersonDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private NewsnoticeCompanyDao newsnoticeCompanyDao;
    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private PersoncertificateDao personcertificateDao;

    @Autowired
    private TraincompanyapplyDao traincompanyapplyDao;

    @Autowired
    private SponsorlicenseDao sponsorlicenseDao;

    @Autowired
    private UserService userService;

    @Autowired
    private GradeClassDao gradeClassDao;

    @Autowired
    private AppealDao appealDao;

    @Override
    public JSONObject getPoliceNotice(Map<Object, Object> p){
        User currentUser = arsUtil.getCurrentUser();
        PersoncertificateSearchDto searchDto = new PersoncertificateSearchDto();

        ApprovalPageSearchDto appSearchDto = new ApprovalPageSearchDto();
        appSearchDto.setUserid(currentUser.getId());
        appSearchDto.setSearchType("001");
        //角色列表
        List<PoliceRole> roles = currentUser.getRoles();
        if (roles != null && roles.size() > 0) {
            p.put("roles", roles);
        }
        //判断是否为民警
        if (currentUser.getPoliceman() != null && currentUser.getPoliceman()) {
            p.put("policeid", currentUser.getId());
            p.put("taskDefinitionKey", Constants.ACTIVITI_POLICEMAN);
        }
        //机构信息
        Police police = policeDao.findById(currentUser.getOrgid());
        //判断是否为派出所
        if (police.getOrgtype() != null && police.getOrgtype().equals("4")) {
            p.put("orgid", police.getId());
            searchDto.setOrgid(police.getId());

        }
        p.put("orgtype", police.getOrgtype());
        //机构信息
        String areacode = police.getAreacode();
        if (p.get("areaCode") != null) {
            areacode = String.valueOf(p.get("areaCode"));
        }
        //区域过滤
        if (StringUtil.isNotEmpty(areacode)) {
            if (areacode.endsWith("0000")) {//省
                p.put("areaCode", areacode.substring(0, 2) + "____");
                p.put("district", areacode.substring(0, 2) + "____");
                searchDto.setDistrict(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {//市
                p.put("areaCode", areacode.substring(0, 4) + "__");
                p.put("district", areacode.substring(0, 4) + "__");
                searchDto.setDistrict(areacode.substring(0, 4) + "__");
            } else {//区
                p.put("areaCode", areacode);
                p.put("district", areacode);
                searchDto.setDistrict(areacode);
            }
        }
        searchDto.setPlatform(currentUser.getPlatform().toString());
        p.put("platform", currentUser.getPlatform());
        //业务类型权限
        if (currentUser.getUserBusinessTypeList() != null && currentUser.getUserBusinessTypeList().size() > 0) {
            p.put("userBusinessTypeList", currentUser.getUserBusinessTypeList());
        }

        JSONObject result = new JSONObject();

        Integer approvalCount = 0;
        Long unFingercardCount = 0L;
        Long unPayCount = 0L;
        Integer unReplyComCount = 0;
        Integer unUploadComCount = 0;
        Integer unCardComCount = 0;
        Integer unReplyTrainCount = 0;
        Integer unUploadTrainCount = 0;
        Integer unCardTrainCount = 0;
        Integer unPrintCount = 0;
        Long gradeClassUnApprovalCount = 0L;
        //未完成
        searchDto.setFinished("002");
        //指纹待录入
        searchDto.setFingercardState("0");
        try {
            unFingercardCount = personcertificateDao.queryTableCount(searchDto);
        }catch (Exception e){
            logger.error(e.getMessage(),e);
        }
        //未缴费确认
        // 指纹已录入未缴费
        searchDto.setFingercardState("3");
        searchDto.setFeeState("0");
        try {
            unPayCount = personcertificateDao.queryTableCount(searchDto);
        }catch (Exception e){
            logger.error(e.getMessage(),e);
        }

        //是否需要批复意见 默认需要
        Config isReplyConfig =configUtils.getConfigByKey(Constants.IS_REPLY);
        //新审批需要此参数
        p.put("userid", currentUser.getId());
        try {
            approvalDAO.searchForPage_count(appSearchDto);
            approvalCount = approvalDAO.searchForPage_count(appSearchDto).intValue();
        }catch (Exception e){
            logger.error(e.getMessage(),e);
        }

        //后面查询无须userid清空
        p.put("userid", null);
        //处长角色
        if( userService.checkRole(currentUser,p.get("czjsid"))) {
            try {
                //待批复（保安公司）统计类型totalType： 001
                p.put("totalType", "001");
                unReplyComCount = sponsorlicenseDao.countSponsorlicenseList(p);

                //待批复（培训单位）统计类型totalType： 001
                p.put("totalType", "001");
                unReplyTrainCount = traincompanyapplyDao.countTraincompanyapplyList(p);
            }catch (Exception e){
                logger.error(e.getMessage(),e);
            }

        }

        //民警
        if(null!=currentUser.getPoliceman()) {
            try {
                //根据配置是否需要上传文件
                if(isReplyConfig==null || (null!=isReplyConfig && Constants.IS_REPLY_YES.equals(isReplyConfig.getValue()))){
                    //待上传（保安公司）统计类型totalType： 002
                    p.put("totalType", "002");
                    unUploadComCount = sponsorlicenseDao.countSponsorlicenseList(p);

                    //待上传（培训单位）统计类型totalType： 002
                    p.put("totalType","002");
                    unUploadTrainCount = traincompanyapplyDao.countTraincompanyapplyList(p);
                }
                //是否需要上传文件导致查询条件不同
                if(isReplyConfig==null || (null!=isReplyConfig && Constants.IS_REPLY_YES.equals(isReplyConfig.getValue()))){
                    //待制证（保安公司需要批复文件）统计类型totalType： 003
                    p.put("totalType", "003");
                    unCardComCount = sponsorlicenseDao.countSponsorlicenseList(p);
                    //待制证（培训单位需要批复文件）统计类型totalType： 003
                    p.put("totalType", "003");
                    unCardTrainCount = traincompanyapplyDao.countTraincompanyapplyList(p);
                }else{
                    //待制证（保安公司不需要批复文件）统计类型totalType： 004
                    p.put("totalType", "004");
                    unCardComCount = sponsorlicenseDao.countSponsorlicenseList(p);
                    //待制证（培训单位不需要批复文件）统计类型totalType： 004
                    p.put("totalType", "004");
                    unCardTrainCount = traincompanyapplyDao.countTraincompanyapplyList(p);
                }

            }catch (Exception e){
                logger.error(e.getMessage(),e);
            }


        }
        try {
            if (!Constants.BEIJING.equals(configUtils.getCurrentNative())) {
                //待打印(保安员证)
                //有照片
                p.put("havephoto", "1");
                //未打印
                p.put("isprint", "0");
                unPrintCount = personcertificateDao.countPrintList(p);
            } else {
                //未打印
                //不是历史数据
                p.put("isOldData", "0");
                //未打印
                p.put("isprint", "0");
                unPrintCount = personcertificateDao.countPrintList(p);
            }
        }catch (Exception e){
            logger.error(e.getMessage(),e);
        }
        //问题人员个数
        ProblemPersonSearchDto problemPersonSearchDto = new ProblemPersonSearchDto();

        if (areacode.endsWith("0000")) {
            problemPersonSearchDto.setAreaCode(areacode.substring(0, 2) + "____");
        } else if (areacode.endsWith("00")) {
            problemPersonSearchDto.setAreaCode(areacode.substring(0, 4) + "__");
        } else {// 区
            problemPersonSearchDto.setAreaCode(areacode);
        }
        //判断是否为派出所
        if(Constants.POLICE_ORGTYPE_PCS.equals(police.getOrgtype())){
            problemPersonSearchDto.setOrgId(police.getId());
        }

        //前科
        try {
            //前科
            problemPersonSearchDto.setPersonType(Constants.PERSONTYPE_CRIMINAL);
            result.put("problemCount",problemPersonDao.getProblemTotalCount(problemPersonSearchDto));
        }catch (Exception e){
            logger.error(e.getMessage(),e);
            result.put("problemCount", "0");
        }

        //在逃人员
        try {
            problemPersonSearchDto.setPersonType(Constants.PERSONTYPE_LARGE);
            result.put("atLargePersonCount",problemPersonDao.getProblemTotalCount(problemPersonSearchDto));
        }catch (Exception e){
            logger.error(e.getMessage(),e);
            result.put("atLargePersonCount", "0");
        }
        //信息有误人员
        try {
            problemPersonSearchDto.setPersonType(Constants.PERSONTYPE_INFO);
            result.put("errorInfoPersonCount",problemPersonDao.getProblemTotalCount(problemPersonSearchDto));
        }catch (Exception e){
            logger.error(e.getMessage(),e);
            result.put("errorInfoPersonCount", "0");
        }

        //未持证人员
        Config daysConfig = configUtils.getConfigByKey(Constants.PERSON_OUTTIME);
        if(daysConfig ==null) {
            daysConfig  = new Config();
            daysConfig.setValue(Constants.PERSON_OUTTIME_DEFAULT);
        }
        PersonPageSearchDto personPageSearchDto = new PersonPageSearchDto();
        personPageSearchDto.setStartDay(Long.parseLong(daysConfig.getValue()));
        arsUtil.setPoliceSearch(personPageSearchDto);
        try {
            //消息未读个数
            result.put("unReadNewsCount",  newsnoticeCompanyDao.countUnread(currentUser.getId()));
        }catch (Exception e){
            logger.error(e.getMessage(),e);
            result.put("unReadNewsCount", "0");
        }
        try {
            AppealSearchDto appealSearchDto = new AppealSearchDto();
            arsUtil.setPoliceSearch(appealSearchDto);
            appealSearchDto.setAppealState(Constants.APPEAL_PASS);
            result.put("appealCount", appealDao.appealCount(appealSearchDto));
        }catch (Exception e){
            logger.error(e.getMessage(),e);
            result.put("appealCount", "0");
        }
        //超过20天未持证人员
        //try {
        //    result.put("outTimeListCount", securityPersonDao.getOutTimeListCount(personPageSearchDto));
        //}catch (Exception e){
        //    logger.error(e.getMessage(),e);
        //    result.put("outTimeListCount", "0");
        //}


        result.put("approvalCount",approvalCount);
        result.put("unFingercardCount",unFingercardCount);
        result.put("unPayCount",unPayCount);
        result.put("unReplyComCount",unReplyComCount);
        result.put("unUploadComCount",unUploadComCount);
        result.put("unCardComCount",unCardComCount);
        result.put("unReplyTrainCount",unReplyTrainCount);
        result.put("unUploadTrainCount",unUploadTrainCount);
        result.put("unCardTrainCount",unCardTrainCount);
        result.put("unPrintCount",unPrintCount);
        result.put("gradeClassUnApprovalCount",gradeClassDao.queryUnApprovalCount());

        return result;
    }
}
