package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.sb.YearReportInsuranceDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.YearReportInsuranceSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.YearReportInsurance;
import com.bcxin.ars.service.sb.YearReportInsuranceService;
import com.bcxin.ars.service.util.ArsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = YearReportInsurance.class)
public class YearReportInsuranceServiceImpl implements YearReportInsuranceService {

	@Autowired
	private YearReportInsuranceDao yearReportInsuranceDao;

	@Autowired
	private SecurityCompanyDao companyDao;


	@Autowired
	private ArsUtil arsUtil;

	/**
	 * 保存或更新
	 * @param yearReportInsurance
	 */
	@Override
	public void saveOrUpdate(YearReportInsurance yearReportInsurance) {
        User user = arsUtil.getCurrentUser();
		//判断是否存在，如果存在则为更新否则为保存
		YearReportInsurance dbYearReportInsurance = yearReportInsuranceDao.findById(yearReportInsurance.getId());
		if(dbYearReportInsurance != null) {
			//设置修改时间
			dbYearReportInsurance.setUpdateTime(new Date());
			//设置修改者
			dbYearReportInsurance.setUpdateBy(user.getRealname());
			//如果不为空，则更新相应字段的值
			if(!StringUtils.isEmpty(yearReportInsurance.getInsurance_company())) {
				dbYearReportInsurance.setInsurance_company(yearReportInsurance.getInsurance_company());
			}
			if(!StringUtils.isEmpty(yearReportInsurance.getInsurance_product())) {
				dbYearReportInsurance.setInsurance_product(yearReportInsurance.getInsurance_product());
			}
			if(!StringUtils.isEmpty(yearReportInsurance.getInsured_num())) {
				dbYearReportInsurance.setInsured_num(yearReportInsurance.getInsured_num());
			}
			if(!StringUtils.isEmpty(yearReportInsurance.getPremium_person())) {
				dbYearReportInsurance.setPremium_person(yearReportInsurance.getPremium_person());
			}
			if(!StringUtils.isEmpty(yearReportInsurance.getProtection_date())) {
				dbYearReportInsurance.setProtection_date(yearReportInsurance.getProtection_date());
			}

			yearReportInsuranceDao.update(dbYearReportInsurance);
		}else{
			//修改时间，创建时间在保存的时候一样
			yearReportInsurance.setCreateTime(new Date());
			yearReportInsurance.setUpdateTime(yearReportInsurance.getCreateTime());
			//默认可用
			yearReportInsurance.setActive(true);
			yearReportInsurance.setUpdateBy(user.getUsername());
			yearReportInsuranceDao.save(yearReportInsurance);
		}
		}

	/**
	 * 删除
	 * @param yearReportInsurance
	 */

	@Override
	public void delete(YearReportInsurance yearReportInsurance) {
		yearReportInsurance.setUpdateTime(new Date());
		yearReportInsuranceDao.delete(yearReportInsurance);
	}

	/**
	 *根据ID查询
	 * @param id
	 */
	@Override
	public YearReportInsurance findById(long id){
		return yearReportInsuranceDao.findById(id);
	}

	/**
	 * 查询
	 * @param dto
	 * @return
	 */
	@Override
	public YearReportInsuranceSearchDto search(YearReportInsuranceSearchDto dto) {
		YearReportInsuranceSearchDto resultDto = new YearReportInsuranceSearchDto();
		List<YearReportInsurance> list =  yearReportInsuranceDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(yearReportInsuranceDao.count(dto));
		return resultDto;
	}

	@Override
	public List<YearReportInsurance> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return yearReportInsuranceDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void saveOrUpdateForDS(YearReportInsurance yearReportInsurance) {
		if(yearReportInsurance.getActive() == null){
			yearReportInsurance.setActive(true);
    	}
    	
		YearReportInsurance dbYearReportInsurance = yearReportInsuranceDao.findById(yearReportInsurance.getId());
        if (dbYearReportInsurance != null) {
        	if(yearReportInsurance.getUpdateTime().getTime() > dbYearReportInsurance.getUpdateTime().getTime()){
        		yearReportInsuranceDao.updateForDS(yearReportInsurance);
			}
        } else {
        	yearReportInsuranceDao.saveForDS(yearReportInsurance);
        }
	}

    @Override
    public List<YearReportInsurance> findByUserId(Long userId) {
        return yearReportInsuranceDao.findByCompanyId(userId);
    }
}


