package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.sb.VehicleLogDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.VehicleLogSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Vehicle;
import com.bcxin.ars.model.sb.VehicleLog;
import com.bcxin.ars.service.sb.VehicleLogService;
import com.bcxin.ars.service.sb.VehicleService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = VehicleLog.class)
public class VehicleLogServiceImpl implements VehicleLogService{

	@Autowired
	private VehicleLogDao vehicleLogDao;
	
	@Autowired
	private ArsUtil arsUtil;
	
	@Autowired
	private VehicleService vehicleService;

    @Autowired
    private SecurityPersonDao personDao;
	
	@Override
	public VehicleLog findById(long id) {
		return vehicleLogDao.findById(id);
	}

	@Override
	public void saveOrUpdate(VehicleLog vehicleLog) {

		User currentUser = arsUtil.getCurrentUser();
        User user = currentUser;

		if(vehicleLog.getId() == null){
			vehicleLog.setActive(true);
			vehicleLog.setCreateTime(new Date());
			vehicleLog.setUpdateTime(new Date());
			vehicleLog.setTime(new Date());
			vehicleLog.setUpdateBy(currentUser.getUsername());
			vehicleLog.setUserid(user.getId());
			vehicleLogDao.save(vehicleLog);
		}else{
			VehicleLog dbVehicleLog = vehicleLogDao.findById(vehicleLog.getId());
			dbVehicleLog.setUpdateBy(currentUser.getRealname());
			dbVehicleLog.setUpdateTime(new Date());
			dbVehicleLog.setRemarks(vehicleLog.getRemarks());
			dbVehicleLog.setOperator(vehicleLog.getOperator());
			dbVehicleLog.setType(vehicleLog.getType());
			dbVehicleLog.setName(vehicleLog.getName());
			dbVehicleLog.setTime(vehicleLog.getTime());
			dbVehicleLog.setUserid(vehicleLog.getUserid());
			vehicleLogDao.update(dbVehicleLog);
		}
		Vehicle vehicle = vehicleService.findById(vehicleLog.getVehicleid());
		//车辆状态等于借出
		if(Constants.VEHICLETYPE_LOAN.equals(vehicleLog.getType())){
			vehicle.setSenddate(vehicleLog.getTime());
		    vehicle.setClstate(Constants.VEHICLETYPE_LOAN);
		    vehicle.setReturndate(null);
		}else{
			vehicle.setReturndate(vehicleLog.getTime());
			//车辆返还
			vehicle.setClstate(Constants.VEHICLETYPE_RETURN);
		}
		vehicleService.saveOrUpdate(vehicle);
	}

	@Override
	public VehicleLogSearchDto search(VehicleLogSearchDto dto) {
		VehicleLogSearchDto resultDto = new VehicleLogSearchDto();
		List<VehicleLog> list =  vehicleLogDao.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(vehicleLogDao.searchCount(dto));
		return resultDto;
	}

	@Override
	public void delete(VehicleLog vehicleLog) {
		User currentUser = arsUtil.getCurrentUser();
		vehicleLog.setUpdateBy(currentUser.getUsername());
		vehicleLog.setUpdateTime(new Date());
		vehicleLogDao.delete(vehicleLog);
	}

	@Override
	public List<VehicleLog> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
		return vehicleLogDao.searchForDataSynchronization(searchDto);
	}

	@Override
	public void saveOrUpdateForDS(VehicleLog vehicleLog) {
		if(vehicleLog.getActive() == null){
			vehicleLog.setActive(true);
		}
		
		if(!vehicleLog.getActive()){
			vehicleLogDao.delete(vehicleLog);
		}else{
			VehicleLog dbVehicleLog = vehicleLogDao.findById(vehicleLog.getId());
			if(dbVehicleLog == null){
				vehicleLogDao.saveForDS(vehicleLog);
			}else{
				if(vehicleLog.getUpdateTime().getTime() > dbVehicleLog.getUpdateTime().getTime()){
					vehicleLogDao.update(vehicleLog);
				}
			}
		}
	}

	@Override
	public void searchForPage(VehicleLogSearchDto searchDto, AjaxPageResponse<VehicleLog> page) {
		arsUtil.setPoliceSearch(searchDto);
		vehicleLogDao.searchForPage(searchDto,page);
	}

}
